/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.IComboProvider;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.StyleCombo;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class StyleComboPropertyDescriptor
extends PropertyDescriptor {
    protected StyleCombo combo;
    protected IChoiceSet choiceSet;
    protected String oldValue;
    private int style = 2056;
    private String text;

    public StyleComboPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }

    void refresh(String value) {
        this.combo.setSelectedItem((Object)value);
    }

    public Control getControl() {
        return this.combo;
    }

    public Control createControl(Composite parent) {
        assert (this.getDescriptorProvider() instanceof IComboProvider);
        this.combo = this.isFormStyle() ? FormWidgetFactory.getInstance().createStyleCombo(parent, (IComboProvider)this.getDescriptorProvider()) : new StyleCombo(parent, this.style, (IComboProvider)this.getDescriptorProvider());
        this.combo.setItems(((IComboProvider)this.getDescriptorProvider()).getItems());
        if (this.text != null) {
            this.combo.setSelectedItem((Object)this.text);
        }
        this.combo.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                StyleComboPropertyDescriptor.this.combo.clearSelection();
            }

            public void controlResized(ControlEvent e) {
                StyleComboPropertyDescriptor.this.combo.clearSelection();
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StyleComboPropertyDescriptor.this.handleComboSelectEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                StyleComboPropertyDescriptor.this.handleComboSelectEvent();
            }
        });
        return this.combo;
    }

    protected void handleComboSelectEvent() {
        CommandStack stack = this.getActionStack();
        stack.startTrans("");
        try {
            this.save((String)this.combo.getSelectedItem());
        }
        catch (SemanticException e1) {
            stack.rollback();
            WidgetUtil.processError((Shell)this.combo.getShell(), (Exception)((Object)e1));
        }
        stack.commit();
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
    }

    public void save(Object value) throws SemanticException {
        this.descriptorProvider.save(value);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.combo, (boolean)isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.combo.setVisible(isVisible);
    }

    public void load() {
        this.oldValue = this.getDescriptorProvider().load().toString();
        this.refresh(this.oldValue);
    }

    public void addStyle(int style) {
        this.style |= style;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        if (this.combo != null) {
            this.combo.setSelectedItem((Object)text);
        }
    }
}

