/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ImportCSSStyleAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ReloadCssStyleAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.UseCssStyleAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.StyleBuilder;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementDetailHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public class ThemeNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        if (this.canContain(object)) {
            menu.add((IAction)new InsertAction(object, Messages.getString((String)"StylesNodeProvider.action.New")));
        }
        super.createContextMenu(sourceViewer, object, menu);
        if (this.canContain(object)) {
            menu.insertAfter("additions", (IContributionItem)new Separator());
            menu.insertAfter("additions", (IAction)new ImportCSSStyleAction(object));
        }
        menu.insertAfter("additions", (IAction)new ReloadCssStyleAction(object));
        menu.insertAfter("additions", (IAction)new UseCssStyleAction(object));
    }

    public String getNodeDisplayName(Object model) {
        return ((ThemeHandle)model).getDisplayLabel();
    }

    protected DesignElementHandle createElement(ElementDetailHandle slotHandle, String type) throws Exception {
        ThemeHandle theme = (ThemeHandle)slotHandle.getElementHandle();
        DesignElementFactory factory = DesignElementFactory.getInstance();
        SharedStyleHandle handle = factory.newStyle((AbstractThemeHandle)theme, null);
        StyleBuilder builder = new StyleBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (ReportElementHandle)handle, (AbstractThemeHandle)theme, StyleBuilder.DLG_TITLE_NEW);
        if (builder.open() == 1) {
            return null;
        }
        return handle;
    }

    public Object[] getChildren(Object model) {
        if (model instanceof ThemeHandle) {
            ThemeHandle theme = (ThemeHandle)model;
            int styleCount = 0;
            int count = styleCount += super.getChildrenBySlotHandle(((ThemeHandle)model).getStyles()).length;
            Object[] obj = new Object[count += theme.getAllCssStyleSheets().size()];
            int i = 0;
            while (i < styleCount) {
                obj[i] = super.getChildrenBySlotHandle(((ThemeHandle)model).getStyles())[i];
                ++i;
            }
            i = 0;
            while (i < theme.getAllCssStyleSheets().size()) {
                obj[styleCount + i] = theme.getAllCssStyleSheets().get(i);
                ++i;
            }
            Arrays.sort(obj, new AlphabeticallyComparator());
            return obj;
        }
        return super.getChildren(model);
    }

    private boolean canContain(Object object) {
        if (object instanceof ThemeHandle) {
            return ((ThemeHandle)object).canContain(0, "Style");
        }
        return true;
    }
}

