/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UserPropertyBuilder
extends BaseDialog {
    public static final int USER_PROPERTY = 0;
    public static final int NAMED_EXPRESSION = 1;
    private static final String PROPERTY_TITLE = Messages.getString((String)"UserPropertyBuilder.0");
    private static final String EXPRESSION_TITLE = Messages.getString((String)"UserPropertyBuilder.Title.NamedExpression");
    private static final String ERROR_MSG_NAME_IS_REQUIRED = Messages.getString((String)"UserPropertyBuilder.ErrorMessage.NoName");
    private static final String ERROR_MSG_NAME_DUPLICATED = Messages.getString((String)"UserPropertyBuilder.ErrorMessage.DuplicatedName");
    private static final String LABEL_PROPERTY_NAME = Messages.getString((String)"UserPropertyBuilder.Label.PropertyName");
    private static final String LABEL_EXPRESSION_NAME = Messages.getString((String)"UserPropertyBuilder.Label.ExpressionName");
    private static final String LABEL_TYPE = Messages.getString((String)"UserPropertyBuilder.Label.PropertyType");
    private static final String LABEL_DEFAULT_VALUE = Messages.getString((String)"UserPropertyBuilder.Label.DefaultValue");
    private static final Image ERROR_ICON = ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK");
    private static PropertyType[] PROPERTY_TYPES;
    private static PropertyType EXPRESSION_TYPE;
    private DesignElementHandle input;
    private int style;
    private Text nameEditor;
    private Text defaultValueEditor;
    private Combo typeChooser;
    private CLabel messageLine;

    static {
        ArrayList typeList = new ArrayList(UserPropertyDefn.getAllowedTypes());
        EXPRESSION_TYPE = DEUtil.getMetaDataDictionary().getPropertyType(7);
        typeList.remove(EXPRESSION_TYPE);
        PROPERTY_TYPES = typeList.toArray(new PropertyType[0]);
    }

    public UserPropertyBuilder(int style) {
        super(UIUtil.getDefaultShell(), "");
        this.style = style;
        switch (this.style) {
            case 0: {
                this.setTitle(PROPERTY_TITLE);
                break;
            }
            case 1: {
                this.setTitle(EXPRESSION_TITLE);
            }
        }
    }

    protected boolean initDialog() {
        switch (this.style) {
            case 0: {
                this.typeChooser.setText(new UserPropertyDefn().getType().getDisplayName());
            }
        }
        this.checkName();
        return super.initDialog();
    }

    protected Control createDialogArea(Composite parent) {
        switch (this.style) {
            case 0: {
                UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddEditUserProperties_ID");
                break;
            }
            case 1: {
                UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddEditNamedExpression_ID");
            }
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        composite.setLayout((Layout)layout);
        this.messageLine = new CLabel(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.messageLine.setLayoutData((Object)gd);
        switch (this.style) {
            case 0: {
                new Label(composite, 0).setText(LABEL_PROPERTY_NAME);
                break;
            }
            case 1: {
                new Label(composite, 0).setText(LABEL_EXPRESSION_NAME);
            }
        }
        this.nameEditor = new Text(composite, 2052);
        gd = new GridData(768);
        gd.widthHint = 200;
        this.nameEditor.setLayoutData((Object)gd);
        this.nameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserPropertyBuilder.this.checkName();
            }
        });
        switch (this.style) {
            case 0: {
                new Label(composite, 0).setText(LABEL_TYPE);
                this.typeChooser = new Combo(composite, 2056);
                this.typeChooser.setLayoutData((Object)new GridData(768));
                this.typeChooser.setVisibleItemCount(30);
                int i = 0;
                while (i < PROPERTY_TYPES.length) {
                    this.typeChooser.add(PROPERTY_TYPES[i].getDisplayName(), i);
                    ++i;
                }
                break;
            }
            case 1: {
                new Label(composite, 0).setText(LABEL_DEFAULT_VALUE);
                Composite subComposite = new Composite(composite, 0);
                subComposite.setLayoutData((Object)new GridData(768));
                subComposite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
                this.defaultValueEditor = new Text(subComposite, 2050);
                gd = new GridData(768);
                gd.heightHint = this.defaultValueEditor.computeSize((int)-1, (int)-1).y - this.defaultValueEditor.getBorderWidth() * 2;
                this.defaultValueEditor.setLayoutData((Object)gd);
                this.createComplexExpressionButton(subComposite, this.defaultValueEditor);
            }
        }
        return composite;
    }

    private void createComplexExpressionButton(Composite parent, Text text) {
        ExpressionButtonUtil.createExpressionButton(parent, (Control)text, new ExpressionProvider(this.input), this.input);
    }

    protected void okPressed() {
        UserPropertyDefn def = new UserPropertyDefn();
        def.setName(this.nameEditor.getText().trim());
        switch (this.style) {
            case 0: {
                def.setType(PROPERTY_TYPES[this.typeChooser.getSelectionIndex()]);
                break;
            }
            case 1: {
                def.setType(EXPRESSION_TYPE);
                def.setDefault((Object)ExpressionButtonUtil.getExpression((Control)this.defaultValueEditor));
            }
        }
        this.setResult(def);
        super.okPressed();
    }

    public void setInput(DesignElementHandle handle) {
        this.input = handle;
    }

    private void checkName() {
        String errorMessage = null;
        String name = this.nameEditor.getText().trim();
        if (name.length() == 0) {
            errorMessage = ERROR_MSG_NAME_IS_REQUIRED;
            this.messageLine.setImage(null);
        } else if (this.input.getPropertyHandle(name) != null) {
            errorMessage = ERROR_MSG_NAME_DUPLICATED;
            this.messageLine.setImage(ERROR_ICON);
        }
        if (errorMessage != null) {
            this.messageLine.setText(errorMessage);
        } else {
            this.messageLine.setText("");
            this.messageLine.setImage(null);
        }
        this.getOkButton().setEnabled(errorMessage == null);
    }
}

