/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.templates.IDynamicTemplateProvider;
import org.eclipse.birt.report.designer.ui.templates.ITemplateAdaptable;
import org.eclipse.birt.report.designer.ui.templates.ITemplateEntry;
import org.eclipse.birt.report.designer.ui.templates.ITemplateFile;
import org.eclipse.birt.report.designer.ui.templates.ITemplateFolder;
import org.eclipse.birt.report.designer.ui.templates.ITemplateProvider;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionTemplateListProvider
implements ILabelProvider,
ITreeContentProvider,
ITemplateAdaptable {
    private List<ITemplateProvider> providers;
    private List<TemplateNode> list = new ArrayList<TemplateNode>();
    private Map<String, TemplateNode> map = new HashMap<String, TemplateNode>();
    private volatile TemplateUICallback uiCallback;
    private IDynamicTemplateProvider.Callback providerCallback = new IDynamicTemplateProvider.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contentChanged(IDynamicTemplateProvider who) {
            if (ExtensionTemplateListProvider.this.uiCallback != null) {
                TemplateUICallback templateUICallback = ExtensionTemplateListProvider.this.uiCallback;
                synchronized (templateUICallback) {
                    Display disp = Display.getCurrent();
                    if (disp == null) {
                        disp = Display.getDefault();
                    }
                    disp.syncExec(new Runnable(){

                        public void run() {
                            ExtensionTemplateListProvider.this.list.clear();
                            ExtensionTemplateListProvider.this.map.clear();
                            ExtensionTemplateListProvider.this.buildList();
                            ExtensionTemplateListProvider.this.uiCallback.contentChanged();
                        }
                    });
                }
            }
        }
    };

    public ExtensionTemplateListProvider(TemplateUICallback uiCallback) {
        this.uiCallback = uiCallback;
        this.providers = new ArrayList<ITemplateProvider>();
        Object[] objs = this.getTemplateProviders();
        if (objs != null) {
            int i = 0;
            while (i < objs.length) {
                if (objs[i] instanceof ITemplateProvider) {
                    this.providers.add((ITemplateProvider)objs[i]);
                }
                ++i;
            }
        }
        this.buildList();
    }

    private void buildList() {
        int i = 0;
        while (i < this.providers.size()) {
            this.build(this.providers.get(i));
            ++i;
        }
        this.unionOneOrder(this.list);
        i = 0;
        while (i < this.list.size()) {
            this.unionSameOrder(this.list.get(i));
            ++i;
        }
    }

    private void build(ITemplateProvider provider) {
        ITemplateEntry[] entrys;
        if (provider instanceof IDynamicTemplateProvider) {
            ((IDynamicTemplateProvider)provider).init(this.providerCallback);
        }
        if ((entrys = provider.getTemplates()) == null) {
            return;
        }
        String id = provider.getParentBaseName();
        TemplateNode other = this.map.get(id);
        int i = 0;
        while (i < entrys.length) {
            block7: {
                TemplateNode first;
                ITemplateEntry entry = entrys[i];
                try {
                    first = this.addNodes(null, entry);
                }
                catch (InvalidIDException invalidIDException) {
                    break block7;
                }
                if (other != null) {
                    this.union(other, first);
                } else {
                    this.list.add(first);
                }
            }
            ++i;
        }
    }

    private TemplateNode addNodes(TemplateNode parent, ITemplateEntry entry) throws InvalidIDException {
        TemplateNode current = new TemplateNode(parent, entry.getName(), entry.getImage());
        if (entry instanceof ITemplateFile) {
            current.setHandle(((ITemplateFile)entry).getReportHandle());
        } else if (entry instanceof ITemplateFolder) {
            ITemplateEntry[] children;
            ITemplateFolder folder = (ITemplateFolder)entry;
            String folderName = folder.getBaseName();
            if (folderName == null) {
                throw new InvalidIDException("Invalid ID");
            }
            boolean isExist = false;
            current.setBaseName(folderName);
            TemplateNode node = this.map.get(folderName);
            if (node != null) {
                isExist = true;
            }
            if (!isExist) {
                this.map.put(folderName, current);
            }
            if ((children = folder.getChildren()) != null) {
                int i = 0;
                while (i < children.length) {
                    this.addNodes(current, children[i]);
                    ++i;
                }
            }
        }
        return current;
    }

    private void unionSameOrder(TemplateNode root) {
        List<TemplateNode> list = root.getChildren();
        this.unionOneOrder(list);
        int i = 0;
        while (i < list.size()) {
            TemplateNode node = list.get(i);
            this.unionSameOrder(node);
            ++i;
        }
    }

    private void unionOneOrder(List<TemplateNode> list) {
        ArrayList<TemplateNode> temp = new ArrayList<TemplateNode>(list);
        HashMap<String, TemplateNode> names = new HashMap<String, TemplateNode>();
        int i = 0;
        while (i < temp.size()) {
            TemplateNode node = (TemplateNode)temp.get(i);
            if (names.keySet().contains(node.getBaseName())) {
                TemplateNode parent = this.map.get(node.getBaseName());
                List<TemplateNode> children = node.getChildren();
                int j = 0;
                while (j < children.size()) {
                    TemplateNode child = children.get(j);
                    child.setParent(parent);
                    list.remove(node);
                    ++j;
                }
            } else if (node.getBaseName() != null) {
                names.put(node.getBaseName(), node);
            }
            ++i;
        }
    }

    private void union(TemplateNode owner, TemplateNode folder) {
        folder.setParent(owner);
    }

    public Image getImage(Object element) {
        if (element instanceof TemplateNode) {
            return ((TemplateNode)element).getImage();
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof TemplateNode) {
            String str = ((TemplateNode)element).getName();
            if (str == null) {
                ReportDesignHandle handle = ((TemplateNode)element).getHandle();
                str = handle.getDisplayName();
            }
            str = Messages.getString((String)str);
            return str;
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        this.uiCallback = null;
        int i = 0;
        while (i < this.providers.size()) {
            this.providers.get(i).release();
            ++i;
        }
        this.providers.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TemplateNode) {
            return ((TemplateNode)parentElement).getChildren().toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof TemplateNode) {
            return ((TemplateNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public ReportDesignHandle getReportDesignHandle(Object element) {
        if (element instanceof TemplateNode) {
            return ((TemplateNode)element).getHandle();
        }
        return null;
    }

    public Object[] getRootElements() {
        return this.list.toArray();
    }

    private Object[] getTemplateProviders() {
        Object[] retValue = ElementAdapterManager.getAdapters(this, ITemplateProvider.class);
        if (retValue == null) {
            retValue = new ITemplateProvider[]{};
        }
        return retValue;
    }

    private static class InvalidIDException
    extends Exception {
        InvalidIDException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TemplateNode {
        private TemplateNode parent;
        private List<TemplateNode> children = new ArrayList<TemplateNode>();
        private String name;
        private String baseName;
        private ReportDesignHandle handle;
        private Image image;

        TemplateNode(TemplateNode parent, String name, Image image) {
            if (parent != null && !parent.isLeaf()) {
                throw new RuntimeException("Add a node to the a no leaf node");
            }
            this.parent = parent;
            if (parent != null) {
                parent.addChild(this);
            }
            this.name = name;
            this.image = image;
        }

        public TemplateNode getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public void setBaseName(String baseName) {
            this.baseName = baseName;
        }

        public ReportDesignHandle getHandle() {
            return this.handle;
        }

        public void setHandle(ReportDesignHandle handle) {
            this.handle = handle;
        }

        public Image getImage() {
            return this.image;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        void addChild(TemplateNode node) {
            this.children.add(node);
        }

        void removeChild(TemplateNode node) {
            this.children.remove(node);
        }

        public boolean isLeaf() {
            return this.handle == null && this.baseName != null;
        }

        public List<TemplateNode> getChildren() {
            return this.children;
        }

        public void setParent(TemplateNode parent) {
            this.parent = parent;
            if (parent != null) {
                parent.addChild(this);
            }
        }
    }

    static interface TemplateUICallback {
        public void contentChanged();
    }
}

