/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatAdapter;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SortkeyBuilder
extends BaseTitleAreaDialog {
    protected Logger logger = Logger.getLogger(SortkeyBuilder.class.getName());
    public static final String DLG_TITLE_NEW = Messages.getString((String)"SortkeyBuilder.DialogTitle.New");
    public static final String DLG_MESSAGE_NEW = Messages.getString((String)"SortkeyBuilder.DialogMessage.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"SortkeyBuilder.DialogTitle.Edit");
    public static final String DLG_MESSAGE_EDIT = Messages.getString((String)"SortkeyBuilder.DialogMessage.Edit");
    protected SortKeyHandle sortKey;
    protected DesignElementHandle handle;
    protected IChoiceSet choiceSet;
    protected Combo comboDirection;
    private Combo comboKey;
    protected List<ComputedColumnHandle> columnList;
    private static final String[] EMPTY = new String[0];
    public static final Map<String, Integer> STRENGTH_MAP = new HashMap<String, Integer>();
    protected String title;
    protected String message;
    private Combo comboLocale;
    private Combo comboStrength;
    protected Listener comboKeyModify = new Listener(){

        public void handleEvent(Event e) {
            String value;
            if (!$assertionsDisabled && !(e.widget instanceof Combo)) {
                throw new AssertionError();
            }
            Combo combo = (Combo)e.widget;
            String newValue = combo.getText();
            IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)combo);
            if (converter != null && (value = ExpressionUtility.getExpression(SortkeyBuilder.this.getResultSetColumn(newValue), converter)) != null) {
                newValue = value;
            }
            combo.setText(newValue);
            SortkeyBuilder.this.updateButtons();
        }
    };

    static {
        STRENGTH_MAP.put(Messages.getString((String)"SortkeyBuilder.Strength.ASCII"), -1);
        STRENGTH_MAP.put(Messages.getString((String)"SortkeyBuilder.Strength.PRIMARY"), 0);
        STRENGTH_MAP.put(Messages.getString((String)"SortkeyBuilder.Strength.SECONDARY"), 1);
        STRENGTH_MAP.put(Messages.getString((String)"SortkeyBuilder.Strength.TERTIARY"), 2);
        STRENGTH_MAP.put(Messages.getString((String)"SortkeyBuilder.Strength.QUATERNARY"), 3);
        STRENGTH_MAP.put(Messages.getString((String)"SortkeyBuilder.Strength.IDENTICAL"), 15);
    }

    public SortkeyBuilder(String title, String message) {
        this(UIUtil.getDefaultShell(), title, message);
    }

    public SortkeyBuilder(Shell parentShell, String title, String message) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.choiceSet = ChoiceSetFactory.getStructChoiceSet("SortKey", "direction");
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddEditSortkey_ID");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setLayout((Layout)new GridLayout());
        this.setTitle(this.title);
        this.setMessage(this.message);
        this.getShell().setText(this.title);
        SortkeyBuilder.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        this.createInputContents(contents);
        Composite space = new Composite(contents, 0);
        GridData gdata = new GridData(768);
        gdata.heightHint = 10;
        space.setLayoutData((Object)gdata);
        Label lb = new Label(contents, 258);
        lb.setLayoutData((Object)new GridData(768));
        return area;
    }

    protected Composite createInputContents(Composite parent) {
        Label lb = new Label(parent, 0);
        lb.setText(Messages.getString((String)"SortkeyBuilder.DialogTitle.Label.Prompt"));
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(768));
        GridLayout glayout = new GridLayout(3, false);
        content.setLayout((Layout)glayout);
        Label labelKey = new Label(content, 0);
        labelKey.setText(Messages.getString((String)"SortkeyBuilder.DialogTitle.Label.Key"));
        this.comboKey = new Combo(content, 2048);
        GridData gdata = new GridData(768);
        gdata.widthHint = 240;
        this.comboKey.setLayoutData((Object)gdata);
        this.comboKey.setVisibleItemCount(30);
        this.comboKey.setItems(this.getDataSetColumns());
        if (this.comboKey.getItemCount() == 0) {
            this.comboKey.add(DEUtil.resolveNull(null));
        }
        this.comboKey.addListener(13, this.comboKeyModify);
        this.comboKey.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SortkeyBuilder.this.updateButtons();
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                SortkeyBuilder.this.updateButtons();
            }
        };
        ExpressionButtonUtil.createExpressionButton(content, (Control)this.comboKey, (IExpressionProvider)this.getExpressionProvider(), (Object)this.handle, listener);
        Label labelDirection = new Label(content, 0);
        labelDirection.setText(Messages.getString((String)"SortkeyBuilder.DialogTitle.Label.Direction"));
        this.comboDirection = new Combo(content, 2056);
        String[] displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(this.choiceSet);
        this.comboDirection.setVisibleItemCount(30);
        this.comboDirection.setItems(displayNames);
        gdata = new GridData(768);
        this.comboDirection.setLayoutData((Object)gdata);
        new Label(content, 0);
        Label labelLocale = new Label(content, 0);
        labelLocale.setText(Messages.getString((String)"SortkeyBuilder.Label.Locale"));
        this.comboLocale = new Combo(content, 2056);
        gdata = new GridData(768);
        this.comboLocale.setLayoutData((Object)gdata);
        this.comboLocale.setVisibleItemCount(30);
        ArrayList<String> localeNames = new ArrayList<String>();
        localeNames.add(Messages.getString((String)"SortkeyBuilder.Locale.Auto"));
        localeNames.addAll(FormatAdapter.LOCALE_TABLE.keySet());
        this.comboLocale.setItems(localeNames.toArray(new String[0]));
        this.comboLocale.select(0);
        new Label(content, 0);
        Label labelStrength = new Label(content, 0);
        labelStrength.setText(Messages.getString((String)"SortkeyBuilder.Label.Strength"));
        this.comboStrength = new Combo(content, 2056);
        gdata = new GridData(768);
        this.comboStrength.setLayoutData((Object)gdata);
        this.comboStrength.setVisibleItemCount(30);
        ArrayList<String> strengthNames = new ArrayList<String>(STRENGTH_MAP.keySet());
        Collections.sort(strengthNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return STRENGTH_MAP.get(o1) - STRENGTH_MAP.get(o2);
            }
        });
        this.comboStrength.setItems(strengthNames.toArray(new String[0]));
        this.comboStrength.select(0);
        return content;
    }

    protected ExpressionProvider getExpressionProvider() {
        return new ExpressionProvider(this.handle);
    }

    private Object getResultSetColumn(String name) {
        if (this.columnList == null || this.columnList.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < this.columnList.size()) {
            ComputedColumnHandle column = this.columnList.get(i);
            if (column.getName().equals(name)) {
                return column;
            }
            ++i;
        }
        return null;
    }

    public int open() {
        if (this.getShell() == null) {
            this.create();
        }
        if (this.initDialog()) {
            if (Policy.TRACING_DIALOGS) {
                String[] result = ((Object)((Object)this)).getClass().getName().split("\\.");
                System.out.println("Dialog >> Open " + result[result.length - 1]);
            }
            return super.open();
        }
        return 1;
    }

    protected boolean initDialog() {
        if (this.sortKey == null) {
            this.comboKey.setText("");
            this.comboDirection.select(0);
            return true;
        }
        ExpressionButtonUtil.initExpressionButtonControl((Control)this.comboKey, this.sortKey, "key");
        if (this.sortKey.getDirection() != null && this.sortKey.getDirection().trim().length() != 0) {
            int index;
            String value = this.sortKey.getDirection().trim();
            IChoice choice = this.choiceSet.findChoice(value);
            if (choice != null) {
                value = choice.getDisplayName();
            }
            index = (index = this.comboDirection.indexOf(value)) < 0 ? 0 : index;
            this.comboDirection.select(index);
        }
        if (this.sortKey.getLocale() != null) {
            String locale = null;
            for (Map.Entry<String, ULocale> entry : FormatAdapter.LOCALE_TABLE.entrySet()) {
                if (!this.sortKey.getLocale().equals((Object)entry.getValue())) continue;
                locale = entry.getKey();
            }
            if (locale != null) {
                int index = this.comboLocale.indexOf(locale);
                this.comboLocale.select(index < 0 ? 0 : index);
            }
        }
        String strength = null;
        for (Map.Entry<String, Integer> entry : STRENGTH_MAP.entrySet()) {
            if (this.sortKey.getStrength() != entry.getValue().intValue()) continue;
            strength = entry.getKey();
        }
        if (strength != null) {
            int index = this.comboStrength.indexOf(strength);
            this.comboStrength.select(index < 0 ? 0 : index);
        }
        this.updateButtons();
        return true;
    }

    protected String[] getDataSetColumns() {
        if (this.columnList.isEmpty()) {
            return EMPTY;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < this.columnList.size()) {
            ComputedColumnHandle columnHandle = this.columnList.get(i);
            if (columnHandle.getAggregateFunction() == null) {
                valueList.add(columnHandle.getName());
            }
            ++i;
        }
        return valueList.toArray(new String[valueList.size()]);
    }

    public void setHandle(DesignElementHandle handle) {
        this.handle = handle;
        this.inilializeColumnList(handle);
    }

    protected void inilializeColumnList(DesignElementHandle handle) {
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
    }

    protected void okPressed() {
        String direction = this.comboDirection.getText();
        IChoice choice = this.choiceSet.findChoiceByDisplayName(direction);
        if (choice != null) {
            direction = choice.getDisplayName();
        }
        int index = this.comboDirection.indexOf(direction);
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(this.title);
        try {
            if (this.sortKey == null) {
                String locale;
                SortKey sortKey = StructureFactory.createSortKey();
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.comboKey, sortKey, "key");
                if (index >= 0) {
                    sortKey.setDirection(choice.getName());
                }
                if (FormatAdapter.LOCALE_TABLE.containsKey(locale = this.comboLocale.getText())) {
                    sortKey.setLocale(FormatAdapter.LOCALE_TABLE.get(locale));
                } else {
                    sortKey.setLocale(null);
                }
                String strength = this.comboStrength.getText();
                if (STRENGTH_MAP.containsKey(strength)) {
                    sortKey.setStrength(STRENGTH_MAP.get(strength).intValue());
                } else {
                    sortKey.setStrength(-1);
                }
                PropertyHandle propertyHandle = this.handle.getPropertyHandle("sort");
                propertyHandle.addItem((IStructure)sortKey);
            } else {
                String locale;
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.comboKey, this.sortKey, "key");
                if (index >= 0) {
                    this.sortKey.setDirection(choice.getName());
                }
                if (FormatAdapter.LOCALE_TABLE.containsKey(locale = this.comboLocale.getText())) {
                    this.sortKey.setLocale(FormatAdapter.LOCALE_TABLE.get(locale));
                } else {
                    this.sortKey.setLocale(null);
                }
                String strength = this.comboStrength.getText();
                if (STRENGTH_MAP.containsKey(strength)) {
                    this.sortKey.setStrength(STRENGTH_MAP.get(strength).intValue());
                } else {
                    this.sortKey.setStrength(-1);
                }
            }
            stack.commit();
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e, Messages.getString((String)"SortkeyBuilder.DialogTitle.Error.SetSortKey.Title"), e.getLocalizedMessage());
            stack.rollback();
        }
        super.okPressed();
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performOk() {
        return true;
    }

    public void setInput(Object input) {
        this.sortKey = input instanceof SortKeyHandle ? (SortKeyHandle)input : null;
    }

    protected void updateButtons() {
        this.getButton(0).setEnabled(this.isConditionOK());
    }

    protected boolean isConditionOK() {
        return this.comboKey.getText().trim().length() != 0;
    }
}

