/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.AutoResizeTableLayout;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class DataSetBindingSelector
extends BaseDialog {
    public static final String NONE = Messages.getString((String)"BindingPage.None");
    private CheckboxTableViewer columnViewers;
    private Combo dataSetCombo;
    private String dataSetName;
    private DataSetHandle datasetHandle;
    private String[] columns;
    private boolean validateEmptyResults = false;
    private List<DataSetHandle> datasets;
    private static final IChoice[] DATA_TYPE_CHOICES = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices().getChoices();
    private Object[] result;

    public DataSetBindingSelector(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public Control createDialogArea(Composite parent) {
        org.eclipse.birt.report.designer.ui.util.UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.DataSetBindingSelector_ID");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        contents.setLayout((Layout)layout);
        this.createDataSetContents(contents);
        this.createColumnBindingContents(contents);
        return area;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.enableOKButton();
        return control;
    }

    protected void createColumnBindingContents(Composite parent) {
        this.columnViewers = CheckboxTableViewer.newCheckList((Composite)parent, (int)67616);
        GridData data = new GridData(1808);
        data.widthHint = 450;
        data.heightHint = 200;
        data.horizontalSpan = 2;
        data.verticalIndent = 5;
        this.columnViewers.getTable().setLayoutData((Object)data);
        this.columnViewers.getTable().setHeaderVisible(true);
        this.columnViewers.getTable().setLinesVisible(true);
        new TableColumn(this.columnViewers.getTable(), 0).setText("");
        new TableColumn(this.columnViewers.getTable(), 0).setText(Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.Name"));
        new TableColumn(this.columnViewers.getTable(), 0).setText(Messages.getString((String)"DataSetColumnBindingsFormHandleProvider.Column.DataType"));
        AutoResizeTableLayout layout = new AutoResizeTableLayout(this.columnViewers.getTable());
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(6, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(47, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(47, true));
        this.columnViewers.getTable().setLayout((Layout)layout);
        this.columnViewers.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataSetBindingSelector.this.enableOKButton();
            }
        });
        DataSetColumnProvider provider = new DataSetColumnProvider();
        this.columnViewers.setLabelProvider((IBaseLabelProvider)provider);
        this.columnViewers.setContentProvider((IContentProvider)provider);
        Composite buttonContainer = new Composite(parent, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        buttonContainer.setLayoutData((Object)data);
        GridLayout gdLayout = new GridLayout();
        gdLayout.numColumns = 2;
        gdLayout.marginHeight = 0;
        gdLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)gdLayout);
        Button selectAllButton = new Button(buttonContainer, 8);
        selectAllButton.setText(Messages.getString((String)"DataSetBindingSelector.Button.SelectAll"));
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetBindingSelector.this.columnViewers.setAllChecked(true);
                DataSetBindingSelector.this.enableOKButton();
            }
        });
        Button deselectAllButton = new Button(buttonContainer, 8);
        deselectAllButton.setText(Messages.getString((String)"DataSetBindingSelector.Button.DeselectAll"));
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetBindingSelector.this.columnViewers.setAllChecked(false);
                DataSetBindingSelector.this.enableOKButton();
            }
        });
        this.handleDatasetComboSelectedEvent();
        if (this.columns != null) {
            int count = this.columnViewers.getTable().getItemCount();
            List<String> columnList = Arrays.asList(this.columns);
            int i = 0;
            while (i < count) {
                ResultSetColumnHandle column = (ResultSetColumnHandle)this.columnViewers.getElementAt(i);
                if (columnList.contains(column.getColumnName())) {
                    this.columnViewers.setChecked((Object)column, true);
                }
                ++i;
            }
        }
    }

    protected void createDataSetContents(Composite parent) {
        if (this.dataSetName != null) {
            Label lb = new Label(parent, 0);
            lb.setText(Messages.getString((String)"DataSetBindingSelector.Label.SelectBindingColumns"));
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            lb.setLayoutData((Object)data);
        } else {
            Label dateSetLabel = new Label(parent, 0);
            dateSetLabel.setText(Messages.getString((String)"DataSetBindingSelector.Combo.DataSet"));
            this.dataSetCombo = new Combo(parent, 2056);
            this.initDateSetHandles();
            this.dataSetCombo.setItems(this.getDataSetComboList());
            this.dataSetCombo.select(0);
            GridData data = new GridData(768);
            this.dataSetCombo.setLayoutData((Object)data);
            this.dataSetCombo.setVisibleItemCount(30);
            this.dataSetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataSetBindingSelector.this.handleDatasetComboSelectedEvent();
                }
            });
        }
    }

    private void initDateSetHandles() {
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        this.datasets = UIUtil.getVisibleDataSetHandles(handle);
    }

    private String[] getDataSetComboList() {
        String[] comboList = new String[this.datasets.size() + 1];
        comboList[0] = NONE;
        int i = 0;
        while (i < this.datasets.size()) {
            comboList[i + 1] = this.datasets.get(i).getQualifiedName();
            ++i;
        }
        return comboList;
    }

    private DataSetHandle getSelectedDataSet() {
        if (this.dataSetCombo.getSelectionIndex() > 0) {
            return this.datasets.get(this.dataSetCombo.getSelectionIndex() - 1);
        }
        return null;
    }

    protected void handleDatasetComboSelectedEvent() {
        Iterator iter = null;
        DataSetHandle handle = null;
        handle = this.datasetHandle != null ? this.datasetHandle : (this.dataSetName != null ? DataUtil.findDataSet(this.dataSetName) : this.getSelectedDataSet());
        if (handle != null) {
            try {
                CachedMetaDataHandle cmdh = DataSetUIUtil.getCachedMetaDataHandle(handle);
                iter = cmdh.getResultSet().iterator();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        } else {
            iter = new LinkedDataSetAdapter().getDataSetResLinkedDataModel(this.dataSetName);
        }
        if (iter != null) {
            this.columnViewers.setInput((Object)iter);
        } else {
            this.columnViewers.setInput(Collections.EMPTY_LIST.iterator());
        }
    }

    protected void okPressed() {
        this.result = new Object[3];
        if (this.dataSetName != null || this.dataSetCombo.getSelectionIndex() > 0) {
            this.result[0] = this.dataSetName == null ? this.dataSetCombo.getItem(this.dataSetCombo.getSelectionIndex()) : this.dataSetName;
            if (this.columnViewers.getCheckedElements() != null) {
                this.result[1] = this.columnViewers.getCheckedElements();
                ArrayList<String> list = new ArrayList<String>();
                int i = 0;
                while (i < this.columnViewers.getTable().getItemCount()) {
                    ResultSetColumnHandle column = (ResultSetColumnHandle)this.columnViewers.getElementAt(i);
                    if (!this.columnViewers.getChecked((Object)column)) {
                        list.add(column.getColumnName());
                    }
                    ++i;
                }
                this.result[2] = list.toArray();
            } else {
                this.result[1] = null;
                ArrayList<String> list = new ArrayList<String>();
                int i = 0;
                while (i < this.columnViewers.getTable().getItemCount()) {
                    ResultSetColumnHandle column = (ResultSetColumnHandle)this.columnViewers.getElementAt(i);
                    if (!this.columnViewers.getChecked((Object)column)) {
                        list.add(column.getColumnName());
                    }
                    ++i;
                }
                this.result[2] = list.isEmpty() ? null : list.toArray();
            }
        } else {
            this.result[0] = null;
            this.result[1] = null;
            this.result[2] = null;
        }
        super.okPressed();
    }

    public Object getResult() {
        return this.result;
    }

    public void setDataSet(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    private String getDataTypeDisplayName(String dataType) {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            IChoice choice = DATA_TYPE_CHOICES[i];
            if (choice.getName().equals(dataType)) {
                return choice.getDisplayName();
            }
            ++i;
        }
        return dataType;
    }

    private void enableOKButton() {
        if (this.getOkButton() != null && !this.getOkButton().isDisposed() && this.validateEmptyResults) {
            this.getOkButton().setEnabled(this.columnViewers.getCheckedElements().length > 0);
        }
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public void setValidateEmptyResults(boolean validateEmptyResults) {
        this.validateEmptyResults = validateEmptyResults;
    }

    public DataSetHandle getDatasetHandle() {
        return this.datasetHandle;
    }

    public void setDatasetHandle(DataSetHandle datasetHandle) {
        if (datasetHandle != null) {
            this.datasetHandle = datasetHandle;
            this.dataSetName = datasetHandle.getQualifiedName();
        }
    }

    class DataSetColumnProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        DataSetColumnProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Iterator) {
                Iterator iter = (Iterator)inputElement;
                ArrayList list = new ArrayList();
                while (iter.hasNext()) {
                    list.add(iter.next());
                }
                return list.toArray();
            }
            return new Object[0];
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ResultSetColumnHandle column = (ResultSetColumnHandle)element;
            if (columnIndex == 1) {
                return column.getColumnName();
            }
            if (columnIndex == 2) {
                return DataSetBindingSelector.this.getDataTypeDisplayName(column.getDataType());
            }
            return null;
        }
    }
}

