/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.executor.PageVariable;
import org.eclipse.birt.report.engine.internal.document.IPageHintWriter;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;
import org.eclipse.birt.report.engine.presentation.PageSection;
import org.eclipse.birt.report.engine.presentation.TableColumnHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class PageHintWriterV4
implements IPageHintWriter {
    protected IDocArchiveWriter writer;
    protected RAOutputStream indexStream;
    protected RAOutputStream hintsStream;
    private ByteArrayOutputStream writeBuffer = new ByteArrayOutputStream();
    private DataOutputStream hintBuffer = new DataOutputStream(this.writeBuffer);

    public PageHintWriterV4(IDocArchiveWriter writer) throws IOException {
        this.init(writer);
    }

    protected void init(IDocArchiveWriter writer) throws IOException {
        this.writer = writer;
        try {
            this.hintsStream = writer.createRandomAccessStream("/pages");
            this.hintsStream.writeInt(6);
            this.indexStream = writer.createRandomAccessStream("/pages_index");
            this.indexStream.writeLong(0L);
            this.indexStream.writeLong(-1L);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public void close() {
        try {
            if (this.hintsStream != null) {
                this.hintsStream.close();
                this.hintsStream = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.indexStream != null) {
                this.indexStream.close();
                this.indexStream = null;
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public void writePageHint(IPageHint pageHint) throws IOException {
        long offset = this.hintsStream.getOffset();
        this.indexStream.seek(pageHint.getPageNumber() * 8L + 8L);
        this.indexStream.writeLong(offset);
        this.writeBuffer.reset();
        this.writePageHint(this.hintBuffer, pageHint);
        this.hintsStream.write(this.writeBuffer.toByteArray());
    }

    @Override
    public void writeTotalPage(long totalPage) throws IOException {
        this.indexStream.seek(0L);
        this.indexStream.writeLong(totalPage);
    }

    @Override
    public void writePageVariables(Collection<PageVariable> variables) throws IOException {
        long offset = this.hintsStream.getOffset();
        this.writeBuffer.reset();
        this.writePageVariables(this.hintBuffer, variables);
        this.hintsStream.write(this.writeBuffer.toByteArray());
        this.hintsStream.flush();
        this.indexStream.seek(8L);
        this.indexStream.writeLong(offset);
    }

    protected void writePageHint(DataOutputStream out, IPageHint hint) throws IOException {
        IOUtil.writeLong(out, hint.getPageNumber());
        IOUtil.writeString(out, hint.getMasterPage());
        int sectionCount = hint.getSectionCount();
        IOUtil.writeInt(out, sectionCount);
        int i = 0;
        while (i < sectionCount) {
            PageSection section = hint.getSection(i);
            this.writeInstanceIndex(out, section.starts);
            this.writeInstanceIndex(out, section.ends);
            ++i;
        }
        int hintSize = hint.getUnresolvedRowCount();
        IOUtil.writeInt(out, hintSize);
        int i2 = 0;
        while (i2 < hintSize) {
            UnresolvedRowHint rowHint = hint.getUnresolvedRowHint(i2);
            rowHint.writeObject(out);
            ++i2;
        }
        int columnHintSize = hint.getTableColumnHintCount();
        IOUtil.writeInt(out, columnHintSize);
        int i3 = 0;
        while (i3 < columnHintSize) {
            TableColumnHint columnHint = hint.getTableColumnHint(i3);
            IOUtil.writeString(out, columnHint.getTableId());
            IOUtil.writeInt(out, columnHint.getStart());
            IOUtil.writeInt(out, columnHint.getColumnCount());
            ++i3;
        }
        Collection<PageVariable> variables = hint.getPageVariables();
        this.writePageVariables(out, variables);
    }

    protected void writeInstanceIndex(DataOutputStream out, InstanceIndex[] indexes) throws IOException {
        if (indexes == null) {
            IOUtil.writeInt(out, 0);
            return;
        }
        IOUtil.writeInt(out, indexes.length);
        int i = 0;
        while (i < indexes.length) {
            IOUtil.writeString(out, indexes[i].getInstanceID().toString());
            IOUtil.writeLong(out, indexes[i].getOffset());
            ++i;
        }
    }

    protected void writePageVariables(DataOutputStream out, Collection<PageVariable> variables) throws IOException {
        IOUtil.writeInt(out, variables.size());
        for (PageVariable variable : variables) {
            IOUtil.writeString(out, variable.getName());
            IOUtil.writeString(out, variable.getScope());
            IOUtil.writeObject(out, variable.getValue());
        }
    }
}

