/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.Area;
import uk.co.spudsoft.birt.emitters.excel.AreaBorders;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.CellImage;
import uk.co.spudsoft.birt.emitters.excel.ClientAnchorConversions;
import uk.co.spudsoft.birt.emitters.excel.Coordinate;
import uk.co.spudsoft.birt.emitters.excel.EmitterServices;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.RichTextRun;
import uk.co.spudsoft.birt.emitters.excel.StyleManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.AbstractHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;

public class CellContentHandler
extends AbstractHandler {
    private static final long oneDay = 86400000L;
    protected Object lastValue;
    protected IContent lastElement;
    protected List<RichTextRun> richTextRuns = new ArrayList<RichTextRun>();
    protected boolean lastCellContentsWasBlock;
    protected boolean lastCellContentsRequiresSpace;
    protected int colSpan;
    protected ContentEmitterVisitor contentVisitor;
    protected CSSValue preferredAlignment;
    protected String hyperlinkUrl;
    protected String hyperlinkBookmark;

    public CellContentHandler(IContentEmitter emitter, Logger log, IHandler parent, ICellContent cell) {
        super(log, parent, cell);
        this.contentVisitor = new ContentEmitterVisitor(emitter);
        this.colSpan = 1;
    }

    @Override
    public void startCell(HandlerState state, ICellContent cell) throws BirtException {
        if (cell.getBookmark() != null) {
            System.err.println("Bookmark: " + cell.getBookmark());
        }
    }

    protected void endCellContent(HandlerState state, ICellContent birtCell, IContent element, Cell cell, Area area) {
        float rowSpanHeightRequirement;
        String customNumberFormat;
        AreaBorders mergedRegionBorders;
        Hyperlink hyperlink;
        StyleManager sm = state.getSm();
        StyleManagerUtils smu = state.getSmu();
        BirtStyle birtCellStyle = null;
        if (birtCell != null) {
            birtCellStyle = new BirtStyle(birtCell);
            if (element != null) {
                birtCellStyle.overlay(element);
            }
        } else {
            birtCellStyle = element != null ? new BirtStyle(element) : new BirtStyle(state.getSm().getCssEngine());
        }
        if (this.preferredAlignment != null) {
            birtCellStyle.setProperty(23, this.preferredAlignment);
        }
        if ("transparent".equals(birtCellStyle.getString(8)) && this.parent != null) {
            birtCellStyle.setProperty(8, this.parent.getBackgroundColour());
        }
        if (this.hyperlinkUrl != null) {
            hyperlink = cell.getSheet().getWorkbook().getCreationHelper().createHyperlink(1);
            hyperlink.setAddress(this.hyperlinkUrl);
            cell.setHyperlink(hyperlink);
        }
        if (this.hyperlinkBookmark != null) {
            hyperlink = cell.getSheet().getWorkbook().getCreationHelper().createHyperlink(2);
            hyperlink.setAddress(CellContentHandler.prepareName(this.hyperlinkBookmark));
            cell.setHyperlink(hyperlink);
        }
        if (this.lastValue != null) {
            if (this.lastValue instanceof String) {
                String lastString = (String)this.lastValue;
                smu.correctFontColorIfBackground(birtCellStyle);
                for (RichTextRun run : this.richTextRuns) {
                    run.font = smu.correctFontColorIfBackground(sm.getFontManager(), state.getWb(), birtCellStyle, run.font);
                }
                if (!this.richTextRuns.isEmpty()) {
                    RichTextString rich = smu.createRichTextString(lastString);
                    int runStart = this.richTextRuns.get((int)0).startIndex;
                    Font lastFont = this.richTextRuns.get((int)0).font;
                    int i = 0;
                    while (i < this.richTextRuns.size()) {
                        RichTextRun run = this.richTextRuns.get(i);
                        this.log.debug("Run: ", run.startIndex, " font :", run.font);
                        if (!lastFont.equals(run.font)) {
                            this.log.debug("Applying ", runStart, " - ", run.startIndex);
                            rich.applyFont(runStart, run.startIndex, lastFont);
                            runStart = run.startIndex;
                            lastFont = this.richTextRuns.get((int)i).font;
                        }
                        ++i;
                    }
                    this.log.debug("Finalising with ", runStart, " - ", lastString.length());
                    rich.applyFont(runStart, lastString.length(), lastFont);
                    this.setCellContents(cell, rich);
                } else {
                    this.setCellContents(cell, lastString);
                }
                if (lastString.contains("\n") && !"nowrap".equals(this.lastElement.getStyle().getWhiteSpace())) {
                    birtCellStyle.setProperty(60, new StringValue(19, "pre"));
                }
                if (!this.richTextRuns.isEmpty()) {
                    birtCellStyle.setProperty(48, new StringValue(19, "top"));
                }
                if (this.preferredAlignment != null) {
                    birtCellStyle.setProperty(23, this.preferredAlignment);
                }
            } else {
                this.setCellContents(cell, this.lastValue);
            }
        }
        int colIndex = cell.getColumnIndex();
        state.getSmu().applyAreaBordersToCell(state.areaBorders, cell, birtCellStyle, state.rowNum, colIndex);
        if (birtCell != null && (birtCell.getColSpan() > 1 || birtCell.getRowSpan() > 1) && (mergedRegionBorders = AreaBorders.createForMergedCells(state.rowNum + birtCell.getRowSpan() - 1, colIndex, colIndex + birtCell.getColSpan() - 1, state.rowNum, birtCellStyle)) != null) {
            state.insertBorderOverload(mergedRegionBorders);
        }
        if ((customNumberFormat = EmitterServices.stringOption((ITaskOption)state.getRenderOptions(), element, "ExcelEmitter.CustomNumberFormat", null)) != null) {
            StyleManagerUtils.setNumberFormat(birtCellStyle, "ExcelEmitter.CustomNumberFormat" + customNumberFormat, null);
        }
        this.setCellStyle(sm, cell, birtCellStyle, this.lastValue);
        if ((this.colSpan > 1 || state.rowHasSpans(state.rowNum)) && (this.lastValue instanceof String || this.lastValue instanceof RichTextString)) {
            int spannedRowAlgorithm = EmitterServices.integerOption(state.getRenderOptions(), element, "ExcelEmitter.SpannedRowHeight", 0);
            Font defaultFont = state.getWb().getFontAt(cell.getCellStyle().getFontIndex());
            double cellWidth = this.spanWidthMillimetres(state.currentSheet, cell.getColumnIndex(), cell.getColumnIndex() + this.colSpan - 1);
            float cellDesiredHeight = smu.calculateTextHeightPoints(cell.getStringCellValue(), defaultFont, cellWidth, this.richTextRuns);
            if (cellDesiredHeight > state.requiredRowHeightInPoints) {
                int rowSpan = birtCell.getRowSpan();
                if (rowSpan < 2) {
                    state.requiredRowHeightInPoints = cellDesiredHeight;
                } else {
                    switch (spannedRowAlgorithm) {
                        case 1: {
                            state.requiredRowHeightInPoints = cellDesiredHeight;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            if (area == null) break;
                            area.setHeight(cellDesiredHeight);
                        }
                    }
                }
            }
        }
        if ((rowSpanHeightRequirement = state.calculateRowSpanHeightRequirement(state.rowNum)) > state.requiredRowHeightInPoints) {
            state.requiredRowHeightInPoints = rowSpanHeightRequirement;
        }
        if (EmitterServices.booleanOption((ITaskOption)state.getRenderOptions(), element, "ExcelEmitter.FreezePanes", false) && state.currentSheet.getPaneInformation() == null) {
            state.currentSheet.createFreezePane(state.colNum, state.rowNum);
        }
        this.lastValue = null;
        this.lastElement = null;
        this.richTextRuns.clear();
    }

    private double spanWidthMillimetres(Sheet sheet, int startCol, int endCol) {
        int result = 0;
        int columnIndex = startCol;
        while (columnIndex <= endCol) {
            result += sheet.getColumnWidth(columnIndex);
            ++columnIndex;
        }
        return ClientAnchorConversions.widthUnits2Millimetres(result);
    }

    private <T> void setCellContents(Cell cell, Object value) {
        this.log.debug("Setting cell[", cell.getRow().getRowNum(), ",", cell.getColumnIndex(), "] value to ", value);
        if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
            this.lastValue = value;
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
            this.lastValue = value;
        } else if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
            this.lastValue = value;
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
            this.lastValue = value;
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
            this.lastValue = value;
        } else if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
            this.lastValue = value;
        } else if (value instanceof String) {
            cell.setCellValue((String)value);
            this.lastValue = value;
        } else if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
            this.lastValue = value;
        } else if (value != null) {
            this.log.debug("Unhandled data: ", value == null ? "<null>" : value);
            cell.setCellValue(value.toString());
            this.lastValue = value;
        }
    }

    private void setCellStyle(StyleManager sm, Cell cell, BirtStyle birtStyle, Object value) {
        if (StyleManagerUtils.getNumberFormat(birtStyle) == null && StyleManagerUtils.getDateFormat(birtStyle) == null && StyleManagerUtils.getDateTimeFormat(birtStyle) == null && StyleManagerUtils.getTimeFormat(birtStyle) == null && value != null && value instanceof Date) {
            long time = ((Date)value).getTime();
            if ((time -= (long)(((Date)value).getTimezoneOffset() * 60000)) % 86400000L == 0L) {
                StyleManagerUtils.setDateFormat(birtStyle, "Short Date", null);
            } else if (time < 86400000L) {
                StyleManagerUtils.setTimeFormat(birtStyle, "Short Time", null);
            } else {
                StyleManagerUtils.setDateTimeFormat(birtStyle, "General Date", null);
            }
        }
        CellStyle cellStyle = sm.getStyle(birtStyle);
        cell.setCellStyle(cellStyle);
    }

    private CSSValue preferredAlignment(BirtStyle elementStyle) {
        CSSValue newAlign = elementStyle.getProperty(23);
        if (newAlign == null) {
            newAlign = new StringValue(19, "left");
        }
        if (this.preferredAlignment == null) {
            return newAlign;
        }
        if ("left".equals(newAlign.getCssText())) {
            return newAlign;
        }
        if ("right".equals(newAlign.getCssText())) {
            if ("center".equals(this.preferredAlignment)) {
                return newAlign;
            }
            return this.preferredAlignment;
        }
        return this.preferredAlignment;
    }

    protected void emitContent(HandlerState state, IContent element, Object value, boolean asBlock) {
        if (value == null) {
            return;
        }
        if (element.getBookmark() != null) {
            this.createName(state, CellContentHandler.prepareName(element.getBookmark()), state.rowNum, state.colNum, state.rowNum, state.colNum);
        }
        if (this.lastValue == null) {
            this.lastValue = value;
            this.lastElement = element;
            this.lastCellContentsWasBlock = asBlock;
            IHyperlinkAction birtHyperlink = element.getHyperlinkAction();
            if (birtHyperlink != null) {
                switch (birtHyperlink.getType()) {
                    case 1: {
                        this.hyperlinkUrl = birtHyperlink.getHyperlink();
                        break;
                    }
                    case 2: {
                        this.hyperlinkBookmark = birtHyperlink.getBookmark();
                        break;
                    }
                    case 3: {
                        IHTMLActionHandler handler = state.getRenderOptions().getActionHandler();
                        if (handler == null) break;
                        this.hyperlinkUrl = handler.getURL((IAction)new Action(null, birtHyperlink), element.getReportContent().getReportContext());
                        break;
                    }
                    default: {
                        this.log.debug("Unhandled hyperlink type: {}", birtHyperlink.getType());
                    }
                }
            }
            return;
        }
        StyleManager sm = state.getSm();
        String oldValue = this.lastValue.toString();
        String newComponent = value.toString();
        if (this.lastCellContentsWasBlock && !newComponent.startsWith("\n") && !oldValue.endsWith("\n")) {
            oldValue = String.valueOf(oldValue) + "\n";
            this.lastCellContentsWasBlock = false;
        }
        if (this.lastCellContentsRequiresSpace && !newComponent.startsWith("\n") && !oldValue.endsWith("\n")) {
            oldValue = String.valueOf(oldValue) + " ";
            this.lastCellContentsRequiresSpace = false;
        }
        String newValue = String.valueOf(oldValue) + newComponent;
        this.lastValue = newValue;
        if (element != null) {
            BirtStyle elementStyle = new BirtStyle(element);
            Font newFont = sm.getFontManager().getFont(elementStyle);
            this.richTextRuns.add(new RichTextRun(oldValue.length(), newFont));
            this.preferredAlignment = this.preferredAlignment(elementStyle);
        }
        this.lastCellContentsWasBlock = asBlock;
        this.hyperlinkUrl = null;
    }

    public void recordImage(HandlerState state, Coordinate location, IImageContent image, boolean spanColumns) throws BirtException {
        byte[] data = image.getData();
        this.log.debug("startImage: [" + image.getMIMEType() + "] " + "{" + image.getWidth() + " x " + image.getHeight() + "} " + (data == null ? "(no data) " : "(" + data.length + " bytes) ") + image.getURI());
        StyleManagerUtils smu = state.getSmu();
        Workbook wb = state.getWb();
        String mimeType = image.getMIMEType();
        if (data == null && image.getURI() != null) {
            try {
                URL imageUrl = new URL(image.getURI());
                URLConnection conn = imageUrl.openConnection();
                conn.connect();
                mimeType = conn.getContentType();
                int imageType = smu.poiImageTypeFromMimeType(mimeType, null);
                if (imageType == 0) {
                    this.log.debug("Unrecognised/unhandled image MIME type: " + mimeType);
                } else {
                    data = smu.downloadImage(conn);
                }
            }
            catch (MalformedURLException ex) {
                this.log.debug(ex.getClass(), ": ", ex.getMessage());
                ex.printStackTrace();
            }
            catch (IOException ex) {
                this.log.debug(ex.getClass(), ": ", ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (data != null) {
            int imageType = smu.poiImageTypeFromMimeType(mimeType, data);
            if (imageType == 0) {
                this.log.debug("Unrecognised/unhandled image MIME type: ", image.getMIMEType());
            } else {
                int imageIdx = wb.addPicture(data, imageType);
                if (image.getHeight() == null || image.getWidth() == null) {
                    Image birtImage = new Image();
                    birtImage.setInput(data);
                    birtImage.check();
                    this.log.debug("Calculated image dimensions " + birtImage.getWidth() + " (@" + birtImage.getPhysicalWidthDpi() + "dpi=" + birtImage.getPhysicalWidthInch() + "in) x " + birtImage.getHeight() + " (@" + birtImage.getPhysicalHeightDpi() + "dpi=" + birtImage.getPhysicalHeightInch() + "in)");
                    if (image.getWidth() == null) {
                        DimensionType Width = new DimensionType(birtImage.getPhysicalWidthInch() > 0.0f ? (double)birtImage.getPhysicalWidthInch() : (double)birtImage.getWidth() / 96.0, "in");
                        image.setWidth(Width);
                    }
                    if (image.getHeight() == null) {
                        DimensionType Height = new DimensionType(birtImage.getPhysicalHeightInch() > 0.0f ? (double)birtImage.getPhysicalHeightInch() : (double)birtImage.getHeight() / 96.0, "in");
                        image.setHeight(Height);
                    }
                }
                state.images.add(new CellImage(location, imageIdx, image, spanColumns));
                this.lastElement = image;
            }
        }
    }

    protected void removeMergedCell(HandlerState state, int row, int col) {
        int mergeNum = 0;
        while (mergeNum < state.currentSheet.getNumMergedRegions()) {
            CellRangeAddress region = state.currentSheet.getMergedRegion(mergeNum);
            if (region.getFirstRow() == row && region.getFirstColumn() == col) {
                state.currentSheet.removeMergedRegion(mergeNum);
                break;
            }
            ++mergeNum;
        }
        Iterator<Area> iter = state.rowSpans.iterator();
        while (iter.hasNext()) {
            Area area = iter.next();
            Coordinate topLeft = area.getX();
            if (topLeft.getRow() != row && topLeft.getCol() != col) continue;
            iter.remove();
        }
    }
}

