/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import com.ibm.icu.util.Calendar;
import java.util.List;
import org.eclipse.birt.data.engine.api.timefunction.ReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;

public abstract class AbstractMDX {
    protected static final String YEAR = "year";
    protected static final String QUARTER = "quarter";
    protected static final String MONTH = "month";
    protected static final String WEEK = "week";
    protected static final String DAY = "day";
    protected boolean isCurrent = false;
    private ReferenceDate referenceDate = null;

    protected String translateToCal(Calendar cal, String[] levelTypes, int[] values) {
        String type = "";
        int dayOfWeek = 1;
        int month = 1;
        int i = 0;
        while (i < values.length) {
            int year;
            int year_woy;
            if (levelTypes[i].equals(YEAR)) {
                cal.set(1, values[i]);
                type = YEAR;
            } else if (levelTypes[i].equals(QUARTER)) {
                cal.set(2, values[i] * 3 - 1);
                type = QUARTER;
            } else if (levelTypes[i].equals(MONTH)) {
                cal.set(2, values[i] - 1);
                type = MONTH;
                month = values[i] - 1;
            } else if (levelTypes[i].equals("week-of-month")) {
                if (this.referenceDate != null && this.referenceDate.getDate() != null) {
                    dayOfWeek = this.referenceDate.getDate().getDay();
                    cal.set(7, dayOfWeek + 1);
                } else {
                    year_woy = cal.get(17);
                    if (year_woy < (year = cal.get(1))) {
                        cal.set(7, 7);
                    } else if (year_woy > year) {
                        cal.set(7, 1);
                    }
                }
                cal.set(4, values[i]);
                this.setAcrossMonthWeekDay(cal, month);
                type = WEEK;
            } else if (levelTypes[i].equals("week-of-year")) {
                if (this.referenceDate != null && this.referenceDate.getDate() != null) {
                    dayOfWeek = this.referenceDate.getDate().getDay();
                    cal.set(7, dayOfWeek + 1);
                } else {
                    year_woy = cal.get(17);
                    if (year_woy < (year = cal.get(1))) {
                        cal.set(7, 7);
                    } else if (year_woy > year) {
                        cal.set(7, 1);
                    }
                }
                cal.set(3, values[i]);
                this.setAcrossMonthWeekDay(cal, month);
                type = WEEK;
            } else if (levelTypes[i].equals("day-of-week")) {
                cal.get(7);
                cal.set(7, values[i]);
                type = DAY;
            } else if (levelTypes[i].equals("day-of-month")) {
                cal.set(5, values[i]);
                type = DAY;
            } else if (levelTypes[i].equals("day-of-year")) {
                cal.set(6, values[i]);
                type = DAY;
            }
            ++i;
        }
        this.referenceDate = new ReferenceDate(cal.getTime());
        return type;
    }

    private void setAcrossMonthWeekDay(Calendar cal, int monthBase) {
        int month = cal.get(2);
        if (month == monthBase) {
            return;
        }
        cal.set(7, 1);
        int monthStart = cal.get(2);
        if (monthStart == monthBase) {
            return;
        }
        cal.set(7, 7);
    }

    protected int[] getValueFromCal(Calendar cal, String[] levelTypes) {
        int[] tmp = new int[levelTypes.length];
        int i = 0;
        while (i < levelTypes.length) {
            if (levelTypes[i].equals(YEAR)) {
                tmp[i] = cal.get(1);
            } else if (levelTypes[i].equals(QUARTER)) {
                tmp[i] = cal.get(2) / 3 + 1;
            } else if (levelTypes[i].equals(MONTH)) {
                tmp[i] = cal.get(2) + 1;
            } else if (levelTypes[i].equals("week-of-month")) {
                tmp[i] = cal.get(4);
            } else if (levelTypes[i].equals("week-of-year")) {
                tmp[i] = cal.get(3);
            } else if (levelTypes[i].equals("day-of-week")) {
                tmp[i] = cal.get(7);
            } else if (levelTypes[i].equals("day-of-month")) {
                tmp[i] = cal.get(5);
            } else if (levelTypes[i].equals("day-of-year")) {
                tmp[i] = cal.get(6);
            }
            ++i;
        }
        return tmp;
    }

    protected void retrieveWeek(List<TimeMember> list, Calendar cal, String[] levels, String type) {
        TimeMember newMember;
        int[] newValues;
        int endWeek;
        int startWeek = 1;
        int startMonth = 1;
        Calendar startCal = (Calendar)cal.clone();
        if (cal.get(1) != cal.get(17)) {
            cal.add(3, -1);
            endWeek = cal.get(3) + 1;
            cal.add(3, 1);
        } else {
            endWeek = cal.get(3);
        }
        if (type.equals("yearToDate")) {
            startCal.set(2, 0);
            startCal.set(5, 1);
            if (startCal.get(3) > 1) {
                newValues = this.getValueFromCal(startCal, levels);
                newMember = new TimeMember(newValues, levels);
                list.add(newMember);
                startCal.add(3, 1);
            }
            startWeek = 1;
        } else if (type.equals("quarterToDate")) {
            int quarter = cal.get(2) / 3 + 1;
            startMonth = quarter * 3 - 3;
            startCal.set(2, startMonth);
            startCal.set(5, 1);
            if (startMonth == 0 && startCal.get(3) > 1) {
                int[] newValues2 = this.getValueFromCal(startCal, levels);
                TimeMember newMember2 = new TimeMember(newValues2, levels);
                list.add(newMember2);
                startCal.add(3, 1);
            }
            startWeek = startCal.get(3);
        } else if (type.equals("monthToDate")) {
            startMonth = cal.get(2);
            startCal.set(2, startMonth);
            startCal.set(5, 1);
            if (startMonth == 0 && startCal.get(3) > 1) {
                newValues = this.getValueFromCal(startCal, levels);
                newMember = new TimeMember(newValues, levels);
                list.add(newMember);
                startCal.add(3, 1);
            }
            startWeek = startCal.get(3);
        }
        TimeMember newMember3 = null;
        int i = startWeek;
        while (i <= endWeek) {
            int[] newValues3 = this.getValueFromCal(startCal, levels);
            newMember3 = new TimeMember(newValues3, levels);
            list.add(newMember3);
            if (i != startWeek && this.isAddExtraWeek(type, startCal)) {
                this.addExtraWeek(list, startCal, newMember3, levels);
            }
            startCal.add(3, 1);
            startCal.set(7, 1);
            ++i;
        }
    }

    protected void addExtraWeek(List<TimeMember> timeMemberList, Calendar cal, TimeMember srcMember, String[] levels) {
        int weekStart = 1;
        int week = 1;
        int weekEnd = 1;
        int[] newValues = null;
        TimeMember newMember = null;
        int dayOfWeek = cal.get(7);
        week = cal.get(4);
        cal.set(7, 1);
        weekStart = cal.get(4);
        if (weekStart != week) {
            newValues = this.getValueFromCal(cal, levels);
            newMember = new TimeMember(newValues, levels);
        } else {
            cal.set(7, 7);
            weekEnd = cal.get(4);
            if (weekEnd != week) {
                newValues = this.getValueFromCal(cal, levels);
                newMember = new TimeMember(newValues, levels);
            }
        }
        if (newMember != null && !newMember.equals(srcMember)) {
            timeMemberList.add(newMember);
        }
        cal.set(7, dayOfWeek);
    }

    private boolean isAddExtraWeek(String type, Calendar cal) {
        int dayOfWeek = cal.get(7);
        if (type.equals("monthToDate")) {
            return false;
        }
        if (type.equals("quarterToDate")) {
            cal.set(7, 7);
            int quarterEnd = cal.get(2) / 3 + 1;
            cal.set(7, 1);
            int quarterStart = cal.get(2) / 3 + 1;
            if (quarterEnd != quarterStart) {
                return false;
            }
        } else if (type.equals("yearToDate")) {
            cal.set(7, 7);
            int yearEnd = cal.get(1);
            cal.set(7, 1);
            int yearStart = cal.get(1);
            if (yearStart != yearEnd) {
                return false;
            }
        }
        cal.set(7, dayOfWeek);
        return true;
    }

    public void setIsCurrent(boolean isCurrent) {
        this.isCurrent = isCurrent;
    }

    public void setReferenceDate(ReferenceDate referenceDate) {
        this.referenceDate = referenceDate;
    }

    public ReferenceDate getReferenceDate() {
        return this.referenceDate;
    }
}

