/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.toc;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.model.i18n.ThreadResources;

public abstract class TOCHtmlFactory {
    public String getTOCHtml(IReportDocument document, ULocale locale) {
        ITOCTree tree = document.getTOCTree("viewer", locale);
        TOCNode root = tree.getRoot();
        String preValue = "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tbody> ";
        String postValue = "</tbody></table>";
        String value = this.buildTOCHtml(root, 0);
        value = String.valueOf(preValue) + value + postValue;
        return value;
    }

    public String getTOCHtml(IReportDocument document) {
        ULocale locale = ThreadResources.getLocale();
        return this.getTOCHtml(document, locale);
    }

    protected abstract String getTOCHtmlScript();

    protected abstract String getTOCHtmlStyle();

    private String buildTOCHtml(TOCNode node, int level) {
        String styleValue;
        assert (node != null);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<tr><td ");
        String id = node.getNodeID();
        String displayValue = node.getDisplayString();
        String bookmark = node.getBookmark();
        if (displayValue != null) {
            String blank = this.printBlank(level);
            displayValue = String.valueOf(blank) + displayValue;
        }
        buffer.append("id=\"");
        buffer.append(id);
        buffer.append("\" ");
        if (bookmark != null) {
            buffer.append("bookmark=\"");
            buffer.append(bookmark);
            buffer.append("\" ");
        }
        if ((styleValue = this.getTOCHtmlStyle()) != null) {
            buffer.append("style=\"");
            buffer.append(styleValue);
            buffer.append("\"");
        }
        buffer.append(" >");
        String scriptValue = this.getTOCHtmlScript();
        if (scriptValue == null) {
            buffer.append(displayValue);
        } else {
            buffer.append(scriptValue);
            buffer.append("('");
            buffer.append(displayValue);
            buffer.append("') ");
        }
        buffer.append("</td></tr>");
        List nodeList = node.getChildren();
        if (nodeList.size() == 0) {
            return buffer.toString();
        }
        for (TOCNode childNode : nodeList) {
            String childHtml = this.buildTOCHtml(childNode, level + 1);
            if (childHtml == null || childHtml.length() <= 0) continue;
            buffer.append(childHtml);
        }
        return buffer.toString();
    }

    private String printBlank(int level) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < level) {
            buffer.append("&nbsp;");
            ++i;
        }
        return buffer.toString();
    }
}

