/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.utils;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.datatools.sqltools.result.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;

public class SQLUtil {
    protected static ILogger _log = ResultsViewPlugin.getLogger(null);

    public static void saveResultToStream(ObjectOutputStream oos, Object result) throws IOException {
        if (oos != null) {
            oos.writeObject(result);
            oos.flush();
        }
    }

    public static Object getResultFromStream(ObjectInputStream ois) {
        Object result = null;
        try {
            result = ois.readObject();
        }
        catch (EOFException eOFException) {
            return null;
        }
        catch (IOException e) {
            _log.error(e);
            return null;
        }
        catch (ClassNotFoundException e) {
            _log.error(e);
            return null;
        }
        return result;
    }

    public static boolean isNumericType(int datatype) {
        return datatype == -5 || datatype == 3 || datatype == 8 || datatype == 6 || datatype == 4 || datatype == 2 || datatype == 7 || datatype == 5 || datatype == -6;
    }

    public static String convertToString(int datatype) {
        switch (datatype) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 7: {
                return "REAL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN";
    }

    public static Object getObjectByTypeCoercion(ResultSet resultSet, int index, int dataType) throws SQLException {
        switch (dataType) {
            case 93: {
                return resultSet.getTimestamp(index);
            }
            case 2005: {
                return resultSet.getString(index);
            }
            case 2004: {
                return resultSet.getString(index);
            }
        }
        return resultSet.getObject(index);
    }
}

