/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.plugin.PackageSelectionDialog;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LibraryVisibilitySection
extends TableSection
implements IPartSelectionListener {
    private static int ADD_INDEX = 0;
    private static int REMOVE_INDEX = 1;
    private Button fFullExportButton;
    private Button fSelectedExportButton;
    private IPluginLibrary fCurrentLibrary;
    private Composite fPackageExportContainer;
    private TableViewer fPackageExportViewer;
    private Action fAddAction;
    private Action fRemoveAction;

    public LibraryVisibilitySection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, new String[]{PDEUIMessages.ManifestEditor_ExportSection_add, PDEUIMessages.ManifestEditor_ExportSection_remove});
        this.getSection().setText(PDEUIMessages.ManifestEditor_ExportSection_title);
        this.getSection().setDescription(PDEUIMessages.ManifestEditor_ExportSection_desc);
        this.fHandleDefaultButton = false;
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 1));
        String label = PDEUIMessages.ManifestEditor_ExportSection_fullExport;
        this.fFullExportButton = toolkit.createButton(container, label, 16);
        this.fFullExportButton.setLayoutData((Object)new GridData(768));
        this.fFullExportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (LibraryVisibilitySection.this.fCurrentLibrary != null) {
                        LibraryVisibilitySection.this.fCurrentLibrary.setExported(LibraryVisibilitySection.this.fFullExportButton.getSelection());
                    }
                    LibraryVisibilitySection.this.getTablePart().setButtonEnabled(0, !LibraryVisibilitySection.this.fFullExportButton.getSelection());
                    LibraryVisibilitySection.this.getTablePart().setButtonEnabled(1, false);
                }
                catch (CoreException coreException) {}
            }
        });
        label = PDEUIMessages.ManifestEditor_ExportSection_selectedExport;
        this.fSelectedExportButton = toolkit.createButton(container, label, 16);
        this.fSelectedExportButton.setLayoutData((Object)new GridData(768));
        this.createPackageViewer(container, toolkit);
        this.update(null);
        this.makeActions();
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        model.addModelChangedListener((IModelChangedListener)this);
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)container);
    }

    private void makeActions() {
        this.fAddAction = new Action(PDEUIMessages.ManifestEditor_ExportSection_add){

            public void run() {
                LibraryVisibilitySection.this.handleAdd();
            }
        };
        this.fAddAction.setEnabled(this.isEditable());
        this.fRemoveAction = new Action(PDEUIMessages.ManifestEditor_ExportSection_remove){

            public void run() {
                LibraryVisibilitySection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
    }

    private void createPackageViewer(Composite parent, FormToolkit toolkit) {
        this.fPackageExportContainer = toolkit.createComposite(parent);
        this.fPackageExportContainer.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.fPackageExportContainer.setLayout((Layout)layout);
        this.fPackageExportContainer.setLayoutData((Object)new GridData(1808));
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(this.getPage().getModel().isEditable());
        this.createViewerPartControl(this.fPackageExportContainer, 65536, 2, toolkit);
        this.fPackageExportViewer = tablePart.getTableViewer();
        this.fPackageExportViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.fPackageExportViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.fPackageExportViewer.setComparator(new ViewerComparator());
        toolkit.paintBordersFor(parent);
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        this.getTablePart().setButtonEnabled(1, item != null);
    }

    @Override
    protected void buttonSelected(int index) {
        if (index == ADD_INDEX) {
            this.handleAdd();
        } else if (index == REMOVE_INDEX) {
            this.handleRemove();
        }
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        return false;
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        if (this.fSelectedExportButton.isEnabled() && this.fSelectedExportButton.getSelection()) {
            manager.add((IAction)this.fAddAction);
            manager.add((IContributionItem)new Separator());
        }
        if (!this.fPackageExportViewer.getSelection().isEmpty()) {
            manager.add((IAction)this.fRemoveAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    private void handleAdd() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        IProject project = model.getUnderlyingResource().getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                String[] names = this.fCurrentLibrary.getContentFilters();
                Vector<String> existing = new Vector<String>();
                if (names != null) {
                    int i = 0;
                    while (i < names.length) {
                        existing.add(names[i]);
                        ++i;
                    }
                }
                JavaElementLabelProvider labelProvider = new JavaElementLabelProvider();
                PackageSelectionDialog dialog = new PackageSelectionDialog(this.fPackageExportViewer.getTable().getShell(), (ILabelProvider)labelProvider, JavaCore.create((IProject)project), existing, true);
                if (dialog.open() == 0) {
                    Object[] elements = dialog.getResult();
                    int i = 0;
                    while (i < elements.length) {
                        IPackageFragment fragment = (IPackageFragment)elements[i];
                        this.fCurrentLibrary.addContentFilter(fragment.getElementName());
                        ++i;
                    }
                }
                labelProvider.dispose();
            }
        }
        catch (CoreException coreException) {}
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fPackageExportViewer.getSelection();
        Object[] items = ssel.toArray();
        try {
            int i = 0;
            while (i < items.length) {
                this.fCurrentLibrary.removeContentFilter(items[i].toString());
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            if (this.fCurrentLibrary != null) {
                this.update(null);
            }
            this.markStale();
            return;
        }
        this.refresh();
    }

    public void refresh() {
        this.update(this.fCurrentLibrary);
        super.refresh();
    }

    public void selectionChanged(IFormPart source, ISelection selection) {
        IStructuredSelection ssel;
        if (selection == null || selection.isEmpty()) {
            this.update(null);
        }
        boolean enable = (ssel = (IStructuredSelection)selection).size() == 1;
        this.setEnabled(enable);
        if (enable && ssel.getFirstElement() instanceof IPluginLibrary) {
            this.update((IPluginLibrary)ssel.getFirstElement());
        }
    }

    private void setEnabled(boolean b) {
        this.fFullExportButton.setEnabled(b);
        this.fSelectedExportButton.setEnabled(b);
        this.fPackageExportViewer.getTable().setEnabled(b);
        if (!b) {
            this.getTablePart().setButtonEnabled(ADD_INDEX, false);
            this.getTablePart().setButtonEnabled(REMOVE_INDEX, false);
        }
    }

    private void update(IPluginLibrary library) {
        this.fCurrentLibrary = library;
        if (library == null) {
            this.fFullExportButton.setEnabled(false);
            this.fFullExportButton.setSelection(false);
            this.fSelectedExportButton.setEnabled(false);
            this.fSelectedExportButton.setSelection(false);
            this.fPackageExportViewer.setInput((Object)new Object[0]);
            this.getTablePart().setButtonEnabled(ADD_INDEX, false);
            this.getTablePart().setButtonEnabled(REMOVE_INDEX, false);
        } else {
            this.fFullExportButton.setEnabled(this.isEditable());
            this.fSelectedExportButton.setEnabled(this.isEditable());
            this.fFullExportButton.setSelection(library.isFullyExported());
            this.fSelectedExportButton.setSelection(!library.isFullyExported());
            this.fPackageExportViewer.setInput((Object)library);
            this.getTablePart().setButtonEnabled(REMOVE_INDEX, false);
            this.getTablePart().setButtonEnabled(ADD_INDEX, this.isEditable() && this.fSelectedExportButton.getSelection());
        }
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        return false;
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IPluginLibrary) {
                String[] filters = ((IPluginLibrary)parent).getContentFilters();
                return filters == null ? new Object[]{} : filters;
            }
            return new Object[0];
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
        }
    }
}

