/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.ValidationParticipant;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.builder.BuildNotifier;
import org.eclipse.wst.jsdt.internal.core.builder.NameEnvironment;
import org.eclipse.wst.jsdt.internal.core.builder.State;
import org.eclipse.wst.validation.internal.operations.ValidationBuilder;

public class JavaBuilder
extends ValidationBuilder {
    IProject currentProject;
    JavaProject javaProject;
    IWorkspaceRoot workspaceRoot;
    ValidationParticipant[] participants;
    NameEnvironment nameEnvironment;
    SimpleLookupTable binaryLocationsPerProject;
    public State lastState;
    BuildNotifier notifier;
    char[][] extraResourceFileFilters;
    String[] extraResourceFolderFilters;
    public static final String SOURCE_ID = "JSDT";
    public static boolean DEBUG = false;

    public static IMarker[] getProblemsFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                IMarker[] markers = resource.findMarkers("org.eclipse.wst.jsdt.core.problem", false, 2);
                HashSet markerTypes = JavaModelManager.getJavaModelManager().validationParticipants.managedMarkerTypes();
                if (markerTypes.isEmpty()) {
                    return markers;
                }
                ArrayList<IMarker> markerList = new ArrayList<IMarker>(5);
                int i = 0;
                int length = markers.length;
                while (i < length) {
                    markerList.add(markers[i]);
                    ++i;
                }
                Iterator iterator = markerTypes.iterator();
                while (iterator.hasNext()) {
                    markers = resource.findMarkers((String)iterator.next(), false, 2);
                    int i2 = 0;
                    int length2 = markers.length;
                    while (i2 < length2) {
                        markerList.add(markers[i2]);
                        ++i2;
                    }
                }
                IMarker[] result = new IMarker[markerList.size()];
                markerList.toArray(result);
                return result;
            }
        }
        catch (CoreException coreException) {}
        return new IMarker[0];
    }

    public static IMarker[] getTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                return resource.findMarkers("org.eclipse.wst.jsdt.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {}
        return new IMarker[0];
    }

    public static void buildStarting() {
    }

    public static void buildFinished() {
        BuildNotifier.resetProblemCounters();
    }

    public static void removeProblemsFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.wst.jsdt.core.problem", false, 2);
                HashSet markerTypes = JavaModelManager.getJavaModelManager().validationParticipants.managedMarkerTypes();
                if (markerTypes.size() == 0) {
                    return;
                }
                Iterator iterator = markerTypes.iterator();
                while (iterator.hasNext()) {
                    resource.deleteMarkers((String)iterator.next(), false, 2);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public static void removeTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.wst.jsdt.core.task", false, 2);
            }
        }
        catch (CoreException coreException) {}
    }

    public static void removeProblemsAndTasksFor(IResource resource) {
        try {
            if (resource != null && resource.exists()) {
                resource.deleteMarkers("org.eclipse.wst.jsdt.core.problem", false, 2);
                resource.deleteMarkers("org.eclipse.wst.jsdt.core.task", false, 2);
                HashSet markerTypes = JavaModelManager.getJavaModelManager().validationParticipants.managedMarkerTypes();
                if (markerTypes.size() == 0) {
                    return;
                }
                Iterator iterator = markerTypes.iterator();
                while (iterator.hasNext()) {
                    resource.deleteMarkers((String)iterator.next(), false, 2);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    public static State readState(IProject project, DataInputStream in) throws IOException {
        return State.read(project, in);
    }

    public static void writeState(Object state, DataOutputStream out) throws IOException {
        ((State)state).write(out);
    }

    public IProject[] build(int kind, Map ignored, IProgressMonitor monitor) {
        return super.build(kind, ignored, monitor);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
    }

    boolean filterExtraResource(IResource resource) {
        if (this.extraResourceFileFilters != null) {
            char[] name = resource.getName().toCharArray();
            int i = 0;
            int l = this.extraResourceFileFilters.length;
            while (i < l) {
                if (CharOperation.match(this.extraResourceFileFilters[i], name, true)) {
                    return true;
                }
                ++i;
            }
        }
        if (this.extraResourceFolderFilters != null) {
            IPath path = resource.getProjectRelativePath();
            String pathName = path.toString();
            int count = path.segmentCount();
            if (resource.getType() == 1) {
                --count;
            }
            int i = 0;
            int l = this.extraResourceFolderFilters.length;
            while (i < l) {
                if (pathName.indexOf(this.extraResourceFolderFilters[i]) != -1) {
                    int j = 0;
                    while (j < count) {
                        if (this.extraResourceFolderFilters[i].equals(path.segment(j))) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public State getLastState(IProject project) {
        return (State)JavaModelManager.getJavaModelManager().getLastBuiltState(project, this.notifier.monitor);
    }

    boolean hasBuildpathErrors() throws CoreException {
        return false;
    }

    void mustPropagateStructuralChanges() {
        HashSet cycleParticipants = new HashSet(3);
        this.javaProject.updateCycleParticipants(new ArrayList(), cycleParticipants, this.workspaceRoot, new HashSet(3), null);
        IPath currentPath = this.javaProject.getPath();
        for (IPath participantPath : cycleParticipants) {
            IProject project;
            if (participantPath == currentPath || !this.hasBeenBuilt(project = this.workspaceRoot.getProject(participantPath.segment(0)))) continue;
            if (DEBUG) {
                System.out.println("Requesting another build iteration since cycle participant " + project.getName() + " has not yet seen some structural changes");
            }
            this.needRebuild();
            return;
        }
    }

    public String toString() {
        return this.currentProject == null ? "JavaBuilder for unknown project" : "JavaBuilder for " + this.currentProject.getName();
    }
}

