/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.common.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.js.common.CommonPlugin;

public final class WorkbenchResourceUtil {
    private WorkbenchResourceUtil() {
    }

    public static void openInEditor(IFile file, String editorID) throws PartInitException {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (editorID == null || editorRegistry.findEditor(editorID) == null) {
            editorID = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getFullPath().toString()).getId();
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.openEditor((IEditorInput)new FileEditorInput(file), editorID, true, 2);
    }

    public static void createFile(IFile file, String content) throws CoreException {
        if (!file.exists()) {
            ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
            try {
                file.create((InputStream)source, 0, null);
            }
            catch (CoreException e) {
                CommonPlugin.logError(e);
            }
        }
    }

    public static void updateFile(IFile file, String content) throws CoreException {
        if (file != null && file.exists()) {
            ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
            file.setContents((InputStream)source, true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static IProject getSelectedProject() {
        StructuredSelection structuredSelection;
        Object firstElement;
        IResource resource;
        ISelection selection;
        IWorkbenchPage activePage;
        IWorkbenchWindow workbenchWindow = CommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null && (activePage = workbenchWindow.getActivePage()) != null && (selection = activePage.getSelection()) instanceof StructuredSelection && (resource = ResourceUtil.getResource((Object)(firstElement = (structuredSelection = (StructuredSelection)selection).getFirstElement()))) != null) {
            return resource.getProject();
        }
        return null;
    }

    public static IProject getProject(String name) {
        if (name != null) {
            try {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (project != null && project.exists()) {
                    return project;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public static IResource getResource(IProject project, String filePath) {
        if (project != null && project.exists()) {
            try {
                IResource resource = project.findMember((IPath)new Path(filePath));
                if (resource != null && resource.exists()) {
                    return resource;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return null;
    }

    public static IContainer getContainerFromSelection(IStructuredSelection selection) {
        IContainer container = null;
        if (selection != null && !selection.isEmpty()) {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject instanceof IContainer) {
                container = (IContainer)selectedObject;
            } else if (selectedObject instanceof IFile) {
                container = ((IFile)selectedObject).getParent();
            }
        }
        return container;
    }

    public static String getAbsolutePath(IResource resource) {
        IPath path = null;
        String absoluteLocation = null;
        if (resource != null) {
            path = resource.getRawLocation();
            IPath iPath = path = path != null ? path : resource.getLocation();
            if (path != null) {
                absoluteLocation = path.toOSString();
            }
        }
        return absoluteLocation;
    }

    public static void showConsoleView() throws PartInitException {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
            activePage.showView("org.eclipse.ui.console.ConsoleView");
        }
    }

    public static IFile findFileRecursively(IContainer container, String name) throws CoreException {
        IResource[] iResourceArray = container.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (r instanceof IContainer) {
                IFile file = WorkbenchResourceUtil.findFileRecursively((IContainer)r, name);
                if (file != null && file.exists()) {
                    return file;
                }
            } else if (r instanceof IFile && r.getName().equals(name) && r.exists()) {
                return (IFile)r;
            }
            ++n2;
        }
        return null;
    }

    public static File getFile(String path) {
        File file;
        if (path != null && (file = new File(path)).isFile() && file.exists()) {
            return file;
        }
        return null;
    }

    public static IFile getFileForLocation(String path) {
        if (path == null) {
            return null;
        }
        Path filePath = new Path(path);
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    public static IPath getRelativePath(IContainer container, IResource resource) {
        IPath resourcePath;
        if (resource == null) {
            return null;
        }
        if (container == null) {
            return resource.getFullPath();
        }
        IPath containerPath = container.getFullPath();
        if (containerPath.isPrefixOf(resourcePath = resource.getFullPath())) {
            int containerPathSegmentCount = containerPath.segmentCount();
            return resourcePath.removeFirstSegments(containerPathSegmentCount);
        }
        return null;
    }

    public static void showErrorDialog(final String title, final String message, final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                ErrorDialog.openError((Shell)(shell != null ? shell : new Shell()), (String)title, (String)message, (IStatus)status);
            }
        });
    }
}

