/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.nashorn.extension.loader;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.wst.jsdt.nashorn.extension.loader.NashornClassLoaderConfigurator;

public class NashornLoaderHook
extends ClassLoaderHook {
    private static final String BUNDLE_ID_JSDT_CORE = "org.eclipse.wst.jsdt.core";

    public ModuleClassLoader createClassLoader(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation) {
        if (BUNDLE_ID_JSDT_CORE.equals(generation.getRevision().getBundle().getSymbolicName())) {
            if (NashornClassLoaderConfigurator.DEBUG) {
                System.out.println("NashornLoaderHook is creating NashornClassLoader");
            }
            return new NashornClassLoader(parent, configuration, delegate, generation);
        }
        return super.createClassLoader(parent, configuration, delegate, generation);
    }

    static final class NashornClassLoader
    extends ModuleClassLoader {
        private EquinoxConfiguration configuration;
        private BundleLoader delegate;
        private BundleInfo.Generation generation;
        private ClasspathManager classpathManager;
        private URLClassLoader nashornLoader;

        public NashornClassLoader(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation) {
            super(parent);
            this.configuration = configuration;
            this.delegate = delegate;
            this.generation = generation;
            this.classpathManager = new ClasspathManager(this.generation, (ModuleClassLoader)this);
        }

        protected BundleInfo.Generation getGeneration() {
            return this.generation;
        }

        protected Debug getDebug() {
            return this.configuration.getDebug();
        }

        public ClasspathManager getClasspathManager() {
            return this.classpathManager;
        }

        protected EquinoxConfiguration getConfiguration() {
            return this.configuration;
        }

        public BundleLoader getBundleLoader() {
            return this.delegate;
        }

        public boolean isRegisteredAsParallel() {
            return false;
        }

        public Class<?> findLocalClass(String classname) throws ClassNotFoundException {
            if (classname.startsWith("jdk.nashorn") || classname.startsWith("jdk.internal.dynalink")) {
                URLClassLoader loader;
                Class<?> clazz;
                if (NashornClassLoaderConfigurator.DEBUG) {
                    System.out.println("NashornLoaderHook is loading " + classname);
                }
                if ((clazz = (loader = this.getNashornClassLoader()).loadClass(classname)) != null) {
                    if (NashornClassLoaderConfigurator.DEBUG) {
                        System.out.println("NashornLoaderHook Loaded" + clazz);
                    }
                    return clazz;
                }
            }
            return super.findLocalClass(classname);
        }

        private URLClassLoader getNashornClassLoader() {
            if (this.nashornLoader == null) {
                if (NashornClassLoaderConfigurator.DEBUG) {
                    System.out.println("Creating a URLClassLoader for nashorn.jar");
                }
                try {
                    File javaHomeFile = new File(System.getProperty("java.home")).getCanonicalFile();
                    if (!javaHomeFile.isDirectory()) {
                        throw new IllegalStateException("java.home " + javaHomeFile.getAbsolutePath() + " does not exist");
                    }
                    File nashornJar = new File(javaHomeFile, "lib/ext/nashorn.jar");
                    URI nashornUri = nashornJar.toURI();
                    this.nashornLoader = URLClassLoader.newInstance(new URL[]{nashornUri.toURL()});
                    return this.nashornLoader;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failire when creating the class loader for nashorn.jar", e);
                }
            }
            return this.nashornLoader;
        }
    }
}

