/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.document;

import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONStructure;
import org.eclipse.wst.json.core.document.JSONException;
import org.eclipse.wst.json.core.internal.document.JSONDocumentImpl;
import org.eclipse.wst.json.core.internal.document.JSONModelImpl;
import org.eclipse.wst.json.core.internal.document.JSONNodeImpl;
import org.eclipse.wst.json.core.internal.document.JSONValueImpl;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public abstract class JSONStructureImpl
extends JSONValueImpl
implements IJSONStructure {
    private IStructuredDocumentRegion endStructuredDocumentRegion = null;
    private ChildNodesCache childNodesCache = null;
    private boolean fChildEditable = true;
    JSONNodeImpl firstChild = null;
    JSONNodeImpl lastChild = null;
    Object lockObject = new byte[0];

    protected JSONStructureImpl() {
    }

    protected JSONStructureImpl(JSONStructureImpl that) {
        super(that);
    }

    public IJSONNode appendChild(IJSONNode newChild) throws JSONException {
        return this.insertBefore(newChild, null);
    }

    protected void cloneChildNodes(IJSONNode newParent, boolean deep) {
        if (newParent == null || newParent == this) {
            return;
        }
        if (!(newParent instanceof JSONStructureImpl)) {
            return;
        }
        JSONStructureImpl container = (JSONStructureImpl)newParent;
        container.removeChildNodes();
        IJSONNode child = this.getFirstChild();
        while (child != null) {
            IJSONNode cloned = child.cloneNode(deep);
            if (cloned != null) {
                container.appendChild(cloned);
            }
            child = child.getNextSibling();
        }
    }

    @Override
    public IJSONNode getFirstChild() {
        return this.firstChild;
    }

    @Override
    public IJSONNode getLastChild() {
        return this.lastChild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLength() {
        if (this.firstChild == null) {
            return 0;
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.childNodesCache == null) {
                this.childNodesCache = new ChildNodesCache();
            }
            return this.childNodesCache.getLength();
        }
    }

    @Override
    public String getSource() {
        String source;
        String source2;
        StringBuffer buffer = new StringBuffer();
        IStructuredDocumentRegion startStructuredDocumentRegion = this.getStartStructuredDocumentRegion();
        if (startStructuredDocumentRegion != null && (source2 = startStructuredDocumentRegion.getText()) != null) {
            buffer.append(source2);
        }
        JSONNodeImpl child = this.firstChild;
        while (child != null) {
            source = child.getSource();
            if (source != null) {
                buffer.append(source);
            }
            child = (JSONNodeImpl)child.getNextSibling();
        }
        IStructuredDocumentRegion endStructuredDocumentRegion = this.getEndStructuredDocumentRegion();
        if (endStructuredDocumentRegion != null && (source = endStructuredDocumentRegion.getText()) != null) {
            buffer.append(source);
        }
        return buffer.toString();
    }

    @Override
    public boolean hasChildNodes() {
        return this.firstChild != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJSONNode insertBefore(IJSONNode newChild, IJSONNode refChild) throws JSONException {
        if (newChild == null) {
            return null;
        }
        if (refChild != null) {
            refChild.getParentNode();
        }
        this.isChildEditable();
        if (newChild == refChild) {
            return newChild;
        }
        this.isParent(newChild);
        Object object = this.lockObject;
        synchronized (object) {
            this.childNodesCache = null;
        }
        JSONNodeImpl child = (JSONNodeImpl)newChild;
        JSONNodeImpl next = (JSONNodeImpl)refChild;
        JSONNodeImpl prev = null;
        IJSONNode oldParent = child.getParentNode();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
        if (next == null) {
            prev = this.lastChild;
            this.lastChild = child;
        } else {
            prev = (JSONNodeImpl)next.getPreviousSibling();
            next.setPreviousSibling(child);
        }
        if (prev == null) {
            this.firstChild = child;
        } else {
            prev.setNextSibling(child);
        }
        child.setPreviousSibling(prev);
        child.setNextSibling(next);
        child.setParentNode(this);
        if (child.getOwnerDocument() == null) {
            if (this.getNodeType() == -1) {
                child.setOwnerDocument((IJSONDocument)((Object)this));
            } else {
                child.setOwnerDocument(this.getOwnerDocument());
            }
        }
        this.notifyChildReplaced(child, null);
        return child;
    }

    @Override
    public boolean isChildEditable() {
        JSONModelImpl model;
        if (!this.fChildEditable && (model = (JSONModelImpl)this.getModel()) != null && model.isReparsing()) {
            return true;
        }
        return this.fChildEditable;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJSONNode item(int index) {
        if (this.firstChild == null) {
            return null;
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.childNodesCache == null) {
                this.childNodesCache = new ChildNodesCache();
            }
            return this.childNodesCache.item(index);
        }
    }

    protected void notifyChildReplaced(IJSONNode newChild, IJSONNode oldChild) {
        JSONDocumentImpl document = (JSONDocumentImpl)this.getContainerDocument();
        if (document == null) {
            return;
        }
        JSONModelImpl model = (JSONModelImpl)document.getModel();
        if (model == null) {
            return;
        }
        model.childReplaced(this, newChild, oldChild);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJSONNode removeChild(IJSONNode oldChild) throws JSONException {
        if (oldChild == null) {
            return null;
        }
        if (oldChild.getParentNode() != this) {
            throw new JSONException();
        }
        if (!this.isChildEditable()) {
            throw new JSONException();
        }
        Object object = this.lockObject;
        synchronized (object) {
            this.childNodesCache = null;
        }
        JSONNodeImpl child = (JSONNodeImpl)oldChild;
        JSONNodeImpl prev = (JSONNodeImpl)child.getPreviousSibling();
        JSONNodeImpl next = (JSONNodeImpl)child.getNextSibling();
        if (prev == null) {
            this.firstChild = next;
        } else {
            prev.setNextSibling(next);
        }
        if (next == null) {
            this.lastChild = prev;
        } else {
            next.setPreviousSibling(prev);
        }
        child.setPreviousSibling(null);
        child.setNextSibling(null);
        child.setParentNode(null);
        this.notifyChildReplaced(null, child);
        return child;
    }

    @Override
    public void removeChildNodes() {
        if (!this.isChildEditable()) {
            throw new JSONException();
        }
        IJSONNode nextChild = null;
        IJSONNode child = this.getFirstChild();
        while (child != null) {
            nextChild = child.getNextSibling();
            this.removeChild(child);
            child = nextChild;
        }
    }

    @Override
    public IJSONNode replaceChild(IJSONNode newChild, IJSONNode oldChild) throws JSONException {
        if (!this.isChildEditable()) {
            throw new JSONException();
        }
        if (oldChild == null || oldChild == newChild) {
            return newChild;
        }
        if (newChild != null) {
            this.insertBefore(newChild, oldChild);
        }
        return this.removeChild(oldChild);
    }

    private boolean isParent(IJSONNode possibleParent) {
        IJSONNode parent = this.getParentNode();
        while (parent != null && parent != possibleParent) {
            parent = parent.getParentNode();
        }
        return parent == possibleParent;
    }

    void setStartStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        this.setStructuredDocumentRegion(flatNode);
    }

    void setEndStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        this.endStructuredDocumentRegion = flatNode;
    }

    @Override
    public int getEndOffset() {
        if (this.endStructuredDocumentRegion != null) {
            return this.endStructuredDocumentRegion.getEnd();
        }
        return super.getEndOffset();
    }

    @Override
    public IStructuredDocumentRegion getEndStructuredDocumentRegion() {
        return this.endStructuredDocumentRegion;
    }

    public int getStartEndOffset() {
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode != null) {
            return flatNode.getEnd();
        }
        return super.getStartOffset();
    }

    @Override
    public boolean isClosed() {
        return this.getEndStructuredDocumentRegion() != null;
    }

    private class ChildNodesCache {
        private IJSONNode curChild = null;
        private int curIndex = -1;
        private int length = 0;

        ChildNodesCache() {
            this.initializeCache();
        }

        public int getLength() {
            return this.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeCache() {
            Object object = JSONStructureImpl.this.lockObject;
            synchronized (object) {
                IJSONNode child = JSONStructureImpl.this.firstChild;
                while (child != null) {
                    ++this.length;
                    child = child.getNextSibling();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public IJSONNode item(int index) {
            var2_2 = JSONStructureImpl.this.lockObject;
            synchronized (var2_2) {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                if (this.length != 0) break block12;
                                return null;
                            }
                            if (index >= 0) break block13;
                            return null;
                        }
                        if (index < this.length) break block14;
                        return null;
                    }
                    if (this.curIndex < 0) {
                        if (index * 2 >= this.length) {
                            this.curIndex = this.length - 1;
                            this.curChild = JSONStructureImpl.this.lastChild;
                        } else {
                            this.curIndex = 0;
                            this.curChild = JSONStructureImpl.this.firstChild;
                        }
                    }
                    if (index == this.curIndex) {
                        return this.curChild;
                    }
                    if (index <= this.curIndex) ** GOTO lbl33
                    while (index > this.curIndex) {
                        ++this.curIndex;
                        this.curChild = this.curChild.getNextSibling();
                    }
                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        --this.curIndex;
                        this.curChild = this.curChild.getPreviousSibling();
lbl33:
                        // 2 sources

                        ** while (index < this.curIndex)
                    }
                }
                return this.curChild;
            }
        }
    }
}

