/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.validation.eclipse;

import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.internal.validation.JSONNestedValidatorContext;
import org.eclipse.wst.json.core.internal.validation.JSONValidationConfiguration;
import org.eclipse.wst.json.core.internal.validation.JSONValidationReport;
import org.eclipse.wst.json.core.internal.validation.core.AbstractNestedValidator;
import org.eclipse.wst.json.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.json.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.json.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.json.core.internal.validation.eclipse.JSONMessageInfoHelper;
import org.eclipse.wst.json.core.internal.validation.eclipse.JSONValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class Validator
extends AbstractNestedValidator {
    private static final String JSON_VALIDATOR_CONTEXT = "org.eclipse.wst.json.core.validatorContext";
    protected int indicateNoGrammar = 0;
    private IScopeContext[] fPreferenceScopes = null;

    @Override
    protected void setupValidation(NestedValidatorContext context) {
        super.setupValidation(context);
        this.fPreferenceScopes = this.createPreferenceScopes(context);
        this.indicateNoGrammar = Platform.getPreferencesService().getInt(JSONCorePlugin.getDefault().getBundle().getSymbolicName(), "indicateNoGrammar", 0, this.fPreferenceScopes);
    }

    protected IScopeContext[] createPreferenceScopes(NestedValidatorContext context) {
        ProjectScope projectScope;
        IProject project;
        if (context != null && (project = context.getProject()) != null && project.isAccessible() && (projectScope = new ProjectScope(project)).getNode(JSONCorePlugin.getDefault().getBundle().getSymbolicName()).getBoolean("use-project-settings", false)) {
            return new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    @Override
    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context) {
        return this.validate(uri, inputstream, context, null);
    }

    @Override
    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context, ValidationResult result) {
        JSONValidator validator = JSONValidator.getInstance();
        JSONValidationConfiguration configuration = new JSONValidationConfiguration();
        JSONValidationReport valreport = validator.validate(uri, inputstream, configuration, result, context);
        return valreport;
    }

    @Override
    protected void addInfoToMessage(ValidationMessage validationMessage, IMessage message) {
        String key = validationMessage.getKey();
        if (key != null) {
            JSONMessageInfoHelper messageInfoHelper = new JSONMessageInfoHelper();
            messageInfoHelper.createMessageInfo(key, validationMessage.getMessageArguments());
            message.setAttribute("columnNumber", (Object)new Integer(validationMessage.getColumnNumber()));
        }
    }

    @Override
    protected NestedValidatorContext getNestedContext(ValidationState state, boolean create) {
        JSONNestedValidatorContext context = null;
        Object o = state.get(JSON_VALIDATOR_CONTEXT);
        if (o instanceof JSONNestedValidatorContext) {
            context = (JSONNestedValidatorContext)o;
        } else if (create) {
            context = new JSONNestedValidatorContext();
        }
        return context;
    }

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
        if (project != null) {
            NestedValidatorContext context = this.getNestedContext(state, false);
            if (context == null) {
                context = this.getNestedContext(state, true);
                if (context != null) {
                    context.setProject(project);
                }
                this.setupValidation(context);
                state.put(JSON_VALIDATOR_CONTEXT, (Object)context);
            }
            super.validationStarting(project, state, monitor);
        }
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
        if (project != null) {
            super.validationFinishing(project, state, monitor);
            NestedValidatorContext context = this.getNestedContext(state, false);
            if (context != null) {
                this.teardownValidation(context);
                state.put(JSON_VALIDATOR_CONTEXT, null);
            }
        }
    }
}

