/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.contentassist;

import java.io.IOException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.json.jsonpath.IJSONPath;
import org.eclipse.json.jsonpath.JSONPath;
import org.eclipse.json.schema.IJSONSchemaDocument;
import org.eclipse.json.schema.IJSONSchemaProperty;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.core.document.IJSONObject;
import org.eclipse.wst.json.ui.contentassist.AbstractJSONCompletionProposalComputer;
import org.eclipse.wst.json.ui.contentassist.ContentAssistHelper;
import org.eclipse.wst.json.ui.contentassist.ContentAssistRequest;
import org.eclipse.wst.json.ui.contentassist.ICompletionProposalCollector;
import org.eclipse.wst.json.ui.contentassist.JSONKeyCompletionProposal;
import org.eclipse.wst.json.ui.internal.Logger;
import org.eclipse.wst.json.ui.internal.contentassist.CompletionProposalCollectorsRegistryReader;
import org.eclipse.wst.json.ui.internal.editor.JSONEditorPluginImageHelper;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;

public class JSONCompletionProposalComputer
extends AbstractJSONCompletionProposalComputer {
    public void sessionStarted() {
    }

    @Override
    protected void addObjectKeyProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        this.collectProposalsFromSchema(contentAssistRequest, context);
        this.collectProposalsFromExtensionPoint(contentAssistRequest, context);
    }

    private void collectProposalsFromExtensionPoint(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        CompletionProposalCollectorsRegistryReader.getInstance().addProposals(contentAssistRequest, context, ICompletionProposalCollector.TargetType.key);
    }

    private void collectProposalsFromSchema(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        try {
            IJSONNode node = contentAssistRequest.getNode();
            IJSONSchemaDocument schemaDocument = JSONCorePlugin.getDefault().getSchemaDocument(node);
            if (schemaDocument != null) {
                IJSONSchemaProperty parentProperty;
                String matchString = contentAssistRequest.getMatchString();
                if (matchString == null) {
                    matchString = "";
                }
                if (matchString.length() > 0 && matchString.startsWith("\"")) {
                    matchString = matchString.substring(1);
                }
                IJSONPath path = node.getPath();
                if (!(node instanceof IJSONObject && node.getOwnerPairNode() != null || path.getSegments().length <= 0)) {
                    String[] segments = new String[path.getSegments().length - 1];
                    System.arraycopy(path.getSegments(), 0, segments, 0, path.getSegments().length - 1);
                    path = new JSONPath(segments);
                }
                if ((parentProperty = schemaDocument.getProperty(path)) != null) {
                    IJSONSchemaProperty[] iJSONSchemaPropertyArray = parentProperty.getProperties();
                    int n = iJSONSchemaPropertyArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJSONSchemaProperty property = iJSONSchemaPropertyArray[n2];
                        boolean showProperty = JSONCompletionProposalComputer.beginsWith(property.getName(), matchString.trim());
                        if (showProperty) {
                            String replacementString = ContentAssistHelper.getRequiredName(node, property);
                            String additionalProposalInfo = property.getDescription();
                            Image icon = JSONEditorPluginImageHelper.getInstance().getImage(property.getFirstType());
                            JSONKeyCompletionProposal proposal = new JSONKeyCompletionProposal(replacementString, contentAssistRequest.getReplacementBeginPosition(), contentAssistRequest.getReplacementLength(), replacementString.length() - 2, icon, property.getName(), null, additionalProposalInfo, 400);
                            contentAssistRequest.addProposal((ICompletionProposal)proposal);
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }
}

