/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSI1111
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1111(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document doc;
        if (entryContext.getMessageEntry() != null && !this.validator.isOneWayResponse(entryContext) && (doc = entryContext.getMessageEntryDocument()) != null) {
            Element root = doc.getDocumentElement();
            NodeList claimList = root.getElementsByTagNameNS("http://ws-i.org/schemas/conformanceClaim/", "Claim");
            if (claimList != null && claimList.getLength() != 0) {
                NodeList headerList = root.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
                if (headerList != null && headerList.getLength() != 0) {
                    int iHeader = 0;
                    while (iHeader < headerList.getLength()) {
                        Node child = headerList.item(iHeader).getFirstChild();
                        while (child != null) {
                            String attrVal;
                            if (child.getNodeType() == 1 && (attrVal = ((Element)child).getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand")) != null && !"".equals(attrVal)) {
                                this.result = "failed";
                                this.failureDetail = this.validator.createFailureDetail("\nSOAP message:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                                iHeader = headerList.getLength();
                                break;
                            }
                            child = child.getNextSibling();
                        }
                        ++iHeader;
                    }
                }
            } else {
                this.result = "notApplicable";
            }
        } else {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

