/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartIntSpinner;
import org.eclipse.birt.chart.ui.swt.composites.AngleSelectorComposite;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontCanvas;
import org.eclipse.birt.chart.ui.swt.composites.IAngleChangeListener;
import org.eclipse.birt.chart.ui.swt.composites.IntegerSpinControl;
import org.eclipse.birt.chart.ui.swt.interfaces.IFontDefinitionDialog;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FontDefinitionDialog
extends TrayDialog
implements IFontDefinitionDialog,
SelectionListener,
Listener,
IAngleChangeListener,
FocusListener {
    protected transient FontDefinition fdCurrent = null;
    private transient ColorDefinition cdCurrent = null;
    private transient FontDefinition fdBackup = null;
    private transient ColorDefinition cdBackup = null;
    protected transient Composite cmpContent = null;
    private transient Combo cmbFontNames = null;
    private transient Combo cmbFontSizes = null;
    private transient FillChooserComposite fccColor = null;
    protected transient Button btnATopLeft = null;
    protected transient Button btnATopCenter = null;
    protected transient Button btnATopRight = null;
    protected transient Button btnACenterLeft = null;
    protected transient Button btnACenter = null;
    protected transient Button btnACenterRight = null;
    protected transient Button btnABottomLeft = null;
    protected transient Button btnABottomCenter = null;
    protected transient Button btnABottomRight = null;
    private transient Button btnBold = null;
    private transient Button btnItalic = null;
    private transient Button btnUnderline = null;
    private transient Button btnStrikethru = null;
    private transient AngleSelectorComposite ascRotation = null;
    private transient AbstractChartIntSpinner iscRotation = null;
    private transient FontCanvas fcPreview = null;
    private boolean isAlignmentEnabled = true;
    private boolean isRotationEnabled = true;
    protected transient List<Button> listAlignmentButtons = new ArrayList<Button>(9);
    private transient ChartWizardContext wizardContext;
    private static final String[] FONT_SIZE = new String[]{ChartUIUtil.FONT_AUTO, "9", "10", "12", "14", "16", "18", "24", "36"};

    public FontDefinitionDialog(Shell shellParent, ChartWizardContext wizardContext, FontDefinition fdCurrent, ColorDefinition cdCurrent, boolean isAlignmentEnabled) {
        super(shellParent);
        this.isAlignmentEnabled = isAlignmentEnabled;
        this.wizardContext = wizardContext;
        this.fdCurrent = fdCurrent == null ? FontDefinitionImpl.createEmpty() : fdCurrent.copyInstance();
        this.cdCurrent = cdCurrent == null ? null : cdCurrent.copyInstance();
        this.fdBackup = fdCurrent == null ? null : fdCurrent.copyInstance();
        this.cdBackup = this.cdCurrent == null ? null : cdCurrent.copyInstance();
    }

    public FontDefinitionDialog(Shell shellParent, ChartWizardContext wizardContext, FontDefinition fdCurrent, ColorDefinition cdCurrent, int optionalStyle) {
        super(shellParent);
        this.isAlignmentEnabled = (1 & optionalStyle) == 1;
        this.isRotationEnabled = (2 & optionalStyle) == 2;
        this.wizardContext = wizardContext;
        this.fdCurrent = fdCurrent == null ? FontDefinitionImpl.createEmpty() : fdCurrent.copyInstance();
        this.cdCurrent = cdCurrent == null ? null : cdCurrent.copyInstance();
        this.fdBackup = fdCurrent == null ? null : fdCurrent.copyInstance();
        this.cdBackup = this.cdCurrent == null ? null : cdCurrent.copyInstance();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x860 | 0x10000);
    }

    protected Control createContents(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FontEditor_ID");
        this.getShell().setText(Messages.getString("FontDefinitionDialog.Title.FontDescriptor"));
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        GridLayout glContent = new GridLayout();
        glContent.verticalSpacing = 5;
        glContent.horizontalSpacing = 5;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        glContent.numColumns = 9;
        this.cmpContent = new Composite(parent, 0);
        this.cmpContent.setLayout((Layout)glContent);
        this.cmpContent.setLayoutData((Object)new GridData(1808));
        Label lblFont = new Label(this.cmpContent, 0);
        GridData gdLFont = new GridData();
        lblFont.setLayoutData((Object)gdLFont);
        lblFont.setText(Messages.getString("FontDefinitionDialog.Lbl.Font"));
        this.cmbFontNames = new Combo(this.cmpContent, 12);
        GridData gdCMBFontNames = new GridData(768);
        gdCMBFontNames.horizontalSpan = 8;
        this.cmbFontNames.setLayoutData((Object)gdCMBFontNames);
        this.cmbFontNames.addSelectionListener((SelectionListener)this);
        this.cmbFontNames.setVisibleItemCount(30);
        Label lblSize = new Label(this.cmpContent, 0);
        GridData gdLSize = new GridData();
        lblSize.setLayoutData((Object)gdLSize);
        lblSize.setText(Messages.getString("FontDefinitionDialog.Lbl.Size"));
        this.cmbFontSizes = new Combo(this.cmpContent, 0);
        this.cmbFontSizes.setItems(FONT_SIZE);
        this.cmbFontSizes.setText(this.fdCurrent.isSetSize() ? String.valueOf((int)this.fdCurrent.getSize()) : ChartUIUtil.FONT_AUTO);
        GridData gdISCFontSizes = new GridData(768);
        gdISCFontSizes.horizontalSpan = 3;
        this.cmbFontSizes.setLayoutData((Object)gdISCFontSizes);
        this.cmbFontSizes.addSelectionListener((SelectionListener)this);
        this.cmbFontSizes.addFocusListener((FocusListener)this);
        this.cmbFontSizes.setVisibleItemCount(30);
        Label lblForeground = new Label(this.cmpContent, 0);
        GridData gdLForeground = new GridData();
        gdLForeground.horizontalSpan = 2;
        gdLForeground.horizontalIndent = 40;
        lblForeground.setLayoutData((Object)gdLForeground);
        lblForeground.setText(Messages.getString("FontDefinitionDialog.Lbl.Color"));
        this.fccColor = new FillChooserComposite(this.cmpContent, 0, this.wizardContext, (Fill)this.cdCurrent, false, false, true, false, false, false);
        GridData gdFCCColor = new GridData(768);
        gdFCCColor.horizontalSpan = 3;
        this.fccColor.setLayoutData(gdFCCColor);
        this.fccColor.addListener(this);
        this.createFontStylePanel();
        if (this.isAlignmentEnabled) {
            this.createAlignmentPanel();
        }
        if (this.isRotationEnabled) {
            this.createRotationPanel();
        }
        this.createPreviewPanel();
        this.populateLists();
        this.updatePreview();
        return this.cmpContent;
    }

    protected void cancelPressed() {
        this.fdCurrent = this.fdBackup;
        this.cdCurrent = this.cdBackup;
        super.cancelPressed();
    }

    private void createFontStylePanel() {
        Label lblStyle = new Label(this.cmpContent, 0);
        lblStyle.setText(Messages.getString("FontDefinitionDialog.Lbl.Style"));
        Composite cmpFontStyle = new Composite(this.cmpContent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cmpFontStyle.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalSpan = 8;
        cmpFontStyle.setLayoutData((Object)gd);
        this.btnBold = new Button(cmpFontStyle, 2);
        GridData gdBBold = new GridData();
        this.btnBold.setLayoutData((Object)gdBBold);
        this.btnBold.setImage(UIHelper.getImage((String)"icons/obj16/fnt_style_bold.gif"));
        this.btnBold.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.Bold"));
        this.btnBold.addSelectionListener((SelectionListener)this);
        this.btnBold.setSelection(this.fdCurrent.isSetBold() && this.fdCurrent.isBold());
        ChartUIUtil.addScreenReaderAccessbility((Control)this.btnBold, (String)this.btnBold.getToolTipText());
        this.btnItalic = new Button(cmpFontStyle, 2);
        GridData gdBItalic = new GridData();
        this.btnItalic.setLayoutData((Object)gdBItalic);
        this.btnItalic.setImage(UIHelper.getImage((String)"icons/obj16/fnt_style_italic.gif"));
        this.btnItalic.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.Italic"));
        this.btnItalic.addSelectionListener((SelectionListener)this);
        this.btnItalic.setSelection(this.fdCurrent.isSetItalic() && this.fdCurrent.isItalic());
        ChartUIUtil.addScreenReaderAccessbility((Control)this.btnItalic, (String)this.btnItalic.getToolTipText());
        this.btnUnderline = new Button(cmpFontStyle, 2);
        GridData gdBUnderline = new GridData();
        this.btnUnderline.setLayoutData((Object)gdBUnderline);
        this.btnUnderline.setImage(UIHelper.getImage((String)"icons/obj16/fnt_style_underline.gif"));
        this.btnUnderline.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.Underline"));
        this.btnUnderline.addSelectionListener((SelectionListener)this);
        this.btnUnderline.setSelection(this.fdCurrent.isSetUnderline() && this.fdCurrent.isUnderline());
        ChartUIUtil.addScreenReaderAccessbility((Control)this.btnUnderline, (String)this.btnUnderline.getToolTipText());
        this.btnStrikethru = new Button(cmpFontStyle, 2);
        this.btnStrikethru.setImage(UIHelper.getImage((String)"icons/obj16/fnt_style_Sthrough.gif"));
        this.btnStrikethru.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.Strikethrough"));
        this.btnStrikethru.addSelectionListener((SelectionListener)this);
        this.btnStrikethru.setSelection(this.fdCurrent.isSetStrikethrough() && this.fdCurrent.isStrikethrough());
        ChartUIUtil.addScreenReaderAccessbility((Control)this.btnStrikethru, (String)this.btnStrikethru.getToolTipText());
    }

    protected void createAlignmentPanel() {
        new Label(this.cmpContent, 0).setText(Messages.getString("FontDefinitionDialog.Lbl.Alignment"));
        Composite cmpAlignment = new Composite(this.cmpContent, 0);
        GridData gdCMPAlignment = new GridData(768);
        gdCMPAlignment.horizontalSpan = 8;
        cmpAlignment.setLayoutData((Object)gdCMPAlignment);
        GridLayout glAlignment = new GridLayout(12, false);
        glAlignment.marginWidth = 2;
        glAlignment.marginHeight = 0;
        cmpAlignment.setLayout((Layout)glAlignment);
        this.btnATopLeft = this.createAlighmentButton(cmpAlignment);
        this.btnATopCenter = this.createAlighmentButton(cmpAlignment);
        this.btnATopRight = this.createAlighmentButton(cmpAlignment);
        this.btnACenterLeft = this.createAlighmentButton(cmpAlignment);
        this.btnACenter = this.createAlighmentButton(cmpAlignment);
        this.btnACenterRight = this.createAlighmentButton(cmpAlignment);
        this.btnABottomLeft = this.createAlighmentButton(cmpAlignment);
        this.btnABottomCenter = this.createAlighmentButton(cmpAlignment);
        this.btnABottomRight = this.createAlighmentButton(cmpAlignment);
        if (this.isFlippedAxes()) {
            this.btnATopLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomRight"));
            this.btnATopLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomright.gif"));
            this.btnATopLeft.getImage().setBackground(this.btnATopLeft.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnATopLeft, (String)this.btnATopLeft.getToolTipText());
            this.btnATopCenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenterRight"));
            this.btnATopCenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenterright.gif"));
            this.btnATopCenter.getImage().setBackground(this.btnATopCenter.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnATopCenter, (String)this.btnATopCenter.getToolTipText());
            this.btnATopRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopRight"));
            this.btnATopRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopright.gif"));
            this.btnATopRight.getImage().setBackground(this.btnATopRight.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnATopRight, (String)this.btnATopRight.getToolTipText());
            this.createSeparator(cmpAlignment);
            this.btnACenterLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomCenter"));
            this.btnACenterLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomcenter.gif"));
            this.btnACenterLeft.getImage().setBackground(this.btnACenterLeft.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnACenterLeft, (String)this.btnACenterLeft.getToolTipText());
            this.btnACenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenter"));
            this.btnACenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenter.gif"));
            this.btnACenter.getImage().setBackground(this.btnACenter.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnACenter, (String)this.btnACenter.getToolTipText());
            this.btnACenterRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopCenter"));
            this.btnACenterRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopcenter.gif"));
            this.btnACenterRight.getImage().setBackground(this.btnACenterRight.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnACenterRight, (String)this.btnACenterRight.getToolTipText());
            this.createSeparator(cmpAlignment);
            this.btnABottomLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomLeft"));
            this.btnABottomLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomleft.gif"));
            this.btnABottomLeft.getImage().setBackground(this.btnABottomLeft.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnABottomLeft, (String)this.btnABottomLeft.getToolTipText());
            this.btnABottomCenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenterLeft"));
            this.btnABottomCenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenterleft.gif"));
            this.btnABottomCenter.getImage().setBackground(this.btnABottomCenter.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnABottomCenter, (String)this.btnABottomCenter.getToolTipText());
            this.btnABottomRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopLeft"));
            this.btnABottomRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopleft.gif"));
            this.btnABottomRight.getImage().setBackground(this.btnABottomRight.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnABottomRight, (String)this.btnABottomRight.getToolTipText());
        } else {
            this.btnATopLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopLeft"));
            this.btnATopLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopleft.gif"));
            this.btnATopLeft.getImage().setBackground(this.btnATopLeft.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnATopLeft, (String)this.btnATopLeft.getToolTipText());
            this.btnATopCenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopCenter"));
            this.btnATopCenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopcenter.gif"));
            this.btnATopCenter.getImage().setBackground(this.btnATopCenter.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnATopCenter, (String)this.btnATopCenter.getToolTipText());
            this.btnATopRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignTopRight"));
            this.btnATopRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmenttopright.gif"));
            this.btnATopRight.getImage().setBackground(this.btnATopRight.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnATopRight, (String)this.btnATopRight.getToolTipText());
            this.createSeparator(cmpAlignment);
            this.btnACenterLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenterLeft"));
            this.btnACenterLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenterleft.gif"));
            this.btnACenterLeft.getImage().setBackground(this.btnACenterLeft.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnACenterLeft, (String)this.btnACenterLeft.getToolTipText());
            this.btnACenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenter"));
            this.btnACenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenter.gif"));
            this.btnACenter.getImage().setBackground(this.btnACenter.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnACenter, (String)this.btnACenter.getToolTipText());
            this.btnACenterRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignCenterRight"));
            this.btnACenterRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmentcenterright.gif"));
            this.btnACenterRight.getImage().setBackground(this.btnACenterRight.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnACenterRight, (String)this.btnACenterRight.getToolTipText());
            this.createSeparator(cmpAlignment);
            this.btnABottomLeft.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomLeft"));
            this.btnABottomLeft.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomleft.gif"));
            this.btnABottomLeft.getImage().setBackground(this.btnABottomLeft.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnABottomLeft, (String)this.btnABottomLeft.getToolTipText());
            this.btnABottomCenter.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomCenter"));
            this.btnABottomCenter.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomcenter.gif"));
            this.btnABottomCenter.getImage().setBackground(this.btnABottomCenter.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnABottomCenter, (String)this.btnABottomCenter.getToolTipText());
            this.btnABottomRight.setToolTipText(Messages.getString("FontDefinitionDialog.Tooltip.AlignBottomRight"));
            this.btnABottomRight.setImage(UIHelper.getImage((String)"icons/obj28/alignmentbottomright.gif"));
            this.btnABottomRight.getImage().setBackground(this.btnABottomRight.getBackground());
            ChartUIUtil.addScreenReaderAccessbility((Control)this.btnABottomRight, (String)this.btnABottomRight.getToolTipText());
        }
    }

    protected boolean isSetAlignment() {
        return this.fdCurrent.getAlignment().isSetHorizontalAlignment() || this.fdCurrent.getAlignment().isSetVerticalAlignment();
    }

    protected Button createAlighmentButton(Composite parent) {
        Button button = new Button(parent, 2);
        GridData gd = new GridData();
        gd.widthHint = 32;
        gd.heightHint = 32;
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)this);
        this.listAlignmentButtons.add(button);
        return button;
    }

    private void selectAllToggleButtons(boolean selection) {
        int i = 0;
        while (i < this.listAlignmentButtons.size()) {
            this.listAlignmentButtons.get(i).setSelection(selection);
            ++i;
        }
    }

    protected void createSeparator(Composite parent) {
        Label lable = new Label(parent, 0);
        lable.setLayoutData((Object)new GridData(768));
    }

    private void createRotationPanel() {
        Composite cmpRotation = new Composite(this.cmpContent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        cmpRotation.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.heightHint = 150;
        cmpRotation.setLayoutData((Object)gd);
        Label lblRotation = new Label(cmpRotation, 0);
        lblRotation.setLayoutData((Object)new GridData(2));
        lblRotation.setText(Messages.getString("FontDefinitionDialog.Lbl.Rotation"));
        this.ascRotation = new AngleSelectorComposite(cmpRotation, 2048, ChartUIUtil.getFontRotation((FontDefinition)this.fdCurrent), Display.getCurrent().getSystemColor(1));
        GridData gdASCRotation = new GridData(1808);
        gdASCRotation.horizontalSpan = 2;
        this.ascRotation.setLayoutData(gdASCRotation);
        this.ascRotation.setAngleChangeListener(this);
        Label lblDegree = new Label(cmpRotation, 0);
        lblDegree.setLayoutData((Object)new GridData());
        lblDegree.setText(Messages.getString("FontDefinitionDialog.Label.Degree"));
        this.iscRotation = this.wizardContext.getUIFactory().createChartIntSpinner(cmpRotation, 0, ChartUIUtil.getFontRotation((FontDefinition)this.fdCurrent), (EObject)this.fdCurrent, "rotation", true);
        GridData gdISCRotation = new GridData(768);
        gdISCRotation.horizontalSpan = 2;
        gdISCRotation.minimumWidth = 40;
        this.iscRotation.setLayoutData((Object)gdISCRotation);
        this.iscRotation.setMinimum(-90);
        this.iscRotation.setMaximum(90);
        this.iscRotation.setIncrement(1);
        this.iscRotation.addListener((Listener)this);
        if (this.iscRotation instanceof IntegerSpinControl) {
            ((IntegerSpinControl)this.iscRotation).addScreenreaderAccessbility(lblDegree.getText());
        }
        this.ascRotation.setEnabled(this.iscRotation.isSpinnerEnabled());
    }

    private void createPreviewPanel() {
        Label lblPreview = new Label(this.cmpContent, 0);
        lblPreview.setText(Messages.getString("FontDefinitionDialog.Lbl.Preview"));
        lblPreview.setLayoutData((Object)new GridData(2));
        FillLayout flPreview = new FillLayout();
        flPreview.marginHeight = 2;
        flPreview.marginWidth = 3;
        Composite grpPreview = new Composite(this.cmpContent, 0);
        GridData gdGRPPreview = new GridData(1808);
        gdGRPPreview.horizontalSpan = 4;
        grpPreview.setLayoutData((Object)gdGRPPreview);
        grpPreview.setLayout((Layout)flPreview);
        this.fcPreview = new FontCanvas(grpPreview, 2048, this.fdCurrent, this.cdCurrent, true, true, true);
    }

    private void populateLists() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] saFontNames = ge.getAvailableFontFamilyNames();
        String currentFont = ChartUIUtil.getFontName((FontDefinition)this.fdCurrent);
        this.cmbFontNames.add(ChartUIUtil.FONT_AUTO);
        if (ChartUIUtil.FONT_AUTO.equals(currentFont)) {
            this.cmbFontNames.select(0);
        }
        int iC = 0;
        while (iC < saFontNames.length) {
            this.cmbFontNames.add(saFontNames[iC]);
            if (saFontNames[iC].equalsIgnoreCase(currentFont)) {
                this.cmbFontNames.select(iC + 1);
            }
            ++iC;
        }
        if (this.cmbFontNames.getSelectionIndex() == -1) {
            this.cmbFontNames.select(0);
        }
        if (this.isAlignmentEnabled && this.fdCurrent.getAlignment() != null && this.fdCurrent.getAlignment().isSetHorizontalAlignment() && this.fdCurrent.getAlignment().isSetVerticalAlignment()) {
            HorizontalAlignment ha = this.fdCurrent.getAlignment().getHorizontalAlignment();
            VerticalAlignment va = this.fdCurrent.getAlignment().getVerticalAlignment();
            if (HorizontalAlignment.LEFT_LITERAL.equals((Object)ha)) {
                if (VerticalAlignment.TOP_LITERAL.equals((Object)va)) {
                    this.btnATopLeft.setSelection(true);
                } else if (VerticalAlignment.BOTTOM_LITERAL.equals((Object)va)) {
                    this.btnABottomLeft.setSelection(true);
                } else {
                    this.btnACenterLeft.setSelection(true);
                }
            } else if (HorizontalAlignment.RIGHT_LITERAL.equals((Object)ha)) {
                if (VerticalAlignment.TOP_LITERAL.equals((Object)va)) {
                    this.btnATopRight.setSelection(true);
                } else if (VerticalAlignment.BOTTOM_LITERAL.equals((Object)va)) {
                    this.btnABottomRight.setSelection(true);
                } else {
                    this.btnACenterRight.setSelection(true);
                }
            } else if (VerticalAlignment.TOP_LITERAL.equals((Object)va)) {
                this.btnATopCenter.setSelection(true);
            } else if (VerticalAlignment.BOTTOM_LITERAL.equals((Object)va)) {
                this.btnABottomCenter.setSelection(true);
            } else {
                this.btnACenter.setSelection(true);
            }
        }
    }

    protected void updatePreview() {
        FontDefinition fd = this.fdCurrent.copyInstance();
        if (!this.isAlignmentEnabled) {
            fd.setAlignment(TextAlignmentImpl.create());
        }
        if (!this.isRotationEnabled) {
            fd.unsetRotation();
        }
        ChartUIUtil.getFlippedAlignment((TextAlignment)fd.getAlignment(), (boolean)this.isFlippedAxes());
        this.fcPreview.setFontDefinition(fd);
        this.fcPreview.redraw();
    }

    public FontDefinition getFontDefinition() {
        return this.fdCurrent;
    }

    public ColorDefinition getFontColor() {
        return this.cdCurrent == null || this.cdCurrent.isSetTransparency() && this.cdCurrent.getTransparency() == 0 ? null : this.cdCurrent;
    }

    public void widgetSelected(SelectionEvent e) {
        Object oSource = e.getSource();
        if (this.listAlignmentButtons.contains(oSource)) {
            if (!((Button)oSource).getSelection()) {
                this.fdCurrent.getAlignment().unsetHorizontalAlignment();
                this.fdCurrent.getAlignment().unsetVerticalAlignment();
                this.updatePreview();
                return;
            }
            this.selectAllToggleButtons(false);
            ((Button)oSource).setSelection(true);
        }
        if (oSource.equals(this.btnBold)) {
            this.fdCurrent.setBold(this.btnBold.getSelection());
            this.updatePreview();
        } else if (oSource.equals(this.btnItalic)) {
            this.fdCurrent.setItalic(this.btnItalic.getSelection());
            this.updatePreview();
        } else if (oSource.equals(this.btnUnderline)) {
            this.fdCurrent.setUnderline(this.btnUnderline.getSelection());
            this.updatePreview();
        } else if (oSource.equals(this.btnStrikethru)) {
            this.fdCurrent.setStrikethrough(this.btnStrikethru.getSelection());
            this.updatePreview();
        } else if (oSource.equals(this.cmbFontNames)) {
            if (this.cmbFontNames.getText().equals(ChartUIUtil.FONT_AUTO)) {
                this.fdCurrent.setName(null);
            } else {
                this.fdCurrent.setName(this.cmbFontNames.getText());
            }
            this.updatePreview();
        } else if (oSource.equals(this.cmbFontSizes)) {
            this.handleFontSize();
        } else if (oSource.equals(this.btnATopLeft)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnACenterLeft)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnABottomLeft)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnATopCenter)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnACenter)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnABottomCenter)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnATopRight)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.TOP_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnACenterRight)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.CENTER_LITERAL);
            this.updatePreview();
        } else if (oSource.equals(this.btnABottomRight)) {
            this.fdCurrent.getAlignment().setHorizontalAlignment(HorizontalAlignment.RIGHT_LITERAL);
            this.fdCurrent.getAlignment().setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
            this.updatePreview();
        }
    }

    protected void disableAlignmentBtns() {
        int i = 0;
        while (i < this.listAlignmentButtons.size()) {
            this.listAlignmentButtons.get(i).setSelection(false);
            this.listAlignmentButtons.get(i).setEnabled(false);
            ++i;
        }
    }

    public void handleEvent(Event e) {
        if (e.widget.equals(this.iscRotation)) {
            if (e.detail == ChartUIExtensionUtil.PROPERTY_UNSET) {
                this.fdCurrent.unsetRotation();
                this.ascRotation.setEnabled(false);
            } else {
                this.fdCurrent.setRotation((double)this.iscRotation.getValue());
                this.ascRotation.setAngle(this.iscRotation.getValue());
                this.ascRotation.setEnabled(true);
            }
            this.ascRotation.redraw();
            this.updatePreview();
        } else if (e.widget.equals((Object)this.fccColor) && e.type == 1) {
            this.cdCurrent = (ColorDefinition)this.fccColor.getFill();
            this.fcPreview.setColor(this.cdCurrent);
            this.fcPreview.redraw();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget.equals(this.cmbFontSizes)) {
            this.handleFontSize();
        }
    }

    private void handleFontSize() {
        if (this.cmbFontSizes.getText().equals(ChartUIUtil.FONT_AUTO)) {
            this.fdCurrent.unsetSize();
        } else {
            boolean oldIsset = this.fdCurrent.isSetSize();
            float oldValue = this.fdCurrent.getSize();
            boolean isCorrect = true;
            int value = 0;
            try {
                value = Integer.valueOf(this.cmbFontSizes.getText());
                if (value <= 0 || value > 7200) {
                    isCorrect = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                isCorrect = false;
            }
            if (!isCorrect) {
                this.cmbFontSizes.setText(oldIsset ? String.valueOf((int)oldValue) : ChartUIUtil.FONT_AUTO);
            } else {
                this.fdCurrent.setSize((float)value);
            }
        }
        this.updatePreview();
    }

    @Override
    public void angleChanged(int iNewAngle) {
        this.iscRotation.setValue(iNewAngle);
        this.fdCurrent.setRotation((double)iNewAngle);
        this.updatePreview();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget.equals(this.cmbFontSizes)) {
            this.cmbFontSizes.notifyListeners(14, null);
        }
    }

    protected boolean isFlippedAxes() {
        return this.wizardContext.getModel() instanceof ChartWithAxes && ((ChartWithAxes)this.wizardContext.getModel()).getOrientation().getValue() == 0;
    }
}

