/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.core.vm.js;

import org.eclipse.birt.report.debug.internal.core.vm.VMConstants;
import org.eclipse.birt.report.debug.internal.core.vm.VMValue;
import org.eclipse.birt.report.debug.internal.core.vm.VMVariable;
import org.eclipse.birt.report.debug.internal.core.vm.js.JsValue;

public class JsVariable
implements VMVariable,
VMConstants,
Comparable {
    private String name;
    private String typeName;
    private JsValue value;

    public JsVariable(Object value, String name) {
        this.name = name;
        this.value = new JsValue(value);
    }

    JsVariable(Object value, String name, String reservedTypeName) {
        this.name = name;
        this.value = new JsValue(value, reservedTypeName);
    }

    JsVariable(Object value, String name, boolean isPrimitive) {
        this.name = name;
        this.value = new JsValue(value, isPrimitive);
    }

    public String getName() {
        return this.name;
    }

    public VMValue getValue() {
        return this.value;
    }

    public String getTypeName() {
        if (this.typeName != null) {
            return this.typeName;
        }
        if (this.value != null) {
            return this.value.getTypeName();
        }
        return "null";
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof VMVariable) {
            VMVariable that = (VMVariable)arg0;
            if (this.name != null && !this.name.equals("this")) {
                int idx2;
                int idx1 = JsVariable.parseArrayElement(this.name);
                if (idx1 != -1 && (idx2 = JsVariable.parseArrayElement(that.getName())) != -1) {
                    return idx1 - idx2;
                }
                return this.name.compareToIgnoreCase(that.getName());
            }
        }
        return -1;
    }

    private static int parseArrayElement(String name) {
        if (name != null && name.length() > 2 && name.charAt(0) == '[' && name.charAt(name.length() - 1) == ']') {
            try {
                return Integer.parseInt(name.substring(1, name.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }
}

