/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.MultiViewsAPIProvider;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ReportItemThemeHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.IReportItemMethodContext;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.ThemeCommand;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ReportItemTheme;
import org.eclipse.birt.report.model.elements.interfaces.IReportItemModel;
import org.eclipse.birt.report.model.elements.interfaces.IStyledElementModel;
import org.eclipse.birt.report.model.elements.interfaces.ISupportThemeElement;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.strategy.ReportItemPropSearchStrategy;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.BoundDataColumnUtil;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.UnusedBoundColumnsMgr;
import org.eclipse.birt.report.model.util.VersionUtil;

public abstract class ReportItemHandleImpl
extends ReportElementHandle
implements IReportItemModel,
IStyledElementModel,
IReportItemMethodContext {
    public static final int DATABINDING_TYPE_NONE = 0;
    public static final int DATABINDING_TYPE_DATA = 1;
    public static final int DATABINDING_TYPE_REPORT_ITEM_REF = 2;

    public ReportItemHandleImpl(Module module, DesignElement element) {
        super(module, element);
    }

    public DataSetHandle getDataSet() {
        DesignElement dataSet = ((ReportItem)this.getElement()).getDataSetElement(this.module);
        if (dataSet == null) {
            return null;
        }
        assert (dataSet instanceof DataSet);
        return (DataSetHandle)dataSet.getHandle(dataSet.getRoot());
    }

    public void setDataSet(DataSetHandle handle) throws SemanticException {
        if (handle == null) {
            this.setStringProperty("dataSet", null);
        } else {
            ModuleHandle moduleHandle = handle.getRoot();
            String valueToSet = handle.getElement().getFullName();
            if (moduleHandle instanceof LibraryHandle) {
                String namespace = ((LibraryHandle)moduleHandle).getNamespace();
                valueToSet = StringUtil.buildQualifiedReference(namespace, valueToSet);
            }
            this.setStringProperty("dataSet", valueToSet);
        }
    }

    public CubeHandle getCube() {
        DesignElement cube = ((ReportItem)this.getElement()).getCubeElement(this.module);
        if (cube == null) {
            return null;
        }
        assert (cube instanceof Cube);
        return (CubeHandle)cube.getHandle(cube.getRoot());
    }

    public void setCube(CubeHandle handle) throws SemanticException {
        if (handle == null) {
            this.setStringProperty("cube", null);
        } else {
            ModuleHandle moduleHandle = handle.getRoot();
            String valueToSet = handle.getElement().getFullName();
            if (moduleHandle instanceof LibraryHandle) {
                String namespace = ((LibraryHandle)moduleHandle).getNamespace();
                valueToSet = StringUtil.buildQualifiedReference(namespace, valueToSet);
            }
            this.setStringProperty("cube", valueToSet);
        }
    }

    public DimensionHandle getX() {
        return super.getDimensionProperty("x");
    }

    public DimensionHandle getY() {
        return super.getDimensionProperty("y");
    }

    public void setX(String dimension) throws SemanticException {
        this.setProperty("x", dimension);
    }

    public void setX(double dimension) throws SemanticException {
        this.setFloatProperty("x", dimension);
    }

    public void setY(String dimension) throws SemanticException {
        this.setProperty("y", dimension);
    }

    public void setY(double dimension) throws SemanticException {
        this.setFloatProperty("y", dimension);
    }

    public void setHeight(String dimension) throws SemanticException {
        this.setProperty("height", dimension);
    }

    public void setHeight(double dimension) throws SemanticException {
        this.setFloatProperty("height", dimension);
    }

    public void setWidth(String dimension) throws SemanticException {
        this.setProperty("width", dimension);
    }

    public void setWidth(double dimension) throws SemanticException {
        this.setFloatProperty("width", dimension);
    }

    public DimensionHandle getWidth() {
        return super.getDimensionProperty("width");
    }

    public DimensionHandle getHeight() {
        return super.getDimensionProperty("height");
    }

    public String getBookmark() {
        return this.getStringProperty("bookmark");
    }

    public void setBookmark(String value) throws SemanticException {
        this.setStringProperty("bookmark", value);
    }

    public Iterator visibilityRulesIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("visibility");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.iterator();
    }

    public String getOnCreate() {
        return this.getStringProperty("onCreate");
    }

    public void setOnCreate(String value) throws SemanticException {
        this.setProperty("onCreate", value);
    }

    public String getOnRender() {
        return this.getStringProperty("onRender");
    }

    public void setOnRender(String value) throws SemanticException {
        this.setProperty("onRender", value);
    }

    public Iterator paramBindingsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("paramBindings");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.iterator();
    }

    public void setTocExpression(String expression) throws SemanticException {
        if (StringUtil.isEmpty(expression)) {
            this.setProperty("toc", null);
            return;
        }
        TOCHandle tocHandle = this.getTOC();
        if (StringUtil.isBlank(expression)) {
            return;
        }
        if (tocHandle == null) {
            TOC toc = StructureFactory.createTOC(expression);
            this.addTOC(toc);
        } else {
            tocHandle.setExpression(expression);
        }
    }

    public String getTocExpression() {
        TOCHandle tocHandle = this.getTOC();
        if (tocHandle == null) {
            return null;
        }
        return tocHandle.getExpression();
    }

    public String getOnPrepare() {
        return this.getStringProperty("onPrepare");
    }

    public void setOnPrepare(String script) throws SemanticException {
        this.setProperty("onPrepare", script);
    }

    public String getOnPageBreak() {
        return this.getStringProperty("onPageBreak");
    }

    public void setOnPageBreak(String script) throws SemanticException {
        this.setProperty("onPageBreak", script);
    }

    public Iterator columnBindingsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("boundDataColumns");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.iterator();
    }

    public PropertyHandle getColumnBindings() {
        return this.getPropertyHandle("boundDataColumns");
    }

    /*
     * Unable to fully structure code
     */
    public Iterator getAvailableBindings() {
        bindings = new ArrayList<E>();
        propHandle = this.getPropertyHandle("boundDataColumns");
        if (propHandle != null) {
            iter1 = propHandle.iterator();
            while (iter1.hasNext()) {
                bindings.add(iter1.next());
            }
        }
        if (this.getProperty("dataSet") != null) {
            return bindings.iterator();
        }
        container = this.getContainer();
        if (!(container instanceof ModuleHandle)) ** GOTO lbl15
        return bindings.iterator();
lbl-1000:
        // 1 sources

        {
            container = container.getContainer();
lbl15:
            // 2 sources

            ** while (container != null && !(container instanceof ReportItemHandle))
        }
lbl16:
        // 1 sources

        if (container == null) {
            return bindings.iterator();
        }
        iter1 = ((ReportItemHandle)container).getAvailableBindings();
        while (iter1.hasNext()) {
            bindings.add(iter1.next());
        }
        return bindings.iterator();
    }

    public ComputedColumnHandle addColumnBinding(ComputedColumn addColumn, boolean inForce) throws SemanticException {
        if (addColumn == null) {
            return null;
        }
        List columns = (List)this.getProperty("boundDataColumns");
        if (columns == null) {
            return (ComputedColumnHandle)this.getPropertyHandle("boundDataColumns").addItem(addColumn);
        }
        ComputedColumn column = BoundDataColumnUtil.getColumn(columns, addColumn);
        if (column != null && !inForce) {
            return (ComputedColumnHandle)column.handle(this.getPropertyHandle("boundDataColumns"), columns.indexOf(column));
        }
        return (ComputedColumnHandle)this.getPropertyHandle("boundDataColumns").addItem(addColumn);
    }

    public ComputedColumnHandle findColumnBinding(String name) {
        if (name == null) {
            return null;
        }
        List columns = (List)this.getProperty("boundDataColumns");
        if (columns == null) {
            return null;
        }
        int i = 0;
        while (i < columns.size()) {
            ComputedColumn column = (ComputedColumn)columns.get(i);
            if (name.equals(column.getName())) {
                return (ComputedColumnHandle)column.handle(this.getPropertyHandle("boundDataColumns"), i);
            }
            ++i;
        }
        return null;
    }

    public void removedUnusedColumnBindings() throws SemanticException {
        UnusedBoundColumnsMgr.removedUnusedBoundColumns(this);
    }

    public TOCHandle getTOC() {
        PropertyHandle propHandle = this.getPropertyHandle("toc");
        if (propHandle == null) {
            return null;
        }
        TOC toc = (TOC)propHandle.getValue();
        if (toc == null) {
            return null;
        }
        return (TOCHandle)toc.getHandle(propHandle);
    }

    public TOCHandle addTOC(String expression) throws SemanticException {
        if (StringUtil.isEmpty(expression)) {
            return null;
        }
        TOC toc = StructureFactory.createTOC(expression);
        this.setProperty("toc", toc);
        return (TOCHandle)toc.getHandle(this.getPropertyHandle("toc"));
    }

    public TOCHandle addTOC(TOC toc) throws SemanticException {
        this.setProperty("toc", toc);
        if (toc == null) {
            return null;
        }
        return (TOCHandle)toc.getHandle(this.getPropertyHandle("toc"));
    }

    public int getZIndex() {
        return super.getIntProperty("zIndex");
    }

    public void setZIndex(int zIndex) throws SemanticException {
        this.setIntProperty("zIndex", zIndex);
    }

    public List getMethods(String methodName) {
        return Collections.EMPTY_LIST;
    }

    public void setDataBindingReference(ReportItemHandle item) throws SemanticException {
        this.setProperty("dataBindingRef", item);
    }

    public String getDataBindingReferenceName() {
        return (String)this.getProperty("dataBindingRef");
    }

    public ReportItemHandle getDataBindingReference() {
        ElementRefValue refValue = (ElementRefValue)this.getElement().getProperty(this.module, "dataBindingRef");
        if (refValue == null || !refValue.isResolved()) {
            return null;
        }
        DesignElement tmpElement = refValue.getElement();
        return (ReportItemHandle)tmpElement.getHandle(tmpElement.getRoot());
    }

    public int getDataBindingType() {
        if (this.getDataBindingReferenceName() != null) {
            return 2;
        }
        if (this.element.getProperty(this.module, "dataSet") != null || this.element.getProperty(this.module, "cube") != null) {
            return 1;
        }
        return 0;
    }

    public List getAvailableDataBindingReferenceList() {
        return this.getAvailableDataBindingReferenceList(null);
    }

    public List getNamedDataBindingReferenceList() {
        return this.getNamedDataBindingReferenceList(null);
    }

    public List getAvailableDataSetBindingReferenceList() {
        return this.getAvailableDataBindingReferenceList("dataSet");
    }

    public List getNamedDataSetBindingReferenceList() {
        return this.getNamedDataBindingReferenceList("dataSet");
    }

    public List getAvailableCubeBindingReferenceList() {
        return this.getAvailableDataBindingReferenceList("cube");
    }

    public List getNamedCubeBindingReferenceList() {
        return this.getNamedDataBindingReferenceList("cube");
    }

    protected List getAvailableDataBindingReferenceList(String propName) {
        ArrayList<ReportItemHandle> rtnList = new ArrayList<ReportItemHandle>();
        int slotID = -1;
        if (this.module instanceof ReportDesign) {
            slotID = 6;
        } else if (this.module instanceof Library) {
            slotID = 5;
        }
        ContentIterator iter1 = new ContentIterator(this.module, new ContainerContext((DesignElement)this.module, slotID));
        while (iter1.hasNext()) {
            DesignElement e = iter1.next();
            if (e == this.getElement() || !(e instanceof ReportItem) || ModelUtil.checkContainerOrContent(this.getElement(), e)) continue;
            ReportItemHandle elementHandle = (ReportItemHandle)e.getHandle(this.module);
            int bindingType = elementHandle.getDataBindingType();
            if (bindingType == 1 && (propName == null || elementHandle.getProperty(propName) != null)) {
                rtnList.add(elementHandle);
                continue;
            }
            if (bindingType == 0) {
                Object tmpValue = e.getLocalProperty(this.module, "boundDataColumns");
                if (!(tmpValue instanceof List) || ((List)tmpValue).isEmpty()) continue;
                rtnList.add(elementHandle);
                continue;
            }
            if (bindingType != 2) continue;
            ReportItemHandle tmpElementHandle = elementHandle.getDataBindingReference();
            if (tmpElementHandle == null) {
                rtnList.add(elementHandle);
                continue;
            }
            if (!(this.element instanceof IReferencableElement) || ModelUtil.isRecursiveReference(((DesignElementHandle)tmpElementHandle).getElement(), (IReferencableElement)((Object)this.element)) || propName != null && ((DesignElementHandle)tmpElementHandle).getProperty(propName) == null) continue;
            rtnList.add(elementHandle);
        }
        if (rtnList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(rtnList);
    }

    private List getNamedDataBindingReferenceList(String propName) {
        List tmpList = this.getAvailableDataBindingReferenceList(propName);
        ArrayList<ReportItemHandle> retList = new ArrayList<ReportItemHandle>();
        int i = 0;
        while (i < tmpList.size()) {
            ReportItemHandle item = (ReportItemHandle)tmpList.get(i);
            if (item.getName() != null) {
                retList.add(item);
            }
            ++i;
        }
        return retList;
    }

    public void removedColumnBindings(List bindingNameList) throws SemanticException {
        if (bindingNameList == null || bindingNameList.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < bindingNameList.size()) {
            this.removedColumnBinding((String)bindingNameList.get(i));
            ++i;
        }
    }

    public void removedColumnBinding(String bindingName) throws SemanticException {
        ComputedColumnHandle toRemoveColumn = this.findColumnBinding(bindingName);
        if (toRemoveColumn == null) {
            return;
        }
        toRemoveColumn.drop();
    }

    public DesignElementHandle getCurrentView() {
        MultiViewsAPIProvider provider = new MultiViewsAPIProvider((ReportItemHandle)this, "multiViews");
        return provider.getCurrentView();
    }

    public void addView(DesignElementHandle viewElement) throws SemanticException {
        MultiViewsAPIProvider provider = new MultiViewsAPIProvider((ReportItemHandle)this, "multiViews");
        provider.addView(viewElement);
    }

    public void dropView(DesignElementHandle viewElement) throws SemanticException {
        MultiViewsAPIProvider provider = new MultiViewsAPIProvider((ReportItemHandle)this, "multiViews");
        provider.dropView(viewElement);
    }

    public void setCurrentView(DesignElementHandle viewElement) throws SemanticException {
        MultiViewsAPIProvider provider = new MultiViewsAPIProvider((ReportItemHandle)this, "multiViews");
        provider.setCurrentView(viewElement);
    }

    public List getViews() {
        MultiViewsAPIProvider provider = new MultiViewsAPIProvider((ReportItemHandle)this, "multiViews");
        return provider.getViews();
    }

    public boolean canAddView(String extensionType) {
        MultiViewsAPIProvider provider = new MultiViewsAPIProvider((ReportItemHandle)this, "multiViews");
        return provider.canAddView(extensionType);
    }

    public String getACLExpression() {
        return this.getStringProperty("ACLExpression");
    }

    public void setACLExpression(String expr) throws SemanticException {
        this.setStringProperty("ACLExpression", expr);
    }

    public boolean cascadeACL() {
        return this.getBooleanProperty("cascadeACL");
    }

    public void setCascadeACL(boolean cascadeACL) throws SemanticException {
        this.setBooleanProperty("cascadeACL", cascadeACL);
    }

    public boolean canCascadeACL() {
        return ((ReportItem)this.getElement()).canCascadeACL();
    }

    public boolean allowExport() {
        return this.getBooleanProperty("allowExport");
    }

    public void setAllowExport(boolean allowExport) throws SemanticException {
        this.setProperty("allowExport", String.valueOf(allowExport));
    }

    public ReportItemHandle getViewHost() {
        DesignElementHandle container = this.getContainer();
        if (!(container instanceof MultiViewsHandle)) {
            return null;
        }
        MultiViewsHandle viewHandle = (MultiViewsHandle)container;
        DesignElementHandle viewHost = viewHandle.getContainer();
        return viewHost instanceof ReportItemHandle ? (ReportItemHandle)viewHost : null;
    }

    public String getBookmarkDisplayName() {
        return this.getStringProperty("bookmarkDisplayName");
    }

    public void setBookmarkDisplayName(String bookmarkDisplayName) throws SemanticException {
        this.setStringProperty("bookmarkDisplayName", bookmarkDisplayName);
    }

    public boolean pushDown() {
        PropertyDefn prop = (PropertyDefn)((Object)this.getPropertyDefn("pushDown"));
        Object value = this.getProperty("pushDown");
        return prop.getBooleanValue(this.module, value);
    }

    public void setPushDown(boolean pushDown) throws SemanticException {
        this.setProperty("pushDown", pushDown);
    }

    @Override
    public Object getProperty(String propName) {
        if ("pushDown".equals(propName)) {
            Object pushDown = ReportItemPropSearchStrategy.getInstance().getPropertyFromElement(this.module, this.element, this.element.getPropertyDefn(propName));
            if (pushDown != null) {
                assert (pushDown instanceof Boolean);
                return (boolean)((Boolean)pushDown);
            }
            if (this.module.getVersionManager() == null || VersionUtil.parseVersion(this.module.getVersionManager().getVersion()) < 3022000) {
                return Boolean.FALSE;
            }
        }
        return super.getProperty(propName);
    }

    public void setThemeName(String themeName) throws SemanticException {
        if (!(this.element instanceof ISupportThemeElement)) {
            throw new IllegalOperationException();
        }
        ThemeCommand command = new ThemeCommand(this.getModule(), this.element);
        command.setTheme(themeName);
    }

    public void setTheme(ReportItemThemeHandle theme) throws SemanticException {
        if (!(this.element instanceof ISupportThemeElement)) {
            throw new IllegalOperationException();
        }
        ThemeCommand command = new ThemeCommand(this.getModule(), this.getElement());
        command.setThemeElement(theme);
    }

    public final ReportItemThemeHandle getTheme() {
        ReportItemTheme theme = (ReportItemTheme)((ReportItem)this.element).getTheme(this.module);
        if (theme == null) {
            return null;
        }
        return (ReportItemThemeHandle)theme.getHandle(theme.getRoot());
    }

    public String getRole() {
        return this.getStringProperty("role");
    }

    public void setRole(String role) throws SemanticException {
        this.setStringProperty("role", role);
    }

    public String getLanguage() {
        return this.getStringProperty("language");
    }

    public void setLanguage(String language) throws SemanticException {
        this.setStringProperty("language", language);
    }

    public String getAltText() {
        return this.getStringProperty("altText");
    }

    public void setAltText(String altText) throws SemanticException {
        this.setStringProperty("altText", altText);
    }

    public int getOrder() {
        return this.getIntProperty("order");
    }

    public void setOrder(int order) throws SemanticException {
        this.setIntProperty("order", order);
    }

    public String getURL() {
        return this.getStringProperty("url");
    }

    public void setURL(String url) throws SemanticException {
        this.setStringProperty("url", url);
    }
}

