/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.actions;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.core.mediator.IMediatorRequest;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.data.ui.dataset.AdvancedDataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DefaultDataSetWizard;
import org.eclipse.birt.report.designer.data.ui.datasource.DefaultDataSourceWizard;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewDataSetAction
extends Action
implements UpdateAction {
    public static final String ID = "org.eclipse.birt.report.designer.ui.actions.NewDataSetAction";
    private DataSetHandle dataSetHandle;

    public NewDataSetAction() {
        this.setId(ID);
    }

    public NewDataSetAction(String text) {
        super(text);
        this.setId(ID);
    }

    public NewDataSetAction(String text, int style) {
        super(text, style);
        this.setId(ID);
    }

    public NewDataSetAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(ID);
    }

    public void update() {
        this.setEnabled(SessionHandleAdapter.getInstance().getReportDesignHandle() != null);
    }

    public boolean isEnabled() {
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (moduleHandle == null) {
            return false;
        }
        return super.isEnabled();
    }

    public void run() {
        if (!this.isEnabled()) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"dataset.error.title.noReportDesign"), (String)Messages.getString((String)"dataset.error.msg.noReportDesign"));
            return;
        }
        if (Policy.TRACING_ACTIONS) {
            System.out.println("New data set action >> Run ...");
        }
        SessionHandleAdapter.getInstance().getCommandStack().startPersistentTrans(Messages.getString((String)"dataset.new"));
        if (HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().getModuleHandle().getVisibleDataSources().isEmpty()) {
            boolean createNewDataSource = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"dataset.error.title.noDataSources"), (String)Messages.getString((String)"dataset.error.noDataSources"));
            if (createNewDataSource) {
                DefaultDataSourceWizard wizard = new DefaultDataSourceWizard();
                String wizardTitle = Messages.getString((String)"datasource.new");
                wizard.setWindowTitle(wizardTitle);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
                if (dialog.open() == 1) {
                    this.notifyResult(false);
                    SessionHandleAdapter.getInstance().getCommandStack().rollback();
                    return;
                }
                this.createNewDataSet();
            } else {
                this.notifyResult(false);
                SessionHandleAdapter.getInstance().getCommandStack().rollback();
            }
        } else {
            this.createNewDataSet();
        }
    }

    private void createNewDataSet() {
        DefaultDataSetWizard wizard = new DefaultDataSetWizard();
        wizard.setWindowTitle(Messages.getString((String)"dataset.new"));
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            DataSetHandle ds = wizard.getNewCreateDataSetHandle();
            if (this.editDataSet(ds)) {
                this.notifyResult(true);
            } else {
                this.notifyResult(false);
            }
            ReportRequest request = new ReportRequest("create element");
            ArrayList<DataSetHandle> selectionObjects = new ArrayList<DataSetHandle>();
            selectionObjects.add(this.dataSetHandle);
            request.setSelectionObject(selectionObjects);
            SessionHandleAdapter.getInstance().getMediator().notifyRequest((IMediatorRequest)request);
            SessionHandleAdapter.getInstance().getCommandStack().commit();
        } else {
            this.notifyResult(false);
            SessionHandleAdapter.getInstance().getCommandStack().rollback();
        }
    }

    private boolean editDataSet(DataSetHandle ds) {
        this.dataSetHandle = ds;
        if (this.dataSetHandle == null) {
            return false;
        }
        if (this.dataSetHandle instanceof ScriptDataSetHandle) {
            return false;
        }
        AdvancedDataSetEditor dialog = new AdvancedDataSetEditor(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.dataSetHandle, true, true);
        return dialog.open() == 0;
    }
}

