/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractElementAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementDetailHandle;
import org.eclipse.gef.Request;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EditAction
extends AbstractElementAction {
    public static final String TEXT = Messages.getString((String)"EditAction.text");

    public EditAction(Object selectedObject) {
        this(selectedObject, TEXT);
    }

    public EditAction(Object selectedObject, String text) {
        super(selectedObject, text);
    }

    public boolean isEnabled() {
        if (this.getSelectedElement() != null) {
            return this.getSelectedElement().canEdit();
        }
        return this.getSelectedElementDetail() != null;
    }

    protected boolean doAction() throws Exception {
        if (this.getSelectedElement() != null) {
            return ProviderFactory.createProvider(this.getSelectedElement()).performRequest(this.getSelectedElement(), new Request((Object)"edit"));
        }
        if (this.getSelectedElementDetail() != null) {
            return ProviderFactory.createProvider(this.getSelectedElementDetail()).performRequest(this.getSelectedElementDetail(), new Request((Object)"edit"));
        }
        return false;
    }

    private DesignElementHandle getSelectedElement() {
        Object obj = super.getSelection();
        if (obj instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)obj;
            if (selection.size() != 1) {
                return null;
            }
            obj = selection.getFirstElement();
        }
        if (obj instanceof DesignElementHandle) {
            return (DesignElementHandle)obj;
        }
        return null;
    }

    private ElementDetailHandle getSelectedElementDetail() {
        Object obj = super.getSelection();
        if (obj instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)obj;
            if (selection.size() != 1) {
                return null;
            }
            obj = selection.getFirstElement();
        }
        if (obj instanceof ElementDetailHandle) {
            return (ElementDetailHandle)obj;
        }
        return null;
    }
}

