/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.TextContent;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;

public class LabelContent
extends TextContent
implements ILabelContent {
    protected String helpTextKey;
    protected String labelText;
    protected String labelTextKey;
    protected static final short FIELD_HELPTEXTKEY = 600;
    protected static final short FIELD_LABELTEXT = 601;
    protected static final short FIELD_LABELTEXTKEY = 602;

    LabelContent(ILabelContent label) {
        super(label);
        LabelContent originalLabel = (LabelContent)label;
        this.helpText = originalLabel.helpText;
        this.labelTextKey = originalLabel.labelTextKey;
        this.helpTextKey = originalLabel.helpTextKey;
        this.labelText = originalLabel.labelText;
    }

    @Override
    public int getContentType() {
        return 6;
    }

    LabelContent(ReportContent report) {
        super(report);
    }

    LabelContent(IContent content) {
        super(content);
    }

    @Override
    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    @Override
    public String getHelpText() {
        if (this.helpText == null && this.generateBy instanceof LabelItemDesign) {
            return ((LabelItemDesign)this.generateBy).getHelpText();
        }
        return this.helpText;
    }

    public void setHelpKey(String helpKey) {
        this.helpTextKey = helpKey;
    }

    @Override
    public String getHelpKey() {
        if (this.helpTextKey == null && this.generateBy instanceof LabelItemDesign) {
            return ((LabelItemDesign)this.generateBy).getHelpTextKey();
        }
        return this.helpTextKey;
    }

    @Override
    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    @Override
    public String getLabelText() {
        if (this.labelText == null && this.generateBy instanceof LabelItemDesign) {
            return ((LabelItemDesign)this.generateBy).getText();
        }
        return this.labelText;
    }

    @Override
    public void setLabelKey(String labelKey) {
        this.labelTextKey = labelKey;
    }

    @Override
    public String getLabelKey() {
        if (this.labelTextKey == null && this.generateBy instanceof LabelItemDesign) {
            return ((LabelItemDesign)this.generateBy).getTextKey();
        }
        return this.labelTextKey;
    }

    @Override
    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitLabel(this, value);
    }

    @Override
    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.helpTextKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)600);
            IOUtil.writeString((DataOutputStream)out, (String)this.helpTextKey);
        }
        if (this.labelText != null) {
            IOUtil.writeShort((OutputStream)out, (short)601);
            IOUtil.writeString((DataOutputStream)out, (String)this.labelText);
        }
        if (this.labelTextKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)602);
            IOUtil.writeString((DataOutputStream)out, (String)this.labelTextKey);
        }
    }

    @Override
    public boolean needSave() {
        if (this.helpTextKey != null) {
            return true;
        }
        if (this.labelText != null || this.labelTextKey != null) {
            return true;
        }
        return super.needSave();
    }

    @Override
    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 600: {
                this.helpTextKey = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 601: {
                this.labelText = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 602: {
                this.labelTextKey = IOUtil.readString((DataInputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    @Override
    protected IContent cloneContent() {
        return new LabelContent(this);
    }
}

