/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.AbstractMultiViewsHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.MultiViewsElementProvider;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.interfaces.IMultiViewsModel;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

class MultiViewsAPIProvider
implements IMultiViewsModel {
    private ReportItemHandle element;
    private String propertyName;

    public MultiViewsAPIProvider(ReportItemHandle element, String propName) {
        this.element = element;
        this.propertyName = propName;
        if (this.element == null) {
            throw new IllegalArgumentException("Must provide a NON-NULL element.");
        }
        if (propName == null) {
            throw new IllegalArgumentException("Must provide the name for the views property.");
        }
        IElementPropertyDefn propDefn = element.getPropertyDefn(propName);
        if (propDefn == null) {
            this.propertyName = null;
            return;
        }
        if (propDefn.getTypeCode() != 23) {
            throw new IllegalArgumentException("The views property must defined as element type.");
        }
    }

    public DesignElementHandle getCurrentView() {
        if (this.propertyName == null) {
            return null;
        }
        AbstractMultiViewsHandle multiView = (AbstractMultiViewsHandle)this.element.getProperty(this.propertyName);
        if (multiView == null || multiView.getCurrentViewIndex() == -1) {
            return null;
        }
        MultiViewsElementProvider subProvider = new MultiViewsElementProvider(multiView);
        return subProvider.getCurrentView();
    }

    public List getViews() {
        if (this.propertyName == null) {
            return Collections.EMPTY_LIST;
        }
        AbstractMultiViewsHandle multiView = (AbstractMultiViewsHandle)this.element.getProperty(this.propertyName);
        if (multiView == null) {
            return Collections.EMPTY_LIST;
        }
        MultiViewsElementProvider subProvider = new MultiViewsElementProvider(multiView);
        return subProvider.getViews();
    }

    public void addView(DesignElementHandle viewElement) throws SemanticException {
        if (this.propertyName == null) {
            return;
        }
        AbstractMultiViewsHandle multiView = (AbstractMultiViewsHandle)this.element.getProperty(this.propertyName);
        ModuleHandle module = this.element.getModuleHandle();
        CommandStack stack = module.getCommandStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.AddElement"));
        try {
            if (multiView == null) {
                multiView = module.getElementFactory().newMultiView();
                this.element.setProperty(this.propertyName, multiView);
            }
            MultiViewsElementProvider subProvider = new MultiViewsElementProvider(multiView);
            subProvider.addView(viewElement);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void dropView(DesignElementHandle viewElement) throws SemanticException {
        if (this.propertyName == null) {
            return;
        }
        AbstractMultiViewsHandle multiView = (AbstractMultiViewsHandle)this.element.getProperty(this.propertyName);
        if (multiView == null) {
            return;
        }
        MultiViewsElementProvider subProvider = new MultiViewsElementProvider(multiView);
        subProvider.dropView(viewElement);
    }

    public void setCurrentView(DesignElementHandle viewElement) throws SemanticException {
        if (this.propertyName == null) {
            return;
        }
        DesignElement internalElement = this.element.getElement();
        if (viewElement != null && viewElement.getContainer() != null && !viewElement.getElement().isContentOf(internalElement)) {
            throw new PropertyValueException(internalElement, this.element.getPropertyDefn(this.propertyName), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        if (viewElement != null && viewElement == this.element) {
            throw new PropertyValueException(internalElement, this.element.getPropertyDefn(this.propertyName), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
        }
        ModuleHandle module = this.element.getModuleHandle();
        CommandStack stack = module.getCommandStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ChangeProperty", new String[]{"views"}));
        try {
            AbstractMultiViewsHandle multiView = (AbstractMultiViewsHandle)this.element.getProperty(this.propertyName);
            if (multiView == null) {
                multiView = module.getElementFactory().newMultiView();
                this.element.setProperty(this.propertyName, multiView);
            }
            if (viewElement != null && viewElement.getContainer() != null && !viewElement.getElement().isContentOf(multiView.getElement())) {
                throw new PropertyValueException(internalElement, this.element.getPropertyDefn(this.propertyName), null, "Error.PropertyValueException.ITEM_NOT_FOUND");
            }
            if (viewElement != null && viewElement.getContainer() == null) {
                MultiViewsElementProvider subProvider = new MultiViewsElementProvider(multiView);
                subProvider.addView(viewElement);
            }
            int newIndex = -1;
            assert (viewElement != this.element);
            if (viewElement != null) {
                ContainerContext context = new ContainerContext(multiView.getElement(), "views");
                newIndex = context.indexOf(viewElement.getElement());
                assert (newIndex != -1);
            }
            multiView.setCurrentViewIndex(newIndex);
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public boolean canAddView(String extensionType) {
        if (this.propertyName == null) {
            return false;
        }
        AbstractMultiViewsHandle multiView = (AbstractMultiViewsHandle)this.element.getProperty(this.propertyName);
        ModuleHandle module = this.element.getModuleHandle();
        if (multiView == null) {
            multiView = module.getElementFactory().newMultiView();
            return this.element.canContain(this.propertyName, (DesignElementHandle)multiView);
        }
        ExtendedItemHandle itemHandle = module.getElementFactory().newExtendedItem(null, extensionType);
        if (itemHandle == null) {
            return false;
        }
        return multiView.canContain("views", (DesignElementHandle)itemHandle);
    }
}

