/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.core.DataException;

public abstract class SummaryAccumulator
extends Accumulator {
    protected int dataType = -1;
    protected boolean isFinished = false;
    protected ICalculator calculator;

    @Override
    public void start() {
        this.isFinished = false;
        this.dataType = -1;
        this.calculator = null;
    }

    @Override
    public void finish() throws DataException {
        this.isFinished = true;
    }

    @Override
    public Object getValue() throws DataException {
        if (!this.isFinished) {
            throw new RuntimeException("Error! Call summary total function before finished the dataset");
        }
        return this.getSummaryValue();
    }

    protected Object getTypedData(Object obj) throws DataException {
        Object value = obj;
        switch (this.dataType) {
            case -1: {
                if (obj instanceof Date) {
                    this.dataType = 6;
                    break;
                }
                if (obj instanceof BigDecimal) {
                    this.dataType = 4;
                    break;
                }
                value = this.toDouble(obj);
                this.dataType = 3;
                break;
            }
            case 3: {
                value = this.toDouble(obj);
            }
        }
        return value;
    }

    protected Object toDouble(Object obj) throws DataException {
        Double value = null;
        try {
            value = DataTypeUtil.toDouble(obj);
        }
        catch (BirtException e) {
            throw new DataException("data.engine.DataConversionError", e);
        }
        return value;
    }

    public abstract Object getSummaryValue() throws DataException;
}

