/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;

public class URLParser {
    private static Logger logger = Logger.getLogger(URLParser.class.getName());
    private Object resourceIdentifiers;

    public URLParser(Map appContext) {
        if (appContext != null) {
            this.resourceIdentifiers = appContext.get("org.eclipse.datatools.connectivity.oda.util_consumerResourceIds");
        }
        if (this.resourceIdentifiers == null) {
            logger.log(Level.WARNING, "No ResourceIdentifiers are provided in appContext!");
        }
    }

    public URL[] parse(String classPath) throws OdaException {
        if (classPath == null) {
            return new URL[0];
        }
        String[] paths = classPath.split(String.valueOf(';'));
        ArrayList<URL> urls = new ArrayList<URL>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (!(path = path.trim()).equals("")) {
                URI uri = null;
                if (new File(path).isAbsolute()) {
                    uri = new File(path).toURI();
                    try {
                        urls.add(uri.toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new OdaException((Throwable)e);
                    }
                }
                try {
                    uri = new URI(this.resolveURI(path));
                }
                catch (URISyntaxException e) {
                    throw new OdaException((Throwable)e);
                }
                if (this.resourceIdentifiers != null) {
                    URI resovledUri = ResourceIdentifiers.resolveApplResource((Object)this.resourceIdentifiers, (URI)uri);
                    if (resovledUri == null) {
                        logger.log(Level.WARNING, "Failed to resolve path:" + uri + " from app resource folder(" + ResourceIdentifiers.getApplResourceBaseURI((Object)this.resourceIdentifiers) + ')');
                        resovledUri = ResourceIdentifiers.resolveDesignResource((Object)this.resourceIdentifiers, (URI)uri);
                    }
                    if (resovledUri == null) {
                        logger.log(Level.WARNING, "Failed to resolve path:" + uri);
                    } else {
                        try {
                            try {
                                String urlpath = this.enableURI(URLDecoder.decode(resovledUri.toString(), "UTF-8"));
                                urls.add(new URL(urlpath));
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                urls.add(resovledUri.toURL());
                            }
                        }
                        catch (MalformedURLException e) {
                            throw new OdaException((Throwable)e);
                        }
                    }
                } else {
                    try {
                        urls.add(uri.toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new OdaException((Throwable)e);
                    }
                }
            }
            ++n2;
        }
        return urls.toArray(new URL[0]);
    }

    private String resolveURI(String location) {
        String result = this.enableURI(location);
        if (!result.endsWith(".jar") && !result.endsWith(".zip") && result.charAt(result.length() - 1) != '/') {
            result = String.valueOf(result) + "/";
        }
        return result;
    }

    private String enableURI(String location) {
        String result = location;
        try {
            if (File.separatorChar != '/') {
                location = location.replace(File.separatorChar, '/');
            }
            result = location.startsWith("/") ? new File(location).toURI().toASCIIString().replace(new File("/").toURI().toASCIIString(), "/") : new File(location).toURI().toASCIIString().replace(new File("").toURI().toASCIIString(), "");
        }
        catch (Exception exception) {
            return location;
        }
        return result;
    }
}

