/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshAction;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.actions.ShowPropertyAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.action.EditCubeMeasureAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.page.CubeBuilder;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TabularMeasureNodeProvider
extends DefaultNodeProvider {
    private static final Image IMG_DERIVED_MEASURE = UIHelper.getImage("icons/obj16/derived_measure.gif");
    private static final Image IMG_MEASURE = UIHelper.getImage("icons/obj16/measure_group.gif");

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        super.createContextMenu(sourceViewer, object, menu);
        if (((MeasureHandle)object).canEdit()) {
            menu.insertAfter("additions", (IAction)new EditCubeMeasureAction(object, Messages.getString("CubeMeasureNodeProvider.menu.text")));
        }
        menu.insertBefore("additions-refresh", (IAction)new ShowPropertyAction(object));
        menu.insertAfter("additions-refresh", (IContributionItem)new Separator());
        RefreshAction action = new RefreshAction(sourceViewer);
        if (action.isEnabled()) {
            menu.insertAfter("additions-refresh", (IAction)action);
        }
    }

    public Object getParent(Object model) {
        MeasureHandle measure = (MeasureHandle)model;
        return measure.getContainer();
    }

    public String getNodeDisplayName(Object model) {
        MeasureHandle handle = (MeasureHandle)model;
        if (handle.getDisplayName() != null && handle.getDisplayName().trim().length() > 0) {
            return handle.getDisplayName();
        }
        return handle.getName();
    }

    public boolean hasChildren(Object object) {
        return false;
    }

    protected boolean performEdit(ReportElementHandle handle) {
        MeasureHandle measureHandle = (MeasureHandle)handle;
        CubeBuilder dialog = new CubeBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (TabularCubeHandle)measureHandle.getContainer().getContainer());
        dialog.showPage("org.eclipse.birt.datasource.editor.cubebuilder.grouppage");
        return dialog.open() == 0;
    }

    public String getIconName(Object model) {
        return "DataColumn";
    }

    public Image getNodeIcon(Object model) {
        if (model instanceof DesignElementHandle && ((DesignElementHandle)model).getSemanticErrors().size() > 0) {
            return ReportPlatformUIImages.getImage((String)"IMG_OBJS_ERROR_TSK");
        }
        if (model instanceof MeasureHandle) {
            return ((MeasureHandle)model).isCalculated() ? IMG_DERIVED_MEASURE : IMG_MEASURE;
        }
        return super.getNodeIcon(model);
    }
}

