/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.editors;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.ui.preview.extension.IViewer;
import org.eclipse.birt.report.designer.ui.preview.parameter.ParameterFactory;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;

public abstract class AbstractViewer
implements IViewer {
    private IReportEngine engine;
    private static String RPTDOC_SUFFIX = "rptdocument";

    public void init() {
        EngineConfig engineConfig = this.getEngineConfig();
        if (engineConfig == null) {
            engineConfig = new EngineConfig();
        }
        IReportEngineFactory factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        this.engine = factory.createReportEngine(engineConfig);
        this.engine.changeLogLevel(Level.WARNING);
    }

    public void close() {
        this.engine.destroy();
    }

    protected abstract IRenderOption getRenderOption();

    protected abstract EngineConfig getEngineConfig();

    protected String createReportDocument(String reportDesignFile, String outputFolder, Map parameters) throws IOException, EngineException {
        File designFile = new File(reportDesignFile);
        String reportDocumentFile = String.valueOf(outputFolder) + File.separator + designFile.getName() + "." + RPTDOC_SUFFIX;
        FileArchiveWriter archive = new FileArchiveWriter(reportDocumentFile);
        IReportRunnable report = this.engine.openReportDesign(reportDesignFile);
        IRunTask runTask = this.engine.createRunTask(report);
        try {
            if (parameters != null) {
                runTask.setParameterValues(parameters);
            }
            Map appContext = new HashMap();
            if (ExtendedDataModelUIAdapterHelper.getInstance().getAdapter() != null) {
                appContext = ExtendedDataModelUIAdapterHelper.getInstance().getAdapter().getAppContext();
            }
            runTask.setAppContext(appContext);
            runTask.run((IDocArchiveWriter)archive);
        }
        finally {
            runTask.close();
            report = null;
            runTask = null;
        }
        return reportDocumentFile;
    }

    protected IReportDocument openReportDocument(String reportDocumentFile) throws EngineException {
        return this.engine.openReportDocument(reportDocumentFile);
    }

    protected long createReportOutput(String reportDocumentFile, String outputFile, long pageNumber) throws EngineException, IOException {
        IReportDocument document = this.engine.openReportDocument(reportDocumentFile);
        long pageCount = document.getPageCount();
        IRenderTask task = this.engine.createRenderTask(document);
        IRenderOption renderOption = this.getRenderOption();
        renderOption.setOutputFileName(outputFile);
        try {
            task.setRenderOption(renderOption);
            task.setPageNumber(pageNumber);
            Map appContext = Collections.EMPTY_MAP;
            if (ExtendedDataModelUIAdapterHelper.getInstance().getAdapter() != null) {
                appContext = ExtendedDataModelUIAdapterHelper.getInstance().getAdapter().getAppContext();
            }
            task.setAppContext(appContext);
            task.render();
        }
        finally {
            task.close();
            task = null;
            document.close();
            document = null;
        }
        return pageCount;
    }

    protected List getInputParameters(String reportDesignFile) {
        try {
            IGetParameterDefinitionTask task = this.engine.createGetParameterDefinitionTask(this.engine.openReportDesign(reportDesignFile));
            ParameterFactory factory = new ParameterFactory(task);
            List parameters = factory.getRootChildren();
            task.close();
            task = null;
            return parameters;
        }
        catch (EngineException engineException) {
            return null;
        }
    }
}

