/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormPage;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.dialogs.provider.DataSetColumnBindingsFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataSetColumnBindingsFormPage
extends FormPage {
    private Button btnAddAggr;
    private Button btnRefresh;

    public DataSetColumnBindingsFormPage(Composite parent, DataSetColumnBindingsFormHandleProvider provider) {
        super(parent, 3, provider, true);
        provider.setTableViewer(this.getTableViewer());
    }

    @Override
    protected void createControl() {
        super.createControl();
        if (((DataSetColumnBindingsFormHandleProvider)this.provider).canAggregation()) {
            this.btnAddAggr = new Button((Composite)this, 8);
            this.btnAddAggr.setText(Messages.getString((String)"FormPage.Button.Add.AggregateOn"));
            this.btnAddAggr.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DataSetColumnBindingsFormPage.this.handleAddAggregateOnSelectEvent();
                }
            });
        }
        this.btnRefresh = new Button((Composite)this, 8);
        this.btnRefresh.setText(Messages.getString((String)"FormPage.Button.Binding.Refresh"));
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetColumnBindingsFormPage.this.handleRefreshSelectEvent();
            }
        });
        this.fullLayout();
    }

    protected void handleAddAggregateOnSelectEvent() {
        int pos = this.table.getSelectionIndex();
        try {
            ((DataSetColumnBindingsFormHandleProvider)this.provider).addAggregateOn(pos);
        }
        catch (Exception e) {
            WidgetUtil.processError(this.btnAddAggr.getShell(), e);
            return;
        }
        this.refresh();
        this.table.setSelection(this.table.getItemCount() - 1);
    }

    protected void handleRefreshSelectEvent() {
        ((DataSetColumnBindingsFormHandleProvider)this.provider).generateAllBindingColumns();
        this.refresh();
    }

    @Override
    protected void fullLayout() {
        FormData data;
        super.fullLayout();
        if (this.btnAddAggr != null) {
            data = new FormData();
            data.top = new FormAttachment((Control)this.btnAdd, 0, 1024);
            data.left = new FormAttachment((Control)this.btnAdd, 0, 16384);
            data.width = Math.max(60, this.btnAddAggr.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.btnAddAggr.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.btnAddAggr, 0, 1024);
            data.left = new FormAttachment((Control)this.btnAddAggr, 0, 16384);
            data.width = Math.max(60, this.btnEdit.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.btnEdit.setLayoutData((Object)data);
        }
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnEdit, 0, 1024);
        data.left = new FormAttachment((Control)this.btnEdit, 0, 16384);
        data.width = Math.max(60, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        if (this.btnRefresh != null) {
            data = new FormData();
            data.top = new FormAttachment((Control)this.btnDel, 0, 1024);
            data.left = new FormAttachment((Control)this.btnDel, 0, 16384);
            data.width = Math.max(60, this.btnRefresh.computeSize((int)-1, (int)-1, (boolean)true).x);
            this.btnRefresh.setLayoutData((Object)data);
        }
    }

    @Override
    public void setInput(List elements) {
        super.setInput(elements);
        if (elements.size() > 0) {
            Object element = elements.get(0);
            this.setBindingObject((ReportElementHandle)element);
            this.checkButtonsEnabled();
        }
    }

    private void checkButtonsEnabled() {
        if (((DataSetColumnBindingsFormHandleProvider)this.provider).canAggregation() && !this.btnAddAggr.isDisposed()) {
            this.btnAddAggr.setEnabled(this.provider.isEditable());
        }
        if (!this.btnRefresh.isDisposed()) {
            this.btnRefresh.setEnabled(this.provider.isEditable());
        }
    }

    private void setBindingObject(ReportElementHandle bindingObject) {
        ((DataSetColumnBindingsFormHandleProvider)this.provider).setBindingObject(bindingObject);
    }

    @Override
    public void elementChanged(DesignElementHandle elementHandle, NotificationEvent event) {
        this.checkButtonsEnabled();
    }

    public void generateAllBindingColumns() {
        ((DataSetColumnBindingsFormHandleProvider)this.provider).generateAllBindingColumns();
    }

    public void generateBindingColumns(Object[] columns) {
        ((DataSetColumnBindingsFormHandleProvider)this.provider).generateBindingColumns(columns);
    }
}

