/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Display;

public class CellFigure
extends ReportElementFigure {
    private String blankString;
    private boolean rtl;

    @Override
    protected void paintBorder(Graphics graphics) {
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.blankString != null && this.blankString.length() > 0) {
            graphics.setForegroundColor(ReportColorConstants.ShadowLineColor);
            this.drawBlankString(graphics, this.blankString);
            graphics.restoreState();
        }
    }

    protected void drawBlankString(Graphics g, String s) {
        TextLayout tl = new TextLayout((Device)Display.getCurrent());
        tl.setOrientation(this.rtl ? 0x4000000 : 0x2000000);
        tl.setText(s);
        Rectangle rc = tl.getBounds();
        int left = (this.getClientArea().width - rc.width) / 2;
        int top = (this.getClientArea().height - rc.height) / 2;
        g.drawText(s, this.getClientArea().x + left, this.getClientArea().y + top);
        tl.dispose();
    }

    public void setBlankString(String blankString) {
        this.blankString = blankString;
    }

    public String getBlankString() {
        return this.blankString;
    }

    public void setDirectionRTL(boolean rtl) {
        this.rtl = rtl;
    }
}

