/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.dialogs.ColumnBindingDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ImageBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.TextEditor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;

public class ElementBuilderFactory {
    private static ElementBuilderFactory instance;

    private ElementBuilderFactory() {
    }

    public static ElementBuilderFactory getInstance() {
        if (instance == null) {
            instance = new ElementBuilderFactory();
        }
        return instance;
    }

    public Object createBuilder(DesignElementHandle handle) {
        if (handle instanceof TextItemHandle) {
            return new TextEditor(UIUtil.getDefaultShell(), TextEditor.DLG_TITLE_NEW, (TextItemHandle)handle);
        }
        if (handle instanceof TextDataHandle) {
            ExpressionBuilder dialog = new ExpressionBuilder(UIUtil.getDefaultShell(), ((TextDataHandle)handle).getValueExpr());
            dialog.setExpressionProvier(new ExpressionProvider(handle));
            return dialog;
        }
        if (handle instanceof DataItemHandle) {
            ColumnBindingDialog dialog = new ColumnBindingDialog((ReportItemHandle)handle, UIUtil.getDefaultShell(), true);
            dialog.setGroupList(DEUtil.getGroups((DesignElementHandle)handle));
            return dialog;
        }
        if (handle instanceof ImageHandle) {
            ImageBuilder dialog = new ImageBuilder(UIUtil.getDefaultShell(), ImageBuilder.DLG_TITLE_NEW);
            dialog.setInput(handle);
            return dialog;
        }
        return null;
    }
}

