/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.odp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.odp.OdpContext;
import org.eclipse.birt.report.engine.emitter.odp.OdpRender;
import org.eclipse.birt.report.engine.layout.emitter.PageDeviceRender;
import org.eclipse.birt.report.engine.layout.emitter.PageEmitter;
import org.eclipse.birt.report.engine.odf.OdfConstants;
import org.eclipse.birt.report.engine.odf.pkg.Package;
import org.eclipse.birt.report.engine.odf.writer.ContentWriter;
import org.eclipse.birt.report.engine.odf.writer.StylesWriter;

public class OdpEmitter
extends PageEmitter
implements OdfConstants {
    public static final String MIME_TYPE = "application/vnd.oasis.opendocument.presentation";
    private ByteArrayOutputStream bodyOut;
    private ByteArrayOutputStream masterPageOut;
    private OutputStream out;
    private Package pkg;
    private OdpContext context;

    public void initialize(IEmitterServices service) throws EngineException {
        this.context = new OdpContext();
        this.bodyOut = new ByteArrayOutputStream();
        this.masterPageOut = new ByteArrayOutputStream();
        String tempFileDir = service.getReportEngine().getConfig().getTempDir();
        this.context.setTempFileDir(service.getReportEngine().getConfig().getTempDir());
        this.out = EmitterUtil.getOuputStream((IEmitterServices)service, (String)"report.odp");
        this.pkg = Package.createInstance((OutputStream)this.out, (String)tempFileDir, (String)MIME_TYPE);
        this.context.setPackage(this.pkg);
        super.initialize(service);
    }

    public PageDeviceRender createRender(IEmitterServices service) throws EngineException {
        return new OdpRender(service, this.context, this.bodyOut, this.masterPageOut);
    }

    public void end(IReportContent report) {
        super.end(report);
        this.save();
    }

    private void save() {
        try {
            ContentWriter docContentWriter = new ContentWriter(this.pkg.addEntry("content.xml", "text/xml").getOutputStream(), this.context.getReportDpi());
            docContentWriter.write(this.context.getStyleManager().getStyles(), (InputStream)new ByteArrayInputStream(this.bodyOut.toByteArray()));
            OdpStylesWriter stylesWriter = new OdpStylesWriter(this.pkg.addEntry("styles.xml", "text/xml").getOutputStream(), this.context.getReportDpi());
            stylesWriter.start();
            stylesWriter.writeStyles(this.context.getGlobalStyleManager().getStyles());
            stylesWriter.writeMasterPage(new ByteArrayInputStream(this.masterPageOut.toByteArray()));
            stylesWriter.end();
            this.pkg.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private class OdpStylesWriter
    extends StylesWriter {
        public OdpStylesWriter(OutputStream out, int reportDpi) {
            super(out, reportDpi);
        }

        public void writeDefaultStyles() {
            this.writer.openTag("style:style");
            this.writer.attribute("style:name", "Standard");
            this.writer.attribute("style:family", "paragraph");
            this.writer.attribute("style:class", "text");
            this.writer.closeTag("style:style");
            this.writer.openTag("style:style");
            this.writer.attribute("style:name", "Graphics");
            this.writer.attribute("style:family", "graphic");
            this.writer.openTag("style:graphic-properties");
            this.writer.attribute("text:anchor-type", "paragraph");
            this.writer.attribute("svg:x", "0in");
            this.writer.attribute("svg:y", "0in");
            this.writer.attribute("style:wrap", "dynamic");
            this.writer.attribute("style:number-wrapped-paragraphs", "no-limit");
            this.writer.attribute("style:wrap-contour", "false");
            this.writer.attribute("style:vertical-pos", "top");
            this.writer.attribute("style:vertical-rel", "paragraph");
            this.writer.attribute("style:horizontal-pos", "center");
            this.writer.attribute("style:horizontal-rel", "paragraph");
            this.writer.attribute("draw:auto-grow-height", "false");
            this.writer.attribute("draw:auto-grow-width", "true");
            this.writer.closeTag("style:graphic-properties");
            this.writer.closeTag("style:style");
            this.writer.openTag("style:style");
            this.writer.attribute("style:name", "Hidden");
            this.writer.attribute("style:family", "paragraph");
            this.writer.openTag("style:paragraph-properties");
            this.writer.attribute("text:display", "none");
            this.writer.closeTag("style:paragraph-properties");
            this.writer.closeTag("style:style");
        }
    }
}

