/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx;

import java.awt.Color;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.ppt.util.PPTUtil;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Presentation;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.layout.emitter.util.BackgroundImageLayout;
import org.eclipse.birt.report.engine.layout.emitter.util.Position;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BackgroundImageInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.ImageManager;
import org.eclipse.birt.report.engine.ooxml.util.OOXmlUtil;
import org.eclipse.birt.report.engine.ooxml.writer.OOXmlWriter;

public class PPTXCanvas {
    private static Logger logger = Logger.getLogger(PPTXCanvas.class.getName());
    private final Presentation presentation;
    private final IPart part;
    private final ImageManager imageManager;
    private final OOXmlWriter writer;
    private float scale = 1.0f;
    private Stack<ClipArea> clipStack = new Stack();

    public PPTXCanvas(Presentation presentation, IPart part, OOXmlWriter writer) {
        this.presentation = presentation;
        this.part = part;
        this.imageManager = (ImageManager)part.getPackage().getExtensionData();
        this.writer = writer;
    }

    public PPTXCanvas(PPTXCanvas canvas, OOXmlWriter writer) {
        this.presentation = canvas.presentation;
        this.part = canvas.part;
        this.imageManager = canvas.imageManager;
        this.writer = writer;
        this.clipStack = canvas.clipStack;
    }

    public void drawLine(int startX, int startY, int endX, int endY, int width, Color color, int lineStyle) {
        if (color == null || (float)width == 0.0f || lineStyle == 28) {
            return;
        }
        this.writer.openTag("p:cxnSp");
        this.writer.openTag("p:nvCxnSpPr");
        this.writer.openTag("p:cNvPr");
        int shapeId = this.nextShapeId();
        this.writer.attribute("id", shapeId);
        this.writer.attribute("name", "Line " + shapeId);
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvCxnSpPr");
        this.writer.closeTag("p:cNvCxnSpPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvCxnSpPr");
        this.writer.openTag("p:spPr");
        this.setPosition(startX, startY, endX - startX, endY - startY);
        this.writer.openTag("a:prstGeom");
        this.writer.attribute("prst", "line");
        this.writer.closeTag("a:prstGeom");
        this.setProperty(color, width, lineStyle);
        this.writer.closeTag("p:spPr");
        this.writer.closeTag("p:cxnSp");
    }

    public void drawText(String text, int textX, int textY, int width, int height, String fontName, float fontSize, int fontStyle, Color color, boolean isUnderline, boolean isLineThrough, PPTUtil.HyperlinkDef link) {
        this.writer.openTag("p:sp");
        this.writer.openTag("p:nvSpPr");
        this.writer.openTag("p:cNvPr");
        int shapeId = this.nextShapeId();
        this.writer.attribute("id", shapeId);
        this.writer.attribute("name", "TextBox " + shapeId);
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvSpPr");
        this.writer.attribute("txBox", "1");
        this.writer.closeTag("p:cNvSpPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvSpPr");
        this.writer.openTag("p:spPr");
        this.setPosition(textX, textY, width + 1, height);
        this.writer.openTag("a:prstGeom");
        this.writer.attribute("prst", "rect");
        this.writer.closeTag("a:prstGeom");
        this.writer.closeTag("p:spPr");
        this.writer.openTag("p:txBody");
        this.writer.openTag("a:bodyPr");
        this.writer.attribute("wrap", "none");
        this.writer.attribute("lIns", "0");
        this.writer.attribute("tIns", "0");
        this.writer.attribute("rIns", "0");
        this.writer.attribute("bIns", "0");
        this.writer.attribute("rtlCol", "0");
        this.writer.closeTag("a:bodyPr");
        this.writer.openTag("a:p");
        this.writer.openTag("a:r");
        this.setTextProperty(fontName, fontSize, fontStyle, color, isUnderline, isLineThrough, link);
        this.writer.openTag("a:t");
        this.writeText(text);
        this.writer.closeTag("a:t");
        this.writer.closeTag("a:r");
        this.writer.closeTag("a:p");
        this.writer.closeTag("p:txBody");
        this.writer.closeTag("p:sp");
    }

    void writeText(String text) {
        int length = text.length();
        StringBuilder sb = new StringBuilder(length * 2);
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        this.writer.cdata(sb.toString());
    }

    public void drawImage(String uri, String extension, int imageX, int imageY, int height, int width, String helpText, PPTUtil.HyperlinkDef link) throws IOException {
        byte[] imageData = EmitterUtil.getImageData((String)uri);
        IPart imagePart = this.imageManager.getImagePart(this.part, uri, imageData).getPart();
        this.drawImage(imagePart, imageX, imageY, height, width, helpText, true, link);
    }

    public void drawImage(String imageId, byte[] imageData, String extension, int imageX, int imageY, int height, int width, String helpText, PPTUtil.HyperlinkDef link) throws IOException {
        this.drawImage(imageId, imageData, extension, imageX, imageY, height, width, helpText, true, link);
    }

    private void drawImage(String imageId, byte[] imageData, String extension, int imageX, int imageY, int height, int width, String helpText, boolean stretch, PPTUtil.HyperlinkDef link) throws IOException {
        IPart imagePart = this.imageManager.getImagePart(this.part, imageId, imageData).getPart();
        this.drawImage(imagePart, imageX, imageY, height, width, helpText, stretch, link);
    }

    private Crop checkCrop(int x, int y, int width, int height) {
        if (this.clipStack.isEmpty()) {
            return null;
        }
        ClipArea clip = this.clipStack.peek();
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (x < clip.x) {
            left = (int)((float)(clip.x - x) / (float)width * 100000.0f);
        }
        if (y < clip.y) {
            top = (int)((float)(clip.y - y) / (float)height * 100000.0f);
        }
        if (x + width > clip.x + clip.width) {
            right = (int)((float)(x + width - (clip.x + clip.width)) / (float)width * 100000.0f);
        }
        if (y + height > clip.y + clip.height) {
            bottom = (int)((float)(y + height - (clip.y + clip.height)) / (float)height * 100000.0f);
        }
        if (left != 0 || right != 0 || top != 0 || bottom != 0) {
            return new Crop(left, right, top, bottom);
        }
        return null;
    }

    private void drawImage(IPart imagePart, int imageX, int imageY, int height, int width, String helpText, boolean stretch, PPTUtil.HyperlinkDef link) {
        String relationshipId = imagePart.getRelationshipId();
        this.writer.openTag("p:pic");
        this.writer.openTag("p:nvPicPr");
        this.writer.openTag("p:cNvPr");
        int shapeId = this.nextShapeId();
        this.writer.attribute("id", shapeId);
        this.writer.attribute("name", "Image " + shapeId);
        this.writer.attribute("descr", helpText);
        this.setHyperlink(link);
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvPicPr");
        this.writer.openTag("a:picLocks");
        this.writer.attribute("noChangeAspect", "1");
        this.writer.closeTag("a:picLocks");
        this.writer.closeTag("p:cNvPicPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvPicPr");
        this.writer.openTag("p:blipFill");
        Crop crop = this.checkCrop(imageX, imageY, width, height);
        if (crop != null) {
            this.writer.attribute("rotWithShape", "1");
        }
        this.writer.openTag("a:blip");
        this.writer.attribute("r:embed", relationshipId);
        this.writer.closeTag("a:blip");
        if (crop != null) {
            this.writer.openTag("a:srcRect");
            if (crop.top != 0) {
                this.writer.attribute("t", crop.top);
            }
            if (crop.left != 0) {
                this.writer.attribute("l", crop.left);
            }
            if (crop.right != 0) {
                this.writer.attribute("r", crop.right);
            }
            if (crop.bottom != 0) {
                this.writer.attribute("b", crop.bottom);
            }
            this.writer.closeTag("a:srcRect");
        }
        if (stretch) {
            this.writer.openTag("a:stretch");
            this.writer.closeTag("a:stretch");
        }
        this.writer.closeTag("p:blipFill");
        this.writer.openTag("p:spPr");
        if (crop == null) {
            this.setPosition(imageX, imageY, width, height);
        } else {
            ClipArea clip = this.clipStack.peek();
            int pX = Math.max(clip.x, imageX);
            int pY = Math.max(clip.y, imageY);
            int pWidth = Math.min(imageX + width, clip.x + clip.width) - pX;
            int pHeight = Math.min(imageY + height, clip.y + clip.height) - pY;
            pHeight = pHeight < 0 ? 0 : pHeight;
            pWidth = pWidth < 0 ? 0 : pWidth;
            this.setPosition(pX, pY, pWidth, pHeight);
        }
        this.writer.openTag("a:prstGeom");
        this.writer.attribute("prst", "rect");
        this.writer.closeTag("a:prstGeom");
        this.writer.closeTag("p:spPr");
        this.writer.closeTag("p:pic");
    }

    public void drawBackgroundColor(Color color, int x, int y, int width, int height) {
        if (color != null) {
            this.writer.openTag("p:sp");
            this.writer.openTag("p:nvSpPr");
            this.writer.openTag("p:cNvPr");
            int shapeId = this.nextShapeId();
            this.writer.attribute("id", shapeId);
            this.writer.attribute("name", "Rectangle " + shapeId);
            this.writer.closeTag("p:cNvPr");
            this.writer.openTag("p:cNvSpPr");
            this.writer.closeTag("p:cNvSpPr");
            this.writer.openTag("p:nvPr");
            this.writer.closeTag("p:nvPr");
            this.writer.closeTag("p:nvSpPr");
            this.writer.openTag("p:spPr");
            this.setPosition(x, y, width, height);
            this.writer.openTag("a:prstGeom");
            this.writer.attribute("prst", "rect");
            this.writer.closeTag("a:prstGeom");
            this.setBackgroundColor(color);
            this.writer.closeTag("p:spPr");
            this.writer.closeTag("p:sp");
        }
    }

    public void drawBackgroundImage(int x, int y, int width, int height, int imageWidth, int imageHeight, int repeat, String imageURI, byte[] imageData, int offsetX, int offsetY) {
        if (imageURI == null || imageURI.length() == 0) {
            return;
        }
        if (imageData == null || imageData.length == 0) {
            return;
        }
        try {
            if (!this.imageManager.hasImage(imageURI)) {
                Image image = EmitterUtil.parseImage((byte[])imageData, null, null);
                imageData = image.getData();
            }
            ImageManager.ImagePart imagePartInfo = this.imageManager.getImagePart(this.part, imageURI, imageData);
            Image imageInfo = imagePartInfo.getImageInfo();
            float originalImageWidth = imageWidth != 0 ? imageWidth : imageInfo.getWidth();
            float originalImageHeight = imageHeight != 0 ? imageHeight : imageInfo.getHeight();
            originalImageHeight = Math.min(originalImageHeight, (float)height);
            originalImageWidth = Math.min(originalImageWidth, (float)width);
            Position areaPosition = new Position((float)x, (float)y);
            Position areaSize = new Position((float)width, (float)height);
            Position imagePosition = new Position((float)(x + offsetX), (float)(y + offsetY));
            Position imageSize = new Position(originalImageWidth, originalImageHeight);
            BackgroundImageLayout layout = new BackgroundImageLayout(areaPosition, areaSize, imagePosition, imageSize);
            List positions = layout.getImagePositions(repeat);
            for (Position position : positions) {
                this.fillRectangleWithImage(imagePartInfo, (int)OOXmlUtil.convertPointerToEmus((double)position.getX()), (int)OOXmlUtil.convertPointerToEmus((double)position.getY()), (int)OOXmlUtil.convertPointerToEmus((double)originalImageWidth), (int)OOXmlUtil.convertPointerToEmus((double)originalImageHeight), 0, 0);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private float getImageRange(float maxRange, float offset, float imageSize) {
        float result = imageSize;
        if (offset < 0.0f) {
            result = Math.max(0.0f, imageSize + offset);
        } else if (offset + imageSize > maxRange) {
            result = Math.max(0.0f, maxRange - offset);
        }
        return result;
    }

    private boolean isOutOfRange(float maxRange, float offset, float imageSize) {
        return offset <= 0.0f - imageSize || offset >= maxRange;
    }

    private void fillRectangleWithImage(ImageManager.ImagePart imageInfo, int x, int y, int width, int height, int offsetX, int offsetY) {
        this.writer.openTag("p:sp");
        this.writer.openTag("p:nvSpPr");
        this.writer.openTag("p:cNvPr");
        int shapeId = this.nextShapeId();
        this.writer.attribute("id", shapeId);
        this.writer.attribute("name", "Rectangle " + shapeId);
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvSpPr");
        this.writer.closeTag("p:cNvSpPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvSpPr");
        this.writer.openTag("p:spPr");
        this.setPosition(x, y, width, height);
        this.writer.openTag("a:prstGeom");
        this.writer.attribute("prst", "rect");
        this.writer.closeTag("a:prstGeom");
        this.setBackgroundImg(imageInfo.getPart().getRelationshipId(), offsetX, offsetY, 0);
        this.writer.openTag("a:ln");
        this.writer.openTag("a:noFill");
        this.writer.closeTag("a:noFill");
        this.writer.closeTag("a:ln");
        this.writer.closeTag("p:spPr");
        this.writer.closeTag("p:sp");
    }

    public void setBackgroundImg(String relationshipid, int offsetX, int offsetY) {
        this.setBackgroundImg(relationshipid, offsetX, offsetY, 3);
    }

    public void setBackgroundImg(String relationshipid, int offsetX, int offsetY, int repeatmode) {
        if (repeatmode < 0 || repeatmode > 3 || repeatmode == 1 || repeatmode == 2) {
            return;
        }
        this.writer.openTag("a:blipFill");
        this.writer.attribute("dpi", "0");
        this.writer.attribute("rotWithShape", "1");
        this.writer.openTag("a:blip");
        this.writer.attribute("r:embed", relationshipid);
        this.writer.closeTag("a:blip");
        switch (repeatmode) {
            case 3: {
                this.writer.openTag("a:tile");
                this.writer.attribute("tx", offsetX);
                this.writer.attribute("ty", offsetY);
                this.writer.closeTag("a:tile");
                break;
            }
            case 0: {
                this.writer.openTag("a:stretch");
                this.writer.openTag("a:fillRect");
                this.writer.attribute("b", offsetY);
                this.writer.attribute("r", offsetX);
                this.writer.closeTag("a:fillRect");
                this.writer.closeTag("a:stretch");
            }
        }
        this.writer.closeTag("a:blipFill");
    }

    private void setTextProperty(String fontName, float fontSize, int fontStyle, Color color, boolean isUnderline, boolean isLineThrough, PPTUtil.HyperlinkDef link) {
        boolean isBold;
        this.writer.openTag("a:rPr");
        this.writer.attribute("lang", "en-US");
        this.writer.attribute("altLang", "zh-CN");
        this.writer.attribute("dirty", "0");
        this.writer.attribute("smtClean", "0");
        if (isLineThrough) {
            this.writer.attribute("strike", "sngStrike");
        }
        if (isUnderline) {
            this.writer.attribute("u", "sng");
        }
        this.writer.attribute("sz", (int)(fontSize * 100.0f));
        boolean isItalic = (fontStyle & 2) != 0;
        boolean bl = isBold = (fontStyle & 1) != 0;
        if (isItalic) {
            this.writer.attribute("i", 1);
        }
        if (isBold) {
            this.writer.attribute("b", 1);
        }
        this.setBackgroundColor(color);
        this.setTextFont(fontName);
        this.setHyperlink(link);
        this.writer.closeTag("a:rPr");
    }

    void setHyperlink(PPTUtil.HyperlinkDef link) {
        if (link != null) {
            String hyperlink = null;
            try {
                hyperlink = URLEncoder.encode(link.getLink(), "UTF-8");
            }
            catch (UnsupportedEncodingException ue) {
                logger.log(Level.SEVERE, ue.getLocalizedMessage(), ue);
            }
            if (hyperlink != null) {
                if (hyperlink.startsWith("\"") && hyperlink.endsWith("\"")) {
                    hyperlink = hyperlink.substring(1, hyperlink.length() - 1);
                }
                this.writer.openTag("a:hlinkClick");
                this.writer.attribute("r:id", this.part.getHyperlinkId(hyperlink));
                if (link.getTooltip() != null) {
                    this.writer.attribute("tooltip", link.getTooltip());
                }
                this.writer.closeTag("a:hlinkClick");
            }
        }
    }

    public void setBookmark(String bmk_relationshipid) {
        if (bmk_relationshipid != null) {
            this.writer.openTag("a:hlinkClick");
            this.writer.attribute("r:id", bmk_relationshipid);
            this.writer.attribute("action", "ppaction://hlinksldjump");
            this.writer.closeTag("a:hlinkClick");
        }
    }

    private void setTextFont(String fontName) {
        this.writer.openTag("a:latin");
        this.writer.attribute("typeface", fontName);
        this.writer.attribute("pitchFamily", "18");
        this.writer.attribute("charset", "0");
        this.writer.closeTag("a:latin");
        this.writer.openTag("a:cs");
        this.writer.attribute("typeface", fontName);
        this.writer.attribute("pitchFamily", "18");
        this.writer.attribute("charset", "0");
        this.writer.closeTag("a:cs");
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.writer.openTag("a:solidFill");
            this.writer.openTag("a:srgbClr");
            this.writer.attribute("val", EmitterUtil.getColorString((Color)color));
            this.writer.closeTag("a:srgbClr");
            this.writer.closeTag("a:solidFill");
        }
    }

    public void setPosition(int startX, int startY, int width, int height) {
        this.setPosition('a', startX, startY, width, height);
    }

    public void setPosition(char tagtype, int startX, int startY, int width, int height) {
        this.writer.openTag(String.valueOf(tagtype) + ":xfrm");
        this.writer.openTag("a:off");
        this.writer.attribute("x", startX);
        this.writer.attribute("y", startY);
        this.writer.closeTag("a:off");
        this.writer.openTag("a:ext");
        this.writer.attribute("cx", width);
        this.writer.attribute("cy", height);
        this.writer.closeTag("a:ext");
        this.writer.closeTag(String.valueOf(tagtype) + ":xfrm");
    }

    public void setProperty(Color color, int width, int style) {
        this.writer.openTag("a:ln");
        this.writer.attribute("w", width);
        if (style == 23) {
            this.writer.attribute("cmpd", "dbl");
        }
        this.setBackgroundColor(color);
        switch (style) {
            case 23: {
                this.setStyle("solid");
                break;
            }
            case 22: {
                this.setStyle("dash");
                break;
            }
            case 20: {
                this.setStyle("sysDash");
                break;
            }
            default: {
                this.setStyle("solid");
            }
        }
        this.writer.closeTag("a:ln");
    }

    private void setStyle(String lineStyle) {
        this.writer.openTag("a:prstDash");
        this.writer.attribute("val", lineStyle);
        this.writer.closeTag("a:prstDash");
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    private String getSlideUri(int slideIndex) {
        return "slides/slide" + slideIndex + ".xml";
    }

    private int nextShapeId() {
        return this.presentation.getNextShapeId();
    }

    public void drawText(String text, int textX, int textY, int width, int height, TextStyle textStyle, PPTUtil.HyperlinkDef link) {
        FontInfo fontInfo = textStyle.getFontInfo();
        String fontName = fontInfo.getFontName();
        float fontSize = fontInfo.getFontSize();
        int fontStyle = fontInfo.getFontStyle();
        Color color = textStyle.getColor();
        this.drawText(text, textX, textY, width, height, fontName, fontSize, fontStyle, color, textStyle.isUnderline(), textStyle.isLinethrough(), link);
    }

    public void startClip(int startX, int startY, int width, int height) {
        if (this.clipStack.isEmpty()) {
            this.clipStack.push(new ClipArea(startX, startY, width, height));
        } else {
            ClipArea parent = this.clipStack.peek();
            int newX = Math.max(parent.x, startX);
            int newY = Math.max(parent.y, startY);
            int newWidth = Math.min(startX + width, parent.x + parent.width) - newX;
            int newHeight = Math.min(startY + height, parent.y + parent.height) - newY;
            this.clipStack.push(new ClipArea(newX, newY, newWidth, newHeight));
        }
    }

    public void endClip() {
        this.clipStack.pop();
    }

    public OOXmlWriter getWriter() {
        return this.writer;
    }

    protected void writeMarginProperties(int top, int right, int bottom, int left) {
        this.writer.attribute("marL", left);
        this.writer.attribute("marR", right);
        this.writer.attribute("marT", top);
        this.writer.attribute("marB", bottom);
    }

    public String getImageRelationship(BackgroundImageInfo bgimginfo) {
        String imageURI = bgimginfo.getUrl();
        byte[] imageData = bgimginfo.getImageData();
        String relationshipid = null;
        try {
            if (!this.imageManager.hasImage(imageURI)) {
                Image image = EmitterUtil.parseImage((byte[])imageData, null, null);
                imageData = image.getData();
            }
            ImageManager.ImagePart imagePartInfo = this.imageManager.getImagePart(this.part, imageURI, imageData);
            relationshipid = imagePartInfo.getPart().getRelationshipId();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        return relationshipid;
    }

    protected int getScaledValue(float value) {
        return (int)(value * this.scale);
    }

    public void setScale(float newscale) {
        this.scale = newscale;
    }

    private class ClipArea {
        int x;
        int y;
        int width;
        int height;

        ClipArea(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    private class Crop {
        int left;
        int right;
        int top;
        int bottom;

        Crop(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }
    }
}

