/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.ir.RowDesign;

public class RowContent
extends AbstractContent
implements IRowContent {
    protected int rowID = -1;
    protected String groupId;
    protected Boolean repeatable = null;
    private ITableContent table;
    protected static final short FIELD_ROWID = 800;
    protected static final short FIELD_ROWTYPE = 801;
    protected static final short FIELD_ROW_GROUPLEVEL = 802;
    protected static final short FIELD_ROW_GROUPID = 803;
    protected static final short FIELD_ROW_REPEABLE = 804;

    RowContent(IRowContent row) {
        super(row);
        this.rowID = row.getRowID();
        this.groupId = row.getGroupId();
    }

    @Override
    public int getContentType() {
        return 8;
    }

    RowContent(IReportContent report) {
        super(report);
    }

    @Override
    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitRow(this, value);
    }

    @Override
    public int getRowID() {
        return this.rowID;
    }

    @Override
    public void setRowID(int rowID) {
        this.rowID = rowID;
    }

    @Override
    public ITableContent getTable() {
        if (this.table != null) {
            return this.table;
        }
        IContent parent = (IContent)this.getParent();
        while (parent != null) {
            if (parent.getContentType() == 10) {
                this.table = (ITableContent)parent;
                return this.table;
            }
            parent = (IContent)parent.getParent();
        }
        return null;
    }

    @Override
    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.rowID != -1) {
            IOUtil.writeShort((OutputStream)out, (short)800);
            IOUtil.writeInt((OutputStream)out, (int)this.rowID);
        }
        if (this.groupId != null) {
            IOUtil.writeShort((OutputStream)out, (short)803);
            IOUtil.writeString((DataOutputStream)out, (String)this.groupId);
        }
        if (this.repeatable != null) {
            IOUtil.writeShort((OutputStream)out, (short)804);
            IOUtil.writeBool((OutputStream)out, (boolean)this.repeatable);
        }
    }

    @Override
    public boolean needSave() {
        return true;
    }

    @Override
    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 800: {
                this.rowID = IOUtil.readInt((InputStream)in);
                break;
            }
            case 801: {
                IOUtil.readInt((InputStream)in);
                break;
            }
            case 802: {
                IOUtil.readInt((InputStream)in);
                break;
            }
            case 803: {
                this.groupId = IOUtil.readString((DataInputStream)in);
                break;
            }
            case 804: {
                this.repeatable = IOUtil.readBool((InputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public IGroupContent getGroup() {
        IContent parent;
        IBandContent bandContent = this.getBand();
        if (bandContent != null && (parent = (IContent)bandContent.getParent()) instanceof IGroupContent) {
            return (IGroupContent)parent;
        }
        return null;
    }

    @Override
    public IBandContent getBand() {
        if (this.parent instanceof IBandContent) {
            return (IBandContent)this.parent;
        }
        return null;
    }

    @Override
    protected IContent cloneContent() {
        return new RowContent(this);
    }

    @Override
    public void setRepeatable(boolean repeatable) {
        this.repeatable = new Boolean(repeatable);
    }

    @Override
    public boolean isRepeatable() {
        if (this.repeatable != null) {
            return this.repeatable;
        }
        if (this.generateBy != null && this.generateBy instanceof RowDesign) {
            return ((RowDesign)this.generateBy).getRepeatable();
        }
        return true;
    }
}

