/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.interfaces.IImageItemModel;

public class ImageItem
extends ReportItem
implements IImageItemModel {
    public ImageItem() {
    }

    public ImageItem(String theName) {
        super(theName);
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitImage(this);
    }

    @Override
    public String getElementName() {
        return "Image";
    }

    @Override
    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public ImageHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new ImageHandle(module, this);
        }
        return (ImageHandle)this.handle;
    }

    public double getImageScale(ReportDesign design) {
        return this.getFloatProperty(design, "scale");
    }

    public String getAltText(ReportDesign design) {
        Expression expr = (Expression)this.getProperty((Module)design, "altText");
        if (expr != null) {
            return expr.getStringExpression();
        }
        return null;
    }

    @Override
    public String getDisplayLabel(Module module, int level) {
        String displayLabel = super.getDisplayLabel(module, level);
        if (level == 2) {
            displayLabel = String.valueOf(displayLabel) + "(";
            String sourceType = this.getStringProperty(module, "source");
            if ("file".equalsIgnoreCase(sourceType) || "url".equalsIgnoreCase(sourceType)) {
                displayLabel = String.valueOf(displayLabel) + this.limitStringLength(this.getStringProperty(module, "uri"));
            } else if ("embed".equalsIgnoreCase(sourceType)) {
                displayLabel = String.valueOf(displayLabel) + this.limitStringLength(this.getStringProperty(module, "imageName"));
            } else if ("expr".equalsIgnoreCase(sourceType)) {
                displayLabel = String.valueOf(displayLabel) + this.limitStringLength(this.getStringProperty(module, "valueExpr"));
            }
            displayLabel = String.valueOf(displayLabel) + ")";
        }
        return displayLabel;
    }
}

