/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.BundleFactory;
import org.eclipse.birt.report.model.api.IBundleFactory;
import org.eclipse.birt.report.model.api.IResourceLocator;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.core.BundleHelper;
import org.eclipse.birt.report.model.util.SecurityUtil;
import org.eclipse.birt.report.model.util.URIUtilImpl;

public class ResourceLocatorImplBase
implements IResourceLocator {
    @Override
    public URL findResource(ModuleHandle moduleHandle, String fileName, int type) {
        return this.findResource(moduleHandle, fileName, type, Collections.EMPTY_MAP);
    }

    @Override
    public URL findResource(ModuleHandle moduleHandle, String fileName, int type, Map appContext) {
        Object loc;
        URL u = null;
        if (fileName == null) {
            return u;
        }
        int location = 15;
        if (appContext != null && (loc = appContext.get("birtResourceLocatorSearchLocation")) instanceof Integer) {
            location = (Integer)loc;
        }
        switch (type) {
            case 5: {
                u = this.getMessageFile(moduleHandle, fileName, location);
                break;
            }
            default: {
                u = this.getResource(moduleHandle, fileName, location);
            }
        }
        return u;
    }

    private URL getMessageFile(ModuleHandle moduleHandle, String fileName, int location) {
        if (moduleHandle == null) {
            return null;
        }
        ULocale locale = moduleHandle.getModule().getSession().getLocale();
        List<String> possibleFiles = BundleHelper.getHelper(moduleHandle.getModule(), fileName).getMessageFilenames(locale);
        int i = 0;
        while (i < possibleFiles.size()) {
            String filename = possibleFiles.get(i);
            URL url = this.getResource(moduleHandle, filename, location);
            if (url != null) {
                return url;
            }
            ++i;
        }
        return null;
    }

    private URL getResource(ModuleHandle moduleHandle, String fileName, int location) {
        URL retURL;
        if ((location & 1) != 0) {
            URL retURL2 = this.tryDiskFileSearch(null, fileName);
            if (retURL2 != null) {
                return retURL2;
            }
            try {
                retURL2 = this.tryURLSearch(new URL(fileName));
                if (retURL2 != null) {
                    return retURL2;
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (moduleHandle == null && (location & 2) != 0) {
            return this.tryFragmentSearch(fileName);
        }
        String resourcePath = moduleHandle.getModule().getSession().getResourceFolder();
        if (StringUtil.isBlank(resourcePath)) {
            resourcePath = moduleHandle.getResourceFolder();
        }
        if (resourcePath != null && (location & 4) != 0) {
            retURL = this.tryDiskFileSearch(resourcePath, fileName);
            if (retURL != null) {
                return retURL;
            }
            try {
                URL baseURL = new URL(resourcePath);
                retURL = this.tryURLSearch(baseURL, fileName);
            }
            catch (MalformedURLException malformedURLException) {}
            if (retURL != null) {
                return retURL;
            }
        }
        if ((location & 2) != 0 && (retURL = this.tryFragmentSearch(fileName)) != null) {
            return retURL;
        }
        URL systemId = moduleHandle.getModule().getSystemId();
        if (systemId != null && (location & 8) != 0) {
            return this.tryURLSearch(systemId, fileName);
        }
        return null;
    }

    private boolean isGlobalResource(URL url) {
        if ("ftp".equalsIgnoreCase(url.getProtocol()) || "http".equalsIgnoreCase(url.getProtocol()) || "https".equalsIgnoreCase(url.getProtocol()) || "mailto".equalsIgnoreCase(url.getProtocol())) {
            return true;
        }
        return url.getFile().toLowerCase().startsWith("ftp") || url.getFile().toLowerCase().startsWith("http");
    }

    private URL tryURLSearch(URL baseURL, String fileName) {
        assert (baseURL != null);
        URL retURL = null;
        try {
            retURL = URIUtilImpl.isBundleProtocol(baseURL.toString()) ? this.tryURLSearch(new URL(baseURL, fileName)) : this.tryURLSearch(new URL(baseURL, URIUtil.convertFileNameToURLString(fileName)));
        }
        catch (MalformedURLException malformedURLException) {}
        return retURL;
    }

    private URL tryURLSearch(URL url) {
        boolean networkProtocol = this.isGlobalResource(url);
        if (networkProtocol) {
            return url;
        }
        InputStream in = null;
        try {
            try {
                in = url.openStream();
            }
            catch (IOException iOException) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException2) {}
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return url;
    }

    private URL tryFragmentSearch(String fileName) {
        IBundleFactory bundleFactory = BundleFactory.getBundleFactory();
        if (bundleFactory != null) {
            return bundleFactory.getBundleResource("org.eclipse.birt.resources", fileName);
        }
        return this.getClass().getClassLoader().getResource(fileName);
    }

    private URL tryDiskFileSearch(String fileDir, String filePath) {
        block5: {
            File f = null;
            String tmpFilePath = URIUtilImpl.toUniversalFileFormat(filePath);
            f = StringUtil.isBlank(fileDir) ? new File(tmpFilePath) : new File(fileDir, tmpFilePath);
            try {
                if (SecurityUtil.exists(f) && SecurityUtil.isFile(f)) {
                    return SecurityUtil.fileToURI(SecurityUtil.getCanonicalFile(f)).toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                assert (false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        return null;
    }
}

