/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ISideEffect;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.Assert;

public final class SideEffect
implements ISideEffect {
    public static final ISideEffect NULL_SIDE_EFFECT = new ISideEffect(){

        @Override
        public void dispose() {
        }

        @Override
        public void pause() {
        }

        @Override
        public void resume() {
        }

        @Override
        public void resumeAndRunIfDirty() {
        }

        @Override
        public void runIfDirty() {
        }
    };
    private boolean dirty;
    private boolean asyncScheduled;
    private boolean resumed;
    private Runnable runnable;
    private IObservable[] dependencies;
    private Realm realm;
    private PrivateInterface privateInterface = new PrivateInterface();

    public SideEffect(Runnable runnable) {
        this(Realm.getDefault(), runnable);
    }

    public SideEffect(Realm realm, Runnable runnable) {
        this.runnable = runnable;
        this.realm = realm;
        this.dirty = true;
    }

    public SideEffect(Runnable runnable, IObservable ... dependencies) {
        this.dependencies = dependencies;
        this.runnable = runnable;
        this.dirty = false;
        this.resumed = true;
        this.realm = Realm.getDefault();
        IObservable[] iObservableArray = dependencies;
        int n = dependencies.length;
        int n2 = 0;
        while (n2 < n) {
            IObservable next = iObservableArray[n2];
            next.addChangeListener(this.privateInterface);
            ++n2;
        }
    }

    @Override
    public void resume() {
        this.checkState();
        if (this.resumed) {
            return;
        }
        this.resumed = true;
        if (this.dirty) {
            this.scheduleUpdate();
        }
    }

    @Override
    public void pause() {
        this.checkState();
        this.resumed = false;
        if (this.dirty) {
            this.stopListening();
            this.dependencies = null;
        }
    }

    @Override
    public void resumeAndRunIfDirty() {
        this.checkState();
        this.resumed = true;
        this.update();
    }

    private void update() {
        if (this.dirty && this.resumed) {
            this.dirty = false;
            this.stopListening();
            IObservable[] newDependencies = ObservableTracker.runAndMonitor(this.runnable, null, null);
            if (this.isDisposed()) {
                return;
            }
            IObservable[] iObservableArray = newDependencies;
            int n = newDependencies.length;
            int n2 = 0;
            while (n2 < n) {
                IObservable next = iObservableArray[n2];
                next.addChangeListener(this.privateInterface);
                ++n2;
            }
            this.dependencies = newDependencies;
        }
    }

    @Override
    public void dispose() {
        this.checkRealm();
        this.resumed = false;
        this.stopListening();
        this.dependencies = null;
        this.runnable = null;
    }

    private boolean isDisposed() {
        return this.runnable == null;
    }

    @Override
    public void runIfDirty() {
        this.checkState();
        this.update();
    }

    private void stopListening() {
        if (this.dependencies != null) {
            IObservable[] iObservableArray = this.dependencies;
            int n = this.dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                IObservable observable = iObservableArray[n2];
                observable.removeChangeListener(this.privateInterface);
                ++n2;
            }
        }
    }

    private void markDirtyInternal() {
        if (!this.dirty) {
            this.dirty = true;
            if (this.resumed) {
                this.scheduleUpdate();
            } else {
                this.stopListening();
                this.dependencies = null;
            }
        }
    }

    private void scheduleUpdate() {
        if (this.asyncScheduled) {
            return;
        }
        this.asyncScheduled = true;
        this.realm.asyncExec(this.privateInterface);
    }

    private void checkState() {
        if (this.isDisposed()) {
            throw new IllegalStateException("This SideEffect has been disposed!");
        }
        this.checkRealm();
    }

    private void checkRealm() {
        Assert.isTrue((boolean)this.realm.isCurrent(), (String)"This operation must be run within the observable's realm");
    }

    public static <T> Runnable makeRunnable(Supplier<T> supplier, Consumer<T> consumer) {
        return () -> {
            Object value = supplier.get();
            ObservableTracker.setIgnore(true);
            try {
                consumer.accept(value);
            }
            finally {
                ObservableTracker.setIgnore(false);
            }
        };
    }

    private class PrivateInterface
    implements IChangeListener,
    Runnable {
        private PrivateInterface() {
        }

        @Override
        public void handleChange(ChangeEvent event) {
            SideEffect.this.markDirtyInternal();
        }

        @Override
        public void run() {
            SideEffect.this.asyncScheduled = false;
            SideEffect.this.update();
        }
    }
}

