/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaHotCodeReplaceListener;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaThreadGroup;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.ActionFilterAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.debug.ui.JavaBreakpointWorkbenchAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.JavaDebugOptionsManager;
import org.eclipse.jdt.internal.debug.ui.JavaHotCodeReplaceListener;
import org.eclipse.jdt.internal.debug.ui.JavaSourceLocationWorkbenchAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.PackageSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.breakpoints.ExceptionInspector;
import org.eclipse.jdt.internal.debug.ui.breakpoints.JavaBreakpointTypeAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntryAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaContendedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwnedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwningThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaWaitingThread;
import org.eclipse.jdt.internal.debug.ui.monitors.MonitorsAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetFileDocumentProvider;
import org.eclipse.jdt.internal.debug.ui.sourcelookup.JavaDebugShowInAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.threadgroups.TargetAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.threadgroups.ThreadGroupAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.variables.ColumnPresentationAdapterFactory;
import org.eclipse.jdt.internal.debug.ui.variables.JavaDebugElementAdapterFactory;
import org.eclipse.jdt.internal.launching.DefaultProjectClasspathEntry;
import org.eclipse.jdt.launching.sourcelookup.IJavaSourceLocation;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class JDIDebugUIPlugin
extends AbstractUIPlugin {
    private static final String PI_JDI_DEBUG = "org.eclipse.jdt.debug.ui";
    public static final String COMMAND_INSPECT = "org.eclipse.jdt.debug.ui.commands.Inspect";
    private static JDIDebugUIPlugin fgPlugin;
    private IDocumentProvider fSnippetDocumentProvider;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private ActionFilterAdapterFactory fActionFilterAdapterFactory;
    private JavaSourceLocationWorkbenchAdapterFactory fSourceLocationAdapterFactory;
    private JavaBreakpointWorkbenchAdapterFactory fBreakpointAdapterFactory;
    private IDebugModelPresentation fUtilPresentation;
    private IJavaHotCodeReplaceListener fHCRListener;
    protected Map<String, IConfigurationElement> fVmInstallTypePageMap;
    private boolean fShuttingDown = false;
    private JavaTextTools fTextTools = null;

    public JDIDebugUIPlugin() {
        JDIDebugUIPlugin.setDefault(this);
    }

    private static void setDefault(JDIDebugUIPlugin plugin) {
        fgPlugin = plugin;
    }

    public static JDIDebugUIPlugin getDefault() {
        return fgPlugin;
    }

    public static String getUniqueIdentifier() {
        return PI_JDI_DEBUG;
    }

    public static void log(IStatus status) {
        JDIDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        JDIDebugUIPlugin.log((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, message, null));
    }

    public static void log(Throwable e) {
        JDIDebugUIPlugin.log((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, "Internal Error", e));
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return JDIDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = JDIDebugUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = JDIDebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    protected ImageRegistry createImageRegistry() {
        return JavaDebugImages.getImageRegistry();
    }

    public IDocumentProvider getSnippetDocumentProvider() {
        if (this.fSnippetDocumentProvider == null) {
            this.fSnippetDocumentProvider = new SnippetFileDocumentProvider();
        }
        return this.fSnippetDocumentProvider;
    }

    public static void statusDialog(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                JDIDebugUIPlugin.statusDialog(DebugUIMessages.JDIDebugUIPlugin_Error_1, status);
                break;
            }
            case 2: {
                JDIDebugUIPlugin.statusDialog(DebugUIMessages.JDIDebugUIPlugin_0, status);
                break;
            }
            case 1: {
                JDIDebugUIPlugin.statusDialog(DebugUIMessages.JDIDebugUIPlugin_4, status);
            }
        }
    }

    public static void statusDialog(String title, IStatus status) {
        Shell shell = JDIDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            switch (status.getSeverity()) {
                case 4: {
                    ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)status);
                    break;
                }
                case 2: {
                    MessageDialog.openWarning((Shell)shell, (String)title, (String)status.getMessage());
                    break;
                }
                case 1: {
                    MessageDialog.openInformation((Shell)shell, (String)title, (String)status.getMessage());
                }
            }
        }
    }

    public static void errorDialog(String message, Throwable t) {
        Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, message, t);
        JDIDebugUIPlugin.statusDialog((IStatus)status);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 120, "Error within Debug UI: ", t);
            JDIDebugUIPlugin.log(status);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        if (bundle.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IAdapterManager manager = Platform.getAdapterManager();
        this.fActionFilterAdapterFactory = new ActionFilterAdapterFactory();
        manager.registerAdapters((IAdapterFactory)this.fActionFilterAdapterFactory, IMember.class);
        manager.registerAdapters((IAdapterFactory)this.fActionFilterAdapterFactory, IJavaVariable.class);
        manager.registerAdapters((IAdapterFactory)this.fActionFilterAdapterFactory, IJavaStackFrame.class);
        manager.registerAdapters((IAdapterFactory)this.fActionFilterAdapterFactory, IJavaThread.class);
        manager.registerAdapters((IAdapterFactory)this.fActionFilterAdapterFactory, JavaInspectExpression.class);
        this.fSourceLocationAdapterFactory = new JavaSourceLocationWorkbenchAdapterFactory();
        manager.registerAdapters((IAdapterFactory)this.fSourceLocationAdapterFactory, IJavaSourceLocation.class);
        this.fBreakpointAdapterFactory = new JavaBreakpointWorkbenchAdapterFactory();
        manager.registerAdapters((IAdapterFactory)this.fBreakpointAdapterFactory, IJavaBreakpoint.class);
        JavaBreakpointTypeAdapterFactory typeFactory = new JavaBreakpointTypeAdapterFactory();
        manager.registerAdapters((IAdapterFactory)typeFactory, IJavaBreakpoint.class);
        MonitorsAdapterFactory monitorFactory = new MonitorsAdapterFactory();
        manager.registerAdapters((IAdapterFactory)monitorFactory, IJavaThread.class);
        manager.registerAdapters((IAdapterFactory)monitorFactory, JavaContendedMonitor.class);
        manager.registerAdapters((IAdapterFactory)monitorFactory, JavaOwnedMonitor.class);
        manager.registerAdapters((IAdapterFactory)monitorFactory, JavaOwningThread.class);
        manager.registerAdapters((IAdapterFactory)monitorFactory, JavaWaitingThread.class);
        manager.registerAdapters((IAdapterFactory)monitorFactory, IJavaStackFrame.class);
        TargetAdapterFactory targetFactory = new TargetAdapterFactory();
        manager.registerAdapters((IAdapterFactory)targetFactory, IJavaDebugTarget.class);
        ThreadGroupAdapterFactory groupFactory = new ThreadGroupAdapterFactory();
        manager.registerAdapters((IAdapterFactory)groupFactory, IJavaThreadGroup.class);
        JavaDebugShowInAdapterFactory showInFactory = new JavaDebugShowInAdapterFactory();
        manager.registerAdapters((IAdapterFactory)showInFactory, IJavaStackFrame.class);
        ColumnPresentationAdapterFactory columnFactory = new ColumnPresentationAdapterFactory();
        manager.registerAdapters((IAdapterFactory)columnFactory, IJavaVariable.class);
        manager.registerAdapters((IAdapterFactory)columnFactory, IJavaStackFrame.class);
        ClasspathEntryAdapterFactory entryFactory = new ClasspathEntryAdapterFactory();
        manager.registerAdapters((IAdapterFactory)entryFactory, DefaultProjectClasspathEntry.class);
        JavaDebugElementAdapterFactory variableFactory = new JavaDebugElementAdapterFactory();
        manager.registerAdapters((IAdapterFactory)variableFactory, IJavaVariable.class);
        manager.registerAdapters((IAdapterFactory)variableFactory, IJavaValue.class);
        manager.registerAdapters((IAdapterFactory)variableFactory, JavaInspectExpression.class);
        this.fHCRListener = new JavaHotCodeReplaceListener();
        JDIDebugModel.addHotCodeReplaceListener((IJavaHotCodeReplaceListener)this.fHCRListener);
        new ExceptionInspector();
        ResourcesPlugin.getWorkspace().addSaveParticipant(JDIDebugUIPlugin.getUniqueIdentifier(), new ISaveParticipant(){

            public void doneSaving(ISaveContext sc) {
            }

            public void prepareToSave(ISaveContext sc) throws CoreException {
            }

            public void rollback(ISaveContext sc) {
            }

            public void saving(ISaveContext sc) throws CoreException {
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(JDIDebugUIPlugin.getUniqueIdentifier());
                if (prefs != null) {
                    try {
                        prefs.flush();
                    }
                    catch (BackingStoreException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                }
            }
        });
        JavaDebugOptionsManager.getDefault().startup();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.setShuttingDown(true);
            JDIDebugModel.removeHotCodeReplaceListener((IJavaHotCodeReplaceListener)this.fHCRListener);
            JavaDebugOptionsManager.getDefault().shutdown();
            if (this.fImageDescriptorRegistry != null) {
                this.fImageDescriptorRegistry.dispose();
            }
            IAdapterManager manager = Platform.getAdapterManager();
            manager.unregisterAdapters((IAdapterFactory)this.fActionFilterAdapterFactory);
            manager.unregisterAdapters((IAdapterFactory)this.fSourceLocationAdapterFactory);
            manager.unregisterAdapters((IAdapterFactory)this.fBreakpointAdapterFactory);
            if (this.fUtilPresentation != null) {
                this.fUtilPresentation.dispose();
            }
            if (this.fTextTools != null) {
                this.fTextTools.dispose();
            }
            ResourcesPlugin.getWorkspace().removeSaveParticipant(JDIDebugUIPlugin.getUniqueIdentifier());
        }
        finally {
            super.stop(context);
        }
    }

    protected boolean isShuttingDown() {
        return this.fShuttingDown;
    }

    private void setShuttingDown(boolean value) {
        this.fShuttingDown = value;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (JDIDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            JDIDebugUIPlugin.getDefault().fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return JDIDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }

    public static ElementListSelectionDialog createAllPackagesDialog(Shell shell, IJavaProject[] originals, final boolean includeDefaultPackage) throws JavaModelException {
        final ArrayList packageList = new ArrayList();
        if (originals == null) {
            IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
            IJavaModel model = JavaCore.create((IWorkspaceRoot)wsroot);
            originals = model.getJavaProjects();
        }
        final IJavaProject[] projects = originals;
        final JavaModelException[] exception = new JavaModelException[1];
        final boolean[] monitorCanceled = new boolean[1];
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    HashSet<String> packageNameSet = new HashSet<String>();
                    monitor.beginTask(DebugUIMessages.JDIDebugUIPlugin_Searching_1, projects.length);
                    int i = 0;
                    while (i < projects.length) {
                        IPackageFragment[] pkgs = projects[i].getPackageFragments();
                        int j = 0;
                        while (j < pkgs.length) {
                            if (monitor.isCanceled()) {
                                monitorCanceled[0] = true;
                                return;
                            }
                            IPackageFragment pkg = pkgs[j];
                            if (pkg.hasChildren() || pkg.getNonJavaResources().length <= 0) {
                                String pkgName = pkg.getElementName();
                                if ((includeDefaultPackage || pkgName.length() != 0) && packageNameSet.add(pkgName)) {
                                    packageList.add(pkg);
                                }
                            }
                            ++j;
                        }
                        monitor.worked(1);
                        ++i;
                    }
                    monitor.done();
                }
                catch (JavaModelException jme) {
                    exception[0] = jme;
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(r);
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            JDIDebugUIPlugin.log(e);
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        if (monitorCanceled[0]) {
            return null;
        }
        int flags = JavaElementLabelProvider.SHOW_DEFAULT;
        PackageSelectionDialog dialog = new PackageSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(flags));
        dialog.setIgnoreCase(false);
        dialog.setElements(packageList.toArray());
        return dialog;
    }

    public ILaunchConfigurationTab getVMInstallTypePage(String vmInstallTypeID) {
        if (this.fVmInstallTypePageMap == null) {
            this.initializeVMInstallTypePageMap();
        }
        IConfigurationElement configElement = this.fVmInstallTypePageMap.get(vmInstallTypeID);
        ILaunchConfigurationTab tab = null;
        if (configElement != null) {
            try {
                tab = (ILaunchConfigurationTab)configElement.createExecutableExtension("class");
            }
            catch (CoreException ce) {
                JDIDebugUIPlugin.log((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, "An error occurred retrieving a VMInstallType page.", (Throwable)ce));
            }
        }
        return tab;
    }

    protected void initializeVMInstallTypePageMap() {
        this.fVmInstallTypePageMap = new HashMap<String, IConfigurationElement>(10);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(JDIDebugUIPlugin.getUniqueIdentifier(), "vmInstallTypePage");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            String id = infos[i].getAttribute("vmInstallTypeID");
            this.fVmInstallTypePageMap.put(id, infos[i]);
            ++i;
        }
    }

    public IDebugModelPresentation getModelPresentation() {
        if (this.fUtilPresentation == null) {
            this.fUtilPresentation = DebugUITools.newDebugModelPresentation((String)JDIDebugModel.getPluginIdentifier());
        }
        return this.fUtilPresentation;
    }

    @Deprecated
    public static void showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(JDIDebugUIPlugin.getActiveWorkbenchShell(), manager);
        boolean[] result = new boolean[1];
        BusyIndicator.showWhile((Display)JDIDebugUIPlugin.getStandardDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode, result){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            private final /* synthetic */ boolean[] val$result;
            {
                this.val$targetNode = iPreferenceNode;
                this.val$result = blArray;
            }

            @Override
            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                this.val$result[0] = dialog.open() == 0;
            }
        });
    }

    public static void showPreferencePage(String pageId) {
        PreferencesUtil.createPreferenceDialogOn((Shell)JDIDebugUIPlugin.getShell(), (String)pageId, (String[])new String[]{pageId}, null).open();
    }

    public JavaTextTools getJavaTextTools() {
        if (this.fTextTools == null) {
            this.fTextTools = new JavaTextTools(PreferenceConstants.getPreferenceStore());
        }
        return this.fTextTools;
    }
}

