/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.jdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.jdt.internal.corext.fix.CleanUpRegistry;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.CleanUpSelectionDialog;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.internal.ui.preferences.BulletListBlock;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.cleanup.CleanUpTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.IModifyDialogTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.xml.sax.InputSource;

public class CleanUpRefactoringWizard
extends RefactoringWizard {
    private static final String USE_CUSTOM_PROFILE_KEY = "org.eclipse.jdt.ui.cleanup.use_dialog_profile";
    private static final String CUSTOM_PROFILE_KEY = "org.eclipse.jdt.ui.cleanup.custom_profile";

    public CleanUpRefactoringWizard(CleanUpRefactoring refactoring, int flags) {
        super((Refactoring)refactoring, flags);
        this.setDefaultPageTitle(MultiFixMessages.CleanUpRefactoringWizard_PageTitle);
        this.setWindowTitle(MultiFixMessages.CleanUpRefactoringWizard_WindowTitle);
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_CLEAN_UP);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new CleanUpConfigurationPage((CleanUpRefactoring)this.getRefactoring()));
    }

    private static class CleanUpConfigurationPage
    extends UserInputWizardPage
    implements IModifyDialogTabPage.IModificationListener {
        private static final String ENCODING = "UTF-8";
        private final CleanUpRefactoring fCleanUpRefactoring;
        private Map<String, String> fCustomSettings;
        private SelectionButtonDialogField fUseCustomField;
        private ControlEnableState fEnableState;

        public CleanUpConfigurationPage(CleanUpRefactoring refactoring) {
            super(MultiFixMessages.CleanUpRefactoringWizard_CleanUpConfigurationPage_title);
            this.fCleanUpRefactoring = refactoring;
            int cleanUpTargetsSize = this.fCleanUpRefactoring.getCleanUpTargetsSize();
            IJavaProject[] projects = this.fCleanUpRefactoring.getProjects();
            if (cleanUpTargetsSize == 1) {
                this.setMessage(MultiFixMessages.CleanUpRefactoringWizard_CleaningUp11_Title);
            } else if (projects.length == 1) {
                this.setMessage(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_CleaningUpN1_Title, new Integer(cleanUpTargetsSize)));
            } else {
                this.setMessage(Messages.format(MultiFixMessages.CleanUpRefactoringWizard_CleaningUpNN_Title, new Object[]{new Integer(cleanUpTargetsSize), new Integer(projects.length)}));
            }
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            boolean isCustom = this.getDialogSettings().getBoolean(CleanUpRefactoringWizard.USE_CUSTOM_PROFILE_KEY);
            final Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            SelectionButtonDialogField useProfile = new SelectionButtonDialogField(16);
            useProfile.setLabelText(MultiFixMessages.CleanUpRefactoringWizard_use_configured_radio);
            useProfile.setSelection(!isCustom);
            useProfile.doFillIntoGrid(composite, 2);
            ProjectProfileLableProvider tableLabelProvider = new ProjectProfileLableProvider();
            ProfileTableAdapter listAdapter = new ProfileTableAdapter(tableLabelProvider, this.getShell());
            String[] buttons = new String[]{MultiFixMessages.CleanUpRefactoringWizard_Configure_Button};
            final ListDialogField<IJavaProject> settingsField = new ListDialogField<IJavaProject>((IListAdapter)listAdapter, buttons, (ILabelProvider)tableLabelProvider){

                @Override
                protected int getListStyle() {
                    return super.getListStyle() | 4;
                }
            };
            String[] headerNames = new String[]{MultiFixMessages.CleanUpRefactoringWizard_Project_TableHeader, MultiFixMessages.CleanUpRefactoringWizard_Profile_TableHeader};
            ColumnLayoutData[] columns = new ColumnLayoutData[]{new ColumnWeightData(2, true), new ColumnWeightData(1, true)};
            settingsField.setTableColumns(new ListDialogField.ColumnsDescription(columns, headerNames, true));
            settingsField.setViewerComparator(new ViewerComparator());
            settingsField.doFillIntoGrid(composite, 3);
            Table table = settingsField.getTableViewer().getTable();
            GridData data = (GridData)settingsField.getListControl(null).getLayoutData();
            data.horizontalIndent = 15;
            data.grabExcessVerticalSpace = false;
            data.heightHint = SWTUtil.getTableHeightHint(table, Math.min(5, this.fCleanUpRefactoring.getProjects().length + 2));
            data.grabExcessHorizontalSpace = true;
            data.verticalAlignment = 1;
            data = (GridData)settingsField.getButtonBox(null).getLayoutData();
            data.grabExcessVerticalSpace = false;
            data.verticalAlignment = 1;
            data = (GridData)settingsField.getLabelControl(null).getLayoutData();
            data.exclude = true;
            settingsField.setElements(Arrays.asList(this.fCleanUpRefactoring.getProjects()));
            settingsField.selectFirstElement();
            this.fUseCustomField = new SelectionButtonDialogField(16);
            this.fUseCustomField.setLabelText(MultiFixMessages.CleanUpRefactoringWizard_use_custom_radio);
            this.fUseCustomField.setSelection(isCustom);
            this.fUseCustomField.doFillIntoGrid(composite, 2);
            String settings = this.getDialogSettings().get(CleanUpRefactoringWizard.CUSTOM_PROFILE_KEY);
            if (settings == null) {
                this.fCustomSettings = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(1).getMap();
            } else {
                try {
                    this.fCustomSettings = this.decodeSettings(settings);
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                    this.fCustomSettings = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(1).getMap();
                }
            }
            final BulletListBlock bulletListBlock = new BulletListBlock(composite, 0);
            GridData layoutData = new GridData(4, 4, true, true);
            layoutData.horizontalIndent = 15;
            layoutData.grabExcessVerticalSpace = true;
            bulletListBlock.setLayoutData(layoutData);
            final Button configure = new Button(composite, 0);
            configure.setText(MultiFixMessages.CleanUpRefactoringWizard_ConfigureCustomProfile_button);
            data = new GridData(128, 16384, false, false);
            data.widthHint = SWTUtil.getButtonWidthHint(configure);
            configure.setLayoutData((Object)data);
            this.showCustomSettings(bulletListBlock);
            configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Hashtable workingValues = new Hashtable(CleanUpConfigurationPage.this.fCustomSettings);
                    WizardCleanUpSelectionDialog dialog = new WizardCleanUpSelectionDialog(CleanUpConfigurationPage.this.getShell(), (Map)workingValues);
                    if (dialog.open() == 0) {
                        CleanUpConfigurationPage.this.fCustomSettings = workingValues;
                        CleanUpConfigurationPage.this.showCustomSettings(bulletListBlock);
                    }
                }
            });
            this.updateEnableState(isCustom, settingsField, configure, bulletListBlock);
            this.fUseCustomField.setDialogFieldListener(new IDialogFieldListener(){

                @Override
                public void dialogFieldChanged(DialogField field) {
                    CleanUpConfigurationPage.this.updateEnableState(CleanUpConfigurationPage.this.fUseCustomField.isSelected(), settingsField, configure, bulletListBlock);
                }
            });
            Link preferencePageLink = new Link(composite, 64);
            preferencePageLink.setText(MultiFixMessages.CleanUpRefactoringWizard_HideWizard_Link);
            preferencePageLink.setFont(parent.getFont());
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = this.convertWidthInCharsToPixels(50);
            gridData.horizontalSpan = 2;
            preferencePageLink.setLayoutData((Object)gridData);
            preferencePageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)composite.getShell(), (String)"org.eclipse.jdt.ui.preferences.CleanUpPreferencePage", null, null).open();
                }
            });
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
        }

        private void updateEnableState(boolean isCustom, ListDialogField<IJavaProject> settingsField, Button configureCustom, BulletListBlock bulletListBlock) {
            settingsField.getListControl(null).setEnabled(!isCustom);
            if (isCustom) {
                this.fEnableState = ControlEnableState.disable((Control)settingsField.getButtonBox(null));
            } else if (this.fEnableState != null) {
                this.fEnableState.restore();
                this.fEnableState = null;
            }
            bulletListBlock.setEnabled(isCustom);
            configureCustom.setEnabled(isCustom);
        }

        private void showCustomSettings(BulletListBlock bulletListBlock) {
            StringBuffer buf = new StringBuffer();
            ICleanUp[] cleanUps = JavaPlugin.getDefault().getCleanUpRegistry().createCleanUps();
            MapCleanUpOptions options = new MapCleanUpOptions(this.fCustomSettings);
            int i = 0;
            while (i < cleanUps.length) {
                cleanUps[i].setOptions(options);
                String[] descriptions = cleanUps[i].getStepDescriptions();
                if (descriptions != null) {
                    int j = 0;
                    while (j < descriptions.length) {
                        if (buf.length() > 0) {
                            buf.append('\n');
                        }
                        buf.append(descriptions[j]);
                        ++j;
                    }
                }
                ++i;
            }
            bulletListBlock.setText(buf.toString());
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
            this.getDialogSettings().put(CleanUpRefactoringWizard.USE_CUSTOM_PROFILE_KEY, this.fUseCustomField.isSelected());
            try {
                this.getDialogSettings().put(CleanUpRefactoringWizard.CUSTOM_PROFILE_KEY, this.encodeSettings(this.fCustomSettings));
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }

        private void initializeRefactoring() {
            CleanUpRefactoring refactoring = (CleanUpRefactoring)this.getRefactoring();
            MapCleanUpOptions options = null;
            if (this.fUseCustomField.isSelected()) {
                refactoring.setUseOptionsFromProfile(false);
                options = new MapCleanUpOptions(this.fCustomSettings);
            } else {
                refactoring.setUseOptionsFromProfile(true);
            }
            refactoring.clearCleanUps();
            ICleanUp[] cleanups = JavaPlugin.getDefault().getCleanUpRegistry().createCleanUps();
            int i = 0;
            while (i < cleanups.length) {
                if (options != null) {
                    cleanups[i].setOptions(options);
                }
                refactoring.addCleanUp(cleanups[i]);
                ++i;
            }
        }

        /*
         * Loose catch block
         */
        public String encodeSettings(Map<String, String> settings) throws CoreException {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(2000);
            CleanUpProfileVersioner versioner = new CleanUpProfileVersioner();
            ProfileManager.CustomProfile profile = new ProfileManager.CustomProfile("custom", settings, versioner.getCurrentVersion(), versioner.getProfileKind());
            ArrayList<ProfileManager.Profile> profiles = new ArrayList<ProfileManager.Profile>();
            profiles.add(profile);
            ProfileStore.writeProfilesToStream(profiles, stream, ENCODING, versioner);
            String string = stream.toString(ENCODING);
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            return string;
            {
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    String string2;
                    try {
                        string2 = stream.toString();
                    }
                    catch (Throwable throwable) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    return string2;
                }
            }
        }

        public Map<String, String> decodeSettings(String settings) throws CoreException {
            List<ProfileManager.Profile> res;
            ByteArrayInputStream is;
            block11: {
                Map<String, String> map;
                byte[] bytes;
                try {
                    bytes = settings.getBytes(ENCODING);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bytes = settings.getBytes();
                }
                is = new ByteArrayInputStream(bytes);
                try {
                    res = ProfileStore.readProfilesFromStream(new InputSource(is));
                    if (res != null && res.size() != 0) break block11;
                    map = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(1).getMap();
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
                return map;
            }
            ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)res.get(0);
            new CleanUpProfileVersioner().update(profile);
            Map<String, String> map = profile.getSettings();
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
            return map;
        }

        @Override
        public void updateStatus(IStatus status) {
        }

        @Override
        public void valuesModified() {
        }

        private static final class ProfileTableAdapter
        implements IListAdapter<IJavaProject> {
            private final ProjectProfileLableProvider fProvider;
            private final Shell fShell;

            private ProfileTableAdapter(ProjectProfileLableProvider provider, Shell shell) {
                this.fProvider = provider;
                this.fShell = shell;
            }

            @Override
            public void customButtonPressed(ListDialogField<IJavaProject> field, int index) {
                this.openPropertyDialog(field);
            }

            @Override
            public void doubleClicked(ListDialogField<IJavaProject> field) {
                this.openPropertyDialog(field);
            }

            private void openPropertyDialog(ListDialogField<IJavaProject> field) {
                IJavaProject project = field.getSelectedElements().get(0);
                PreferencesUtil.createPropertyDialogOn((Shell)this.fShell, (IAdaptable)project, (String)"org.eclipse.jdt.ui.propertyPages.CleanUpPreferencePage", null, null).open();
                List<IJavaProject> selectedElements = field.getSelectedElements();
                this.fProvider.reset();
                field.refresh();
                field.selectElements((ISelection)new StructuredSelection(selectedElements));
            }

            @Override
            public void selectionChanged(ListDialogField<IJavaProject> field) {
                if (field.getSelectedElements().size() != 1) {
                    field.enableButton(0, false);
                } else {
                    field.enableButton(0, true);
                }
            }
        }

        private static final class WizardCleanUpSelectionDialog
        extends CleanUpSelectionDialog {
            private static final String CLEAN_UP_SELECTION_PREFERENCE_KEY = "clean_up_selection_dialog";

            private WizardCleanUpSelectionDialog(Shell parent, Map<String, String> settings) {
                super(parent, settings, MultiFixMessages.CleanUpRefactoringWizard_CustomCleanUpsDialog_title);
            }

            @Override
            protected CleanUpSelectionDialog.NamedCleanUpTabPage[] createTabPages(Map<String, String> workingValues) {
                CleanUpRegistry.CleanUpTabPageDescriptor[] descriptors = JavaPlugin.getDefault().getCleanUpRegistry().getCleanUpTabPageDescriptors(1);
                CleanUpSelectionDialog.NamedCleanUpTabPage[] result = new CleanUpSelectionDialog.NamedCleanUpTabPage[descriptors.length];
                int i = 0;
                while (i < descriptors.length) {
                    String name = descriptors[i].getName();
                    CleanUpTabPage page = descriptors[i].createTabPage();
                    page.setOptionsKind(1);
                    page.setModifyListener(this);
                    page.setWorkingValues(workingValues);
                    result[i] = new CleanUpSelectionDialog.NamedCleanUpTabPage(name, page);
                    ++i;
                }
                return result;
            }

            @Override
            protected String getPreferenceKeyPrefix() {
                return CLEAN_UP_SELECTION_PREFERENCE_KEY;
            }

            @Override
            protected String getSelectionCountMessage(int selectionCount, int size) {
                return Messages.format(MultiFixMessages.CleanUpRefactoringWizard_XofYCleanUpsSelected_message, new Object[]{new Integer(selectionCount), new Integer(size)});
            }

            @Override
            protected String getEmptySelectionMessage() {
                return MultiFixMessages.CleanUpRefactoringWizard_EmptySelection_message;
            }
        }
    }

    private static class ProjectProfileLableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Hashtable<String, ProfileManager.Profile> fProfileIdsTable;

        private ProjectProfileLableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((IJavaProject)element).getProject().getName();
            }
            if (columnIndex == 1) {
                IEclipsePreferences instancePreferences;
                if (this.fProfileIdsTable == null) {
                    this.fProfileIdsTable = this.loadProfiles();
                }
                String workbenchProfileId = (instancePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.ui")).get("cleanup_profile", null) != null ? instancePreferences.get("cleanup_profile", null) : "org.eclipse.jdt.ui.default.eclipse_clean_up_profile";
                return this.getProjectProfileName((IJavaProject)element, this.fProfileIdsTable, workbenchProfileId);
            }
            return null;
        }

        private Hashtable<String, ProfileManager.Profile> loadProfiles() {
            List<ProfileManager.Profile> list = CleanUpPreferenceUtil.loadProfiles(InstanceScope.INSTANCE);
            Hashtable<String, ProfileManager.Profile> profileIdsTable = new Hashtable<String, ProfileManager.Profile>();
            for (ProfileManager.Profile profile : list) {
                profileIdsTable.put(profile.getID(), profile);
            }
            return profileIdsTable;
        }

        private String getProjectProfileName(IJavaProject project, Hashtable<String, ProfileManager.Profile> profileIdsTable, String workbenchProfileId) {
            ProjectScope projectScope = new ProjectScope(project.getProject());
            IEclipsePreferences node = projectScope.getNode("org.eclipse.jdt.ui");
            String id = node.get("cleanup_profile", null);
            if (id == null) {
                ProfileManager.Profile profile = profileIdsTable.get(workbenchProfileId);
                if (profile != null) {
                    return profile.getName();
                }
                return MultiFixMessages.CleanUpRefactoringWizard_unknownProfile_Name;
            }
            ProfileManager.Profile profile = profileIdsTable.get(id);
            if (profile != null) {
                return profile.getName();
            }
            return Messages.format(MultiFixMessages.CleanUpRefactoringWizard_UnmanagedProfileWithName_Name, id.substring("_".length()));
        }

        public void reset() {
            this.fProfileIdsTable = null;
        }
    }
}

