/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.TypeProposalInfo;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;

public class LazyJavaTypeCompletionProposal
extends LazyJavaCompletionProposal {
    protected static final char[] TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', ' '};
    protected static final char[] JDOC_TYPE_TRIGGERS = new char[]{'#', '}', ' ', '.'};
    protected final ICompilationUnit fCompilationUnit;
    private String fQualifiedName;
    private String fSimpleName;
    private ImportRewrite fImportRewrite;
    private ContextSensitiveImportRewriteContext fImportContext;

    public LazyJavaTypeCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context) {
        super(proposal, context);
        this.fCompilationUnit = context.getCompilationUnit();
        this.fQualifiedName = null;
    }

    void setImportRewrite(ImportRewrite importRewrite) {
        this.fImportRewrite = importRewrite;
    }

    public final String getQualifiedTypeName() {
        if (this.fQualifiedName == null) {
            this.fQualifiedName = String.valueOf(Signature.toCharArray((char[])Signature.getTypeErasure((char[])this.fProposal.getSignature())));
        }
        return this.fQualifiedName;
    }

    protected final String getSimpleTypeName() {
        if (this.fSimpleName == null) {
            this.fSimpleName = Signature.getSimpleName((String)this.getQualifiedTypeName());
        }
        return this.fSimpleName;
    }

    @Override
    protected String computeReplacementString() {
        String prefix;
        int dotIndex;
        String replacement = super.computeReplacementString();
        if (this.isImportCompletion()) {
            return replacement;
        }
        if (this.fProposal.getKind() == 9 && this.fInvocationContext.getCoreContext().isInJavadocText()) {
            return this.getSimpleTypeName();
        }
        String qualifiedTypeName = this.getQualifiedTypeName();
        if (this.fCompilationUnit != null && JavaModelUtil.isPackageInfo(this.fCompilationUnit)) {
            return qualifiedTypeName;
        }
        if (qualifiedTypeName.indexOf(46) == -1 && replacement.length() > 0) {
            return qualifiedTypeName;
        }
        IDocument document = this.fInvocationContext.getDocument();
        if (document != null && (dotIndex = (prefix = this.getPrefix(document, this.getReplacementOffset() + this.getReplacementLength())).lastIndexOf(46)) != -1 && qualifiedTypeName.toLowerCase().startsWith(prefix.substring(0, dotIndex + 1).toLowerCase())) {
            return qualifiedTypeName;
        }
        if (replacement.indexOf(46) == -1) {
            if (this.isInJavadoc()) {
                return this.getSimpleTypeName();
            }
            return replacement;
        }
        if (this.fImportRewrite == null) {
            this.fImportRewrite = this.createImportRewrite();
        }
        if (this.fImportRewrite != null) {
            return this.fImportRewrite.addImport(qualifiedTypeName, (ImportRewrite.ImportRewriteContext)this.fImportContext);
        }
        if (this.fCompilationUnit != null && JavaModelUtil.isImplicitImport(Signature.getQualifier((String)qualifiedTypeName), this.fCompilationUnit)) {
            return Signature.getSimpleName((String)qualifiedTypeName);
        }
        return qualifiedTypeName;
    }

    protected final boolean isImportCompletion() {
        char[] completion = this.fProposal.getCompletion();
        if (completion.length == 0) {
            return false;
        }
        char last = completion[completion.length - 1];
        return last == ';' || last == '.';
    }

    private ImportRewrite createImportRewrite() {
        if (this.fCompilationUnit != null && this.allowAddingImports() && !JavaModelUtil.isPackageInfo(this.fCompilationUnit)) {
            try {
                CompilationUnit cu = this.getASTRoot(this.fCompilationUnit);
                if (cu == null) {
                    ImportRewrite rewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
                    this.fImportContext = null;
                    return rewrite;
                }
                ImportRewrite rewrite = StubUtility.createImportRewrite(cu, true);
                this.fImportContext = new ContextSensitiveImportRewriteContext(cu, this.fInvocationContext.getInvocationOffset(), rewrite);
                return rewrite;
            }
            catch (CoreException x) {
                JavaPlugin.log(x);
            }
        }
        return null;
    }

    private CompilationUnit getASTRoot(ICompilationUnit compilationUnit) {
        return SharedASTProvider.getAST((ITypeRoot)compilationUnit, SharedASTProvider.WAIT_NO, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        try {
            boolean insertClosingParenthesis;
            boolean bl = insertClosingParenthesis = trigger == '(' && this.autocloseBrackets();
            if (insertClosingParenthesis) {
                StringBuffer replacement = new StringBuffer(this.getReplacementString());
                this.updateReplacementWithParentheses(replacement);
                this.setReplacementString(replacement.toString());
                trigger = '\u0000';
            }
            super.apply(document, trigger, offset);
            if (this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges()) {
                int oldLen = document.getLength();
                this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()).apply(document, 2);
                this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
            }
            if (insertClosingParenthesis) {
                this.setUpLinkedMode(document, ')');
            }
            this.rememberSelection();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    protected void updateReplacementWithParentheses(StringBuffer replacement) {
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        if (prefs.beforeOpeningParen) {
            replacement.append(" ");
        }
        replacement.append("(");
        if (prefs.afterOpeningParen) {
            replacement.append(" ");
        }
        this.setCursorPosition(replacement.length());
        if (prefs.afterOpeningParen) {
            replacement.append(" ");
        }
        replacement.append(")");
    }

    protected final void rememberSelection() throws JavaModelException {
        IType lhs = this.fInvocationContext.getExpectedType();
        IType rhs = (IType)this.getJavaElement();
        if (lhs != null && rhs != null) {
            JavaPlugin.getDefault().getContentAssistHistory().remember(lhs, rhs);
        }
        QualifiedTypeNameHistory.remember(this.getQualifiedTypeName());
    }

    protected boolean allowAddingImports() {
        if (this.isInJavadoc()) {
            if (this.fProposal.getKind() == 9 && this.fInvocationContext.getCoreContext().isInJavadocText()) {
                return false;
            }
            if (!this.isJavadocProcessingEnabled()) {
                return false;
            }
        }
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("content_assist_add_import");
    }

    private boolean isJavadocProcessingEnabled() {
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        boolean processJavadoc = project == null ? "enabled".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.doc.comment.support")) : "enabled".equals(project.getOption("org.eclipse.jdt.core.compiler.doc.comment.support", true));
        return processJavadoc;
    }

    @Override
    protected boolean isValidPrefix(String prefix) {
        boolean isPrefix = this.isPrefix(prefix, this.getSimpleTypeName());
        if (!isPrefix && prefix.indexOf(46) != -1) {
            isPrefix = this.isPrefix(prefix, this.getQualifiedTypeName());
        }
        return isPrefix;
    }

    @Override
    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        String prefix = this.getPrefix(document, completionOffset);
        String completion = prefix.indexOf(46) != -1 ? this.getQualifiedTypeName() : this.getSimpleTypeName();
        if (this.isCamelCaseMatching()) {
            return this.getCamelCaseCompound(prefix, completion);
        }
        return completion;
    }

    @Override
    protected char[] computeTriggerCharacters() {
        return this.isInJavadoc() ? JDOC_TYPE_TRIGGERS : TYPE_TRIGGERS;
    }

    @Override
    protected ProposalInfo computeProposalInfo() {
        IJavaProject project = this.fCompilationUnit != null ? this.fCompilationUnit.getJavaProject() : this.fInvocationContext.getProject();
        if (project != null) {
            return new TypeProposalInfo(project, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    @Override
    protected String computeSortString() {
        return String.valueOf(this.getSimpleTypeName()) + '\u0000' + this.getQualifiedTypeName();
    }

    @Override
    protected int computeRelevance() {
        float rhsHistoryRank = this.fInvocationContext.getHistoryRelevance(this.getQualifiedTypeName());
        float typeHistoryRank = QualifiedTypeNameHistory.getDefault().getNormalizedPosition(this.getQualifiedTypeName());
        int recencyBoost = Math.round((rhsHistoryRank + typeHistoryRank) * 5.0f);
        int rhsBoost = rhsHistoryRank > 0.0f ? 50 : 0;
        int baseRelevance = super.computeRelevance();
        return baseRelevance + rhsBoost + recencyBoost;
    }

    @Override
    protected IContextInformation computeContextInformation() {
        char[] signature = this.fProposal.getSignature();
        char[][] typeParameters = Signature.getTypeArguments((char[])signature);
        if (typeParameters.length == 0) {
            return super.computeContextInformation();
        }
        ProposalContextInformation contextInformation = new ProposalContextInformation(this.fProposal);
        if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length == 0) {
            contextInformation.setContextInformationPosition(this.fContextInformationPosition);
        }
        return contextInformation;
    }
}

