/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.comparator;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.model.Messages;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiScopeVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiScope;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ApiScope
implements IApiScope {
    private static final IApiElement[] NO_ELEMENTS = new IApiElement[0];
    ArrayList<IApiElement> elements;

    @Override
    public void accept(ApiScopeVisitor visitor) throws CoreException {
        IApiElement[] elems;
        IApiElement[] iApiElementArray = elems = this.getApiElements();
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IApiElement apiElement = iApiElementArray[n2];
            int type = apiElement.getType();
            switch (type) {
                case 3: {
                    IApiTypeContainer container = (IApiTypeContainer)apiElement;
                    visitor.visit(container);
                    visitor.endVisit(container);
                    break;
                }
                case 7: {
                    IApiTypeRoot root = (IApiTypeRoot)apiElement;
                    visitor.visit(root);
                    visitor.endVisit(root);
                    break;
                }
                case 4: {
                    IApiBaseline baseline = (IApiBaseline)apiElement;
                    visitor.visit(baseline);
                    visitor.endVisit(baseline);
                    break;
                }
                case 1: {
                    IApiComponent component = (IApiComponent)apiElement;
                    visitor.visit(component);
                    visitor.endVisit(component);
                    break;
                }
                default: {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", NLS.bind((String)Messages.ApiScope_0, (Object)Util.getApiElementType(type))));
                }
            }
            ++n2;
        }
    }

    @Override
    public void addElement(IApiElement newelement) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        this.elements.add(newelement);
    }

    @Override
    public boolean encloses(IApiElement element) {
        if (element != null) {
            IApiComponent component = element.getApiComponent();
            IApiComponent enclosing = null;
            for (IApiElement iApiElement : this.elements) {
                enclosing = iApiElement.getApiComponent();
                if (!component.equals(enclosing)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IApiElement[] getApiElements() {
        if (this.elements == null || this.elements.size() == 0) {
            return NO_ELEMENTS;
        }
        return this.elements.toArray(new IApiElement[this.elements.size()]);
    }
}

