/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.InvalidTargetBundle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.TargetDefinitionPersistenceHelper;
import org.xml.sax.SAXException;

public class TargetDefinition
implements ITargetDefinition {
    private String fName;
    private NameVersionDescriptor[] fIncluded;
    private String fProgramArgs;
    private String fVMArgs;
    private IPath fJREContainer;
    private String fArch;
    private String fOS;
    private String fWS;
    private String fNL;
    private ITargetLocation[] fContainers;
    private ITargetHandle fHandle;
    private IStatus fResolutionStatus;
    private NameVersionDescriptor[] fImplicit;
    private int fUIMode = 0;
    public static final int MODE_PLUGIN = 0;
    public static final int MODE_FEATURE = 1;
    private Map<String, TargetFeature[]> fFeaturesInLocation = new HashMap<String, TargetFeature[]>();
    private TargetFeature[] fFeatures;
    private TargetBundle[] fOtherBundles;
    private int fSequenceNumber = -1;

    TargetDefinition(ITargetHandle handle) {
        this.fHandle = handle;
    }

    @Override
    public String getArch() {
        return this.fArch;
    }

    @Override
    public ITargetLocation[] getTargetLocations() {
        return this.fContainers;
    }

    @Override
    public String getNL() {
        return this.fNL;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getOS() {
        return this.fOS;
    }

    @Override
    public String getProgramArguments() {
        return this.fProgramArgs;
    }

    @Override
    public String getVMArguments() {
        return this.fVMArgs;
    }

    @Override
    public String getWS() {
        return this.fWS;
    }

    @Override
    public void setArch(String arch) {
        this.incrementSequenceNumber();
        this.fArch = arch;
    }

    @Override
    public void setNL(String nl) {
        this.incrementSequenceNumber();
        this.fNL = nl;
    }

    @Override
    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public void setOS(String os) {
        this.incrementSequenceNumber();
        this.fOS = os;
    }

    @Override
    public void setProgramArguments(String args) {
        if (args != null && args.length() == 0) {
            args = null;
        }
        this.fProgramArgs = args;
    }

    @Override
    public void setVMArguments(String args) {
        if (args != null && args.length() == 0) {
            args = null;
        }
        this.fVMArgs = args;
    }

    @Override
    public void setWS(String ws) {
        this.incrementSequenceNumber();
        this.fWS = ws;
    }

    @Override
    public void setTargetLocations(ITargetLocation[] locations) {
        this.incrementSequenceNumber();
        this.fFeatures = null;
        this.fOtherBundles = null;
        if (locations != null && locations.length == 0) {
            locations = null;
        }
        this.fContainers = locations;
        if (locations == null) {
            this.fIncluded = null;
        } else {
            int i = 0;
            while (i < locations.length) {
                if (locations[i] instanceof AbstractBundleContainer) {
                    ((AbstractBundleContainer)locations[i]).associateWithTarget(this);
                }
                ++i;
            }
        }
    }

    public void flushCaches(String location) {
        this.fFeatures = null;
        this.fOtherBundles = null;
        if (location == null) {
            this.fFeaturesInLocation.clear();
        } else {
            this.fFeaturesInLocation.remove(location);
        }
        if (this.fContainers == null) {
            this.fIncluded = null;
        }
    }

    @Override
    public IStatus resolve(IProgressMonitor monitor) {
        P2TargetUtils synchronizer;
        ITargetLocation[] containers = this.getTargetLocations();
        int num = 0;
        HashMap<P2TargetUtils, Integer> synchronizerNumContainerMap = new HashMap<P2TargetUtils, Integer>();
        if (containers != null) {
            num = containers.length;
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation element = iTargetLocationArray[n2];
                synchronizer = (P2TargetUtils)element.getAdapter(P2TargetUtils.class);
                if (synchronizer != null) {
                    if (!synchronizerNumContainerMap.containsKey(synchronizer)) {
                        synchronizerNumContainerMap.put(synchronizer, new Integer(1));
                    } else {
                        Integer numberIU = (Integer)synchronizerNumContainerMap.get(synchronizer);
                        synchronizerNumContainerMap.put(synchronizer, new Integer(numberIU + 1));
                    }
                }
                ++n2;
            }
        }
        this.fResolutionStatus = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.TargetDefinition_1, (int)(num * 100));
        try {
            MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_2, null);
            HashSet<P2TargetUtils> seen = new HashSet<P2TargetUtils>();
            if (containers != null) {
                int i = 0;
                while (i < containers.length) {
                    if (subMonitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    subMonitor.subTask(Messages.TargetDefinition_4);
                    synchronizer = (P2TargetUtils)containers[i].getAdapter(P2TargetUtils.class);
                    if (synchronizer != null && !seen.contains(synchronizer)) {
                        seen.add(synchronizer);
                        try {
                            synchronizer.synchronize(this, (IProgressMonitor)subMonitor.split((Integer)synchronizerNumContainerMap.get(synchronizer) * 95));
                        }
                        catch (CoreException e) {
                            status.add(e.getStatus());
                        }
                    }
                    ++i;
                }
                synchronizerNumContainerMap.clear();
                if (!status.isOK()) {
                    this.fResolutionStatus = status;
                    MultiStatus multiStatus = this.fResolutionStatus;
                    return multiStatus;
                }
                if (subMonitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                i = 0;
                while (i < containers.length) {
                    IStatus s;
                    if (subMonitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    subMonitor.subTask(Messages.TargetDefinition_4);
                    synchronizer = (P2TargetUtils)containers[i].getAdapter(P2TargetUtils.class);
                    int totalWork = 5;
                    if (synchronizer == null) {
                        totalWork = 100;
                    }
                    if (!(s = containers[i].resolve(this, (IProgressMonitor)subMonitor.split(totalWork))).isOK()) {
                        status.add(s);
                    }
                    ++i;
                }
            }
            if (status.isOK()) {
                IStatus iStatus = this.fResolutionStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (subMonitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.fResolutionStatus = status;
            MultiStatus multiStatus = this.fResolutionStatus;
            return multiStatus;
        }
        finally {
            subMonitor.done();
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public boolean isResolved() {
        ITargetLocation[] containers = this.getTargetLocations();
        if (containers != null) {
            int i = 0;
            while (i < containers.length) {
                ITargetLocation container = containers[i];
                if (!container.isResolved()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public IStatus getStatus() {
        if (this.fResolutionStatus != null && !this.fResolutionStatus.isOK()) {
            return this.fResolutionStatus;
        }
        if (this.isResolved()) {
            ITargetLocation[] containers = this.getTargetLocations();
            if (containers != null) {
                MultiStatus result = new MultiStatus("org.eclipse.pde.core", 0, Messages.TargetDefinition_5, null);
                int i = 0;
                while (i < containers.length) {
                    ITargetLocation container = containers[i];
                    IStatus containerStatus = container.getStatus();
                    if (containerStatus != null && !containerStatus.isOK()) {
                        result.add(containerStatus);
                    }
                    ++i;
                }
                TargetBundle[] bundles = this.getBundles();
                int i2 = 0;
                while (i2 < bundles.length) {
                    if (!bundles[i2].getStatus().isOK()) {
                        result.add(bundles[i2].getStatus());
                    }
                    ++i2;
                }
                if (result.isOK()) {
                    return Status.OK_STATUS;
                }
                return result;
            }
            return Status.OK_STATUS;
        }
        return null;
    }

    @Override
    public void setIncluded(NameVersionDescriptor[] included) {
        this.fIncluded = included;
    }

    @Override
    public NameVersionDescriptor[] getIncluded() {
        return this.fIncluded;
    }

    @Override
    public TargetBundle[] getBundles() {
        return this.getBundles(false);
    }

    @Override
    public TargetBundle[] getAllBundles() {
        return this.getBundles(true);
    }

    private TargetBundle[] getBundles(boolean allBundles) {
        if (this.isResolved()) {
            ITargetLocation[] containers = this.getTargetLocations();
            if (containers != null) {
                ArrayList<TargetBundle> all = new ArrayList<TargetBundle>();
                int i = 0;
                while (i < containers.length) {
                    ITargetLocation container = containers[i];
                    TargetBundle[] bundles = container.getBundles();
                    if (bundles != null) {
                        int j = 0;
                        while (j < bundles.length) {
                            TargetBundle rb = bundles[j];
                            all.add(rb);
                            ++j;
                        }
                    }
                    ++i;
                }
                TargetBundle[] allResolvedBundles = all.toArray(new TargetBundle[all.size()]);
                if (allBundles) {
                    return allResolvedBundles;
                }
                return this.filterBundles(allResolvedBundles, this.getIncluded());
            }
            return new TargetBundle[0];
        }
        return null;
    }

    private TargetBundle[] filterBundles(TargetBundle[] bundles, NameVersionDescriptor[] filter) {
        if (filter == null) {
            return bundles;
        }
        if (filter.length == 0) {
            return new TargetBundle[0];
        }
        boolean containsFeatures = false;
        ArrayList<NameVersionDescriptor> missingFeatures = new ArrayList<NameVersionDescriptor>();
        ArrayList<NameVersionDescriptor> included = new ArrayList<NameVersionDescriptor>();
        int i = 0;
        while (i < filter.length) {
            if (filter[i].getType() == "plugin") {
                included.add(filter[i]);
            } else if (filter[i].getType() == "feature") {
                containsFeatures = true;
                TargetFeature[] features = this.getAllFeatures();
                TargetFeature bestMatch = null;
                int j = 0;
                while (j < features.length) {
                    TargetFeature feature = features[j];
                    if (feature.getId().equals(filter[i].getId())) {
                        Version v2;
                        Version v1;
                        if (filter[i].getVersion() != null) {
                            if (filter[i].getVersion().equals(feature.getVersion())) {
                                bestMatch = feature;
                                break;
                            }
                        } else if (bestMatch != null && (v1 = Version.parseVersion((String)feature.getVersion())).compareTo((Object)(v2 = Version.parseVersion((String)bestMatch.getVersion()))) > 0) {
                            bestMatch = feature;
                        }
                        if (bestMatch == null) {
                            bestMatch = feature;
                        }
                    }
                    ++j;
                }
                if (bestMatch != null) {
                    NameVersionDescriptor[] plugins = bestMatch.getPlugins();
                    int j2 = 0;
                    while (j2 < plugins.length) {
                        included.add(plugins[j2]);
                        ++j2;
                    }
                } else {
                    missingFeatures.add(filter[i]);
                }
            }
            ++i;
        }
        List<TargetBundle> result = TargetDefinition.getMatchingBundles(bundles, included.toArray(new NameVersionDescriptor[included.size()]), !containsFeatures);
        if (containsFeatures && !missingFeatures.isEmpty()) {
            for (NameVersionDescriptor missing : missingFeatures) {
                BundleInfo info = new BundleInfo(missing.getId(), missing.getVersion(), null, -1, false);
                String message = NLS.bind((String)Messages.TargetDefinition_RequiredFeatureCouldNotBeFound, (Object)missing.getId());
                Status status = new Status(4, "org.eclipse.pde.core", 110, message, null);
                result.add(new InvalidTargetBundle(info, (IStatus)status));
            }
        }
        return result.toArray(new TargetBundle[result.size()]);
    }

    static List<TargetBundle> getMatchingBundles(TargetBundle[] collection, NameVersionDescriptor[] included, boolean handleMissingBundles) {
        if (included == null) {
            ArrayList<TargetBundle> result = new ArrayList<TargetBundle>();
            result.addAll(Arrays.asList(collection));
            return result;
        }
        HashMap<String, List<TargetBundle>> bundleMap = new HashMap<String, List<TargetBundle>>(collection.length);
        int i = 0;
        while (i < collection.length) {
            TargetBundle resolved = collection[i];
            ArrayList<TargetBundle> list = (ArrayList<TargetBundle>)bundleMap.get(resolved.getBundleInfo().getSymbolicName());
            if (list == null) {
                list = new ArrayList<TargetBundle>(3);
                bundleMap.put(resolved.getBundleInfo().getSymbolicName(), list);
            }
            list.add(resolved);
            ++i;
        }
        ArrayList<TargetBundle> resolved = new ArrayList<TargetBundle>();
        int i2 = 0;
        while (i2 < included.length) {
            BundleInfo info = new BundleInfo(included[i2].getId(), included[i2].getVersion(), null, -1, false);
            TargetBundle bundle = TargetDefinition.resolveBundle(bundleMap, info, handleMissingBundles);
            if (bundle != null) {
                resolved.add(bundle);
            }
            ++i2;
        }
        return resolved;
    }

    private static TargetBundle resolveBundle(Map<String, List<TargetBundle>> bundleMap, BundleInfo info, boolean handleMissingBundles) {
        List<TargetBundle> list = bundleMap.get(info.getSymbolicName());
        if (list != null) {
            String version = info.getVersion();
            if (version == null || version.equals("0.0.0")) {
                if (list.size() > 1) {
                    Collections.sort(list, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            BundleInfo b1 = ((TargetBundle)o1).getBundleInfo();
                            BundleInfo b2 = ((TargetBundle)o2).getBundleInfo();
                            try {
                                Version v1 = Version.create((String)b1.getVersion());
                                Version v2 = Version.create((String)b2.getVersion());
                                return v1.compareTo((Object)v2);
                            }
                            catch (IllegalArgumentException e) {
                                PDECore.log(e);
                                return b1.getVersion().compareTo(b2.getVersion());
                            }
                        }
                    });
                }
                TargetBundle rb = list.get(list.size() - 1);
                return rb;
            }
            for (TargetBundle bundle : list) {
                if (!bundle.getBundleInfo().getVersion().equals(version)) continue;
                return bundle;
            }
            if (!handleMissingBundles) {
                return null;
            }
            int sev = 4;
            String message = NLS.bind((String)Messages.AbstractBundleContainer_1, (Object[])new Object[]{info.getVersion(), info.getSymbolicName()});
            Status status = new Status(sev, "org.eclipse.pde.core", 101, message, null);
            return new InvalidTargetBundle(info, (IStatus)status);
        }
        if (!handleMissingBundles) {
            return null;
        }
        int sev = 4;
        String message = NLS.bind((String)Messages.AbstractBundleContainer_3, (Object)info.getSymbolicName());
        Status status = new Status(sev, "org.eclipse.pde.core", 100, message, null);
        return new InvalidTargetBundle(info, (IStatus)status);
    }

    @Override
    public ITargetHandle getHandle() {
        return this.fHandle;
    }

    void setContents(InputStream stream) throws CoreException {
        try {
            this.fArch = null;
            this.fContainers = null;
            this.fImplicit = null;
            this.fJREContainer = null;
            this.fIncluded = null;
            this.fName = null;
            this.fNL = null;
            this.fOS = null;
            this.fProgramArgs = null;
            this.fVMArgs = null;
            this.fWS = null;
            this.fSequenceNumber = 0;
            TargetDefinitionPersistenceHelper.initFromXML(this, stream);
        }
        catch (ParserConfigurationException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
        catch (SAXException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
        catch (IOException e) {
            this.abort(Messages.TargetDefinition_0, e);
        }
    }

    void write(OutputStream stream) throws CoreException {
        try {
            TargetDefinitionPersistenceHelper.persistXML(this, stream);
        }
        catch (IOException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
        catch (ParserConfigurationException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
        catch (TransformerException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
        catch (SAXException e) {
            this.abort(Messages.TargetDefinition_3, e);
        }
    }

    private void abort(String message, Exception e) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", message, (Throwable)e));
    }

    @Override
    public NameVersionDescriptor[] getImplicitDependencies() {
        return this.fImplicit;
    }

    @Override
    public void setImplicitDependencies(NameVersionDescriptor[] bundles) {
        if (bundles != null && bundles.length == 0) {
            bundles = null;
        }
        this.fImplicit = bundles;
    }

    @Override
    public IPath getJREContainer() {
        return this.fJREContainer;
    }

    @Override
    public void setJREContainer(IPath containerPath) {
        this.fJREContainer = containerPath;
    }

    public boolean isContentEqual(ITargetDefinition definition) {
        ITargetLocation[] c2;
        ITargetLocation[] c1;
        if (this.isNullOrEqual(this.getName(), definition.getName()) && this.isNullOrEqual(this.getArch(), definition.getArch()) && this.isNullOrEqual(this.getNL(), definition.getNL()) && this.isNullOrEqual(this.getOS(), definition.getOS()) && this.isNullOrEqual(this.getWS(), definition.getWS()) && this.isNullOrEqual(this.getProgramArguments(), definition.getProgramArguments()) && this.isNullOrEqual(this.getVMArguments(), definition.getVMArguments()) && this.isNullOrEqual(this.getJREContainer(), definition.getJREContainer()) && this.isNullOrEqual(this.getIncluded(), definition.getIncluded()) && this.areContainersEqual(c1 = this.getTargetLocations(), c2 = definition.getTargetLocations())) {
            return this.isNullOrEqual(this.getImplicitDependencies(), definition.getImplicitDependencies());
        }
        return false;
    }

    public boolean isContentEquivalent(ITargetDefinition definition) {
        ITargetLocation[] c2;
        ITargetLocation[] c1;
        if (this.isNullOrEqual(this.getArch(), definition.getArch()) && this.isNullOrEqual(this.getNL(), definition.getNL()) && this.isNullOrEqual(this.getOS(), definition.getOS()) && this.isNullOrEqual(this.getWS(), definition.getWS()) && this.isArgsNullOrEqual(this.getProgramArguments(), definition.getProgramArguments()) && this.isArgsNullOrEqual(this.getVMArguments(), definition.getVMArguments()) && this.isNullOrEqual(this.getJREContainer(), definition.getJREContainer()) && this.isNullOrEqual(this.getIncluded(), definition.getIncluded()) && this.areContainersEqual(c1 = this.getTargetLocations(), c2 = definition.getTargetLocations())) {
            return this.isNullOrEqual(this.getImplicitDependencies(), definition.getImplicitDependencies());
        }
        return false;
    }

    private boolean isNullOrEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    private boolean isNullOrEqual(Object[] objects1, Object[] objects2) {
        if (objects1 == null) {
            return objects2 == null;
        }
        if (objects2 == null) {
            return false;
        }
        if (objects1.length == objects2.length) {
            int i = 0;
            while (i < objects1.length) {
                if (!objects1[i].equals(objects2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean isArgsNullOrEqual(String args1, String args2) {
        String[] a2;
        if (args1 == null) {
            return args2 == null;
        }
        if (args2 == null) {
            return false;
        }
        String[] a1 = DebugPlugin.parseArguments((String)args1);
        if (a1.length == (a2 = DebugPlugin.parseArguments((String)args2)).length) {
            int i = 0;
            while (i < a1.length) {
                if (!a1[i].equals(a2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean areContainersEqual(ITargetLocation[] c1, ITargetLocation[] c2) {
        if (c1 == null) {
            return c2 == null;
        }
        if (c2 == null) {
            return false;
        }
        if (c1.length == c2.length) {
            int i = 0;
            while (i < c2.length) {
                if (!c1[i].equals(c2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.fName != null ? this.fName : "No Name");
        if (this.fContainers == null) {
            buf.append("\n\tNo containers");
        } else {
            int i = 0;
            while (i < this.fContainers.length) {
                buf.append("\n\t").append(this.fContainers[i].toString());
                ++i;
            }
        }
        buf.append("\nEnv: ").append(this.fOS).append("/").append(this.fWS).append("/").append(this.fArch).append("/").append(this.fNL);
        buf.append("\nJRE: ").append(this.fJREContainer);
        buf.append("\nArgs: ").append(this.fProgramArgs).append("/").append(this.fVMArgs);
        buf.append("\nImplicit: ").append(this.fImplicit == null ? "null" : Integer.toString(this.fImplicit.length));
        buf.append("\nHandle: ").append(this.fHandle.toString());
        return buf.toString();
    }

    public TargetFeature[] resolveFeatures(String locationPath, IProgressMonitor monitor) throws CoreException {
        String path = locationPath;
        if (path == null) {
            path = TargetPlatform.getDefaultLocation();
        } else {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            path = manager.performStringSubstitution(path);
        }
        TargetFeature[] models = null;
        if (this.fFeaturesInLocation != null) {
            models = this.fFeaturesInLocation.get(path);
        }
        if (models != null) {
            return models;
        }
        models = ExternalFeatureModelManager.createFeatures(path, new ArrayList(), monitor);
        this.fFeaturesInLocation.put(path, models);
        return models;
    }

    @Override
    public TargetFeature[] getAllFeatures() {
        if (!this.isResolved()) {
            return null;
        }
        if (this.fFeatures != null) {
            return this.fFeatures;
        }
        ITargetLocation[] containers = this.getTargetLocations();
        HashMap<NameVersionDescriptor, TargetFeature> result = new HashMap<NameVersionDescriptor, TargetFeature>();
        if (containers != null && containers.length > 0) {
            int i = 0;
            while (i < containers.length) {
                TargetFeature[] currentFeatures = containers[i].getFeatures();
                if (currentFeatures != null && currentFeatures.length > 0) {
                    int j = 0;
                    while (j < currentFeatures.length) {
                        TargetFeature feature = currentFeatures[j];
                        if (feature.getId() != null) {
                            NameVersionDescriptor key = new NameVersionDescriptor(feature.getId(), feature.getVersion());
                            result.put(key, feature);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.fFeatures = result.values().toArray(new TargetFeature[result.size()]);
        return this.fFeatures;
    }

    public TargetBundle[] getOtherBundles() {
        if (!this.isResolved()) {
            return null;
        }
        if (this.fOtherBundles != null) {
            return this.fOtherBundles;
        }
        TargetBundle[] allBundles = this.getAllBundles();
        HashMap<String, TargetBundle> remaining = new HashMap<String, TargetBundle>();
        int i = 0;
        while (i < allBundles.length) {
            remaining.put(allBundles[i].getBundleInfo().getSymbolicName(), allBundles[i]);
            ++i;
        }
        TargetFeature[] features = this.getAllFeatures();
        int i2 = 0;
        while (i2 < features.length) {
            NameVersionDescriptor[] plugins = features[i2].getPlugins();
            int j = 0;
            while (j < plugins.length) {
                remaining.remove(plugins[j].getId());
                ++j;
            }
            ++i2;
        }
        Collection values = remaining.values();
        this.fOtherBundles = values.toArray(new TargetBundle[values.size()]);
        return this.fOtherBundles;
    }

    public Set<Object> getFeaturesAndBundles() {
        if (!this.isResolved()) {
            return null;
        }
        TargetFeature[] allFeatures = this.getAllFeatures();
        TargetBundle[] allExtraBundles = this.getOtherBundles();
        NameVersionDescriptor[] included = this.getIncluded();
        if (included == null) {
            HashSet<Object> result = new HashSet<Object>();
            result.addAll(Arrays.asList(allFeatures));
            result.addAll(Arrays.asList(allExtraBundles));
            return result;
        }
        HashSet<Object> result = new HashSet<Object>();
        int i = 0;
        while (i < included.length) {
            int j;
            if (included[i].getType() == "plugin") {
                j = 0;
                while (j < allExtraBundles.length) {
                    if (allExtraBundles[j].getBundleInfo().getSymbolicName().equals(included[i].getId())) {
                        result.add(allExtraBundles[j]);
                    }
                    ++j;
                }
            } else if (included[i].getType() == "feature") {
                j = 0;
                while (j < allFeatures.length) {
                    if (allFeatures[j].getId().equals(included[i].getId())) {
                        result.add(allFeatures[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public int getUIMode() {
        return this.fUIMode;
    }

    public void setUIMode(int mode) {
        this.fUIMode = mode;
    }

    public int getSequenceNumber() {
        return this.fSequenceNumber;
    }

    public int incrementSequenceNumber() {
        return ++this.fSequenceNumber;
    }

    void setSequenceNumber(int value) {
        this.fSequenceNumber = value;
    }
}

