/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSImageView;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSStatusBar;
import org.eclipse.swt.internal.cocoa.NSStatusItem;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTImageView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    String toolTipText;
    boolean visible = true;
    boolean highlight;
    NSStatusItem item;
    NSImageView view;
    Image highlightImage;

    public TrayItem(Tray parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
        this.createWidget();
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        NSStatusBar statusBar = NSStatusBar.systemStatusBar();
        this.item = statusBar.statusItemWithLength(0.0);
        if (this.item == null) {
            this.error(2);
        }
        this.item.retain();
        this.item.setHighlightMode(true);
        this.view = (NSImageView)new SWTImageView().alloc();
        if (this.view == null) {
            this.error(2);
        }
        this.view.init();
        this.item.setView(this.view);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
        this.display.removeWidget(this.view.cell());
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Image getHighlightImage() {
        this.checkWidget();
        return this.highlightImage;
    }

    Point getLocation() {
        NSRect rect = this.view.frame();
        NSRect windowRect = this.view.window().frame();
        NSPoint pt = new NSPoint();
        pt.x = rect.width / 2.0;
        pt = this.view.convertPoint_fromView_(pt, null);
        pt.x += windowRect.x;
        return new Point((int)pt.x, (int)pt.y);
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
        this.display.addWidget(this.view.cell(), this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        if (this.item != null) {
            this.item.release();
        }
        if (this.view != null) {
            this.view.release();
        }
        this.item = null;
        this.view = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        NSStatusBar statusBar = NSStatusBar.systemStatusBar();
        statusBar.removeStatusItem(this.item);
        if (this.toolTip != null) {
            this.toolTip.item = null;
        }
        this.toolTip = null;
        this.toolTipText = null;
        this.highlightImage = null;
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        this.updateImage();
    }

    public void setHighlightImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.highlightImage = image;
        this.updateImage();
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip oldTip = this.toolTip;
        ToolTip newTip = toolTip;
        if (oldTip != null) {
            oldTip.item = null;
        }
        this.toolTip = newTip;
        if (newTip != null) {
            newTip.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this._setToolTipText(string);
    }

    void _setToolTipText(String string) {
        if (string != null) {
            char[] chars = new char[string.length()];
            string.getChars(0, chars.length, chars, 0);
            int length = this.fixMnemonic(chars);
            NSString str = NSString.stringWithCharacters(chars, length);
            this.view.setToolTip(str);
        } else {
            this.view.setToolTip(null);
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.visible == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        this.visible = visible;
        this.updateImage();
        if (!visible) {
            this.sendEvent(23);
        }
    }

    void showMenu(Menu menu) {
        this.display.trayItemMenu = menu;
        this.item.popUpStatusItemMenu(menu.nsMenu);
    }

    void showMenu() {
        this._setToolTipText(null);
        Display display = this.display;
        display.currentTrayItem = this;
        this.sendEvent(35);
        if (!this.isDisposed()) {
            display.runPopups();
        }
        display.currentTrayItem = null;
        if (this.isDisposed()) {
            return;
        }
        this._setToolTipText(this.toolTipText);
    }

    void displayMenu() {
        if (this.highlight) {
            this.view.display();
            this.display.trayItemMenu = null;
            this.showMenu();
            if (this.display.trayItemMenu != null) {
                this.display.trayItemMenu = null;
                this.highlight = false;
                this.view.setNeedsDisplay(true);
            }
        }
    }

    boolean shouldShowMenu(NSEvent event) {
        if (!this.hooks(35)) {
            return false;
        }
        switch ((int)event.type()) {
            case 3: {
                return true;
            }
            case 1: {
                if (!this.hooks(13) && !this.hooks(14)) {
                    return true;
                }
                return (event.modifierFlags() & 0xFFFF0000L) == 262144L;
            }
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    void mouseDown(long id2, long sel, long theEvent) {
        NSEvent nsEvent = new NSEvent(theEvent);
        this.highlight = true;
        this.updateImage();
        this.view.setNeedsDisplay(true);
        if (this.shouldShowMenu(nsEvent)) {
            this.displayMenu();
            this.updateImage();
        }
    }

    void mouseDragged(long id2, long sel, long theEvent) {
        NSEvent nsEvent = new NSEvent(theEvent);
        NSRect frame = this.view.frame();
        boolean oldHighlight = this.highlight;
        this.highlight = OS.NSPointInRect(nsEvent.locationInWindow(), frame);
        if (oldHighlight != this.highlight) {
            this.updateImage();
        }
        this.view.setNeedsDisplay(true);
        if (this.shouldShowMenu(nsEvent)) {
            this.displayMenu();
            this.updateImage();
        }
    }

    void mouseUp(long id2, long sel, long theEvent) {
        if (this.highlight) {
            NSEvent nsEvent = new NSEvent(theEvent);
            if (nsEvent.type() == 2L) {
                this.sendSelectionEvent(nsEvent.clickCount() == 2L ? 14 : 13);
            }
            this.highlight = false;
            this.updateImage();
        }
        this.view.setNeedsDisplay(true);
    }

    void rightMouseDown(long id2, long sel, long theEvent) {
        this.mouseDown(id2, sel, theEvent);
    }

    void rightMouseUp(long id2, long sel, long theEvent) {
        this.mouseUp(id2, sel, theEvent);
    }

    void rightMouseDragged(long id2, long sel, long theEvent) {
        this.mouseDragged(id2, sel, theEvent);
    }

    void drawRect(long id2, long sel, NSRect rect) {
        this.item.drawStatusBarBackgroundInRect(rect, this.highlight);
        super.drawRect(id2, sel, rect);
    }

    void updateImage() {
        double width = 0.0;
        Image image = this.image;
        if (this.highlight && this.highlightImage != null) {
            image = this.highlightImage;
        }
        if (image == null) {
            this.view.setImage(null);
        } else {
            this.view.setImage(image.handle);
            this.view.setNeedsDisplay(true);
            if (this.visible) {
                width = -2.0;
            }
        }
        this.item.setLength(width);
    }
}

