/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.MultiOperation;
import org.eclipse.wst.jsdt.internal.core.Region;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class DeleteElementsOperation
extends MultiOperation {
    protected Map childrenToRemove;
    protected ASTParser parser;

    public DeleteElementsOperation(IJavaScriptElement[] elementsToDelete, boolean force) {
        super(elementsToDelete, force);
        this.initASTParser();
    }

    private void deleteElement(IJavaScriptElement elementToRemove, IJavaScriptUnit cu) throws JavaScriptModelException {
        cu.makeConsistent(this.progressMonitor);
        this.parser.setSource(cu);
        JavaScriptUnit astCU = (JavaScriptUnit)this.parser.createAST(this.progressMonitor);
        ASTNode node = ((JavaElement)elementToRemove).findNode(astCU);
        if (node == null) {
            Assert.isTrue((boolean)false, (String)("Failed to locate " + elementToRemove.getElementName() + " in " + cu.getElementName()));
        }
        IDocument document = this.getDocument(cu);
        AST ast = astCU.getAST();
        ASTRewrite rewriter = ASTRewrite.create(ast);
        rewriter.remove(node, null);
        TextEdit edits = rewriter.rewriteAST(document, null);
        try {
            edits.apply(document);
        }
        catch (BadLocationException e) {
            throw new JavaScriptModelException(e, 984);
        }
    }

    private void initASTParser() {
        this.parser = ASTParser.newParser(3);
    }

    @Override
    protected String getMainTaskName() {
        return Messages.operation_deleteElementProgress;
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        IResource resource;
        if (this.elementsToProcess != null && this.elementsToProcess.length == 1 && (resource = this.elementsToProcess[0].getResource()) != null) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule(resource);
        }
        return super.getSchedulingRule();
    }

    protected void groupElements() throws JavaScriptModelException {
        this.childrenToRemove = new HashMap(1);
        int uniqueCUs = 0;
        int i = 0;
        int length = this.elementsToProcess.length;
        while (i < length) {
            IJavaScriptElement e = this.elementsToProcess[i];
            IJavaScriptUnit cu = this.getCompilationUnitFor(e);
            if (cu == null) {
                throw new JavaScriptModelException(new JavaModelStatus(976, e));
            }
            IRegion region = (IRegion)this.childrenToRemove.get(cu);
            if (region == null) {
                region = new Region();
                this.childrenToRemove.put(cu, region);
                ++uniqueCUs;
            }
            region.add(e);
            ++i;
        }
        this.elementsToProcess = new IJavaScriptElement[uniqueCUs];
        Iterator iter = this.childrenToRemove.keySet().iterator();
        int i2 = 0;
        while (iter.hasNext()) {
            this.elementsToProcess[i2++] = (IJavaScriptElement)iter.next();
        }
    }

    @Override
    protected void processElement(IJavaScriptElement element) throws JavaScriptModelException {
        IJavaScriptUnit cu = (IJavaScriptUnit)element;
        int numberOfImports = cu.getImports().length;
        JavaElementDelta delta = new JavaElementDelta(cu);
        IJavaScriptElement[] cuElements = ((IRegion)this.childrenToRemove.get(cu)).getElements();
        int i = 0;
        int length = cuElements.length;
        while (i < length) {
            IJavaScriptElement e = cuElements[i];
            if (e.exists()) {
                this.deleteElement(e, cu);
                delta.removed(e);
                if (e.getElementType() == 13 && --numberOfImports == 0) {
                    delta.removed(cu.getImportContainer());
                }
            }
            ++i;
        }
        if (delta.getAffectedChildren().length > 0) {
            cu.save(this.getSubProgressMonitor(1), this.force);
            if (!cu.isWorkingCopy()) {
                this.addDelta(delta);
                DeleteElementsOperation.setAttribute("hasModifiedResource", "true");
            }
        }
    }

    @Override
    protected void processElements() throws JavaScriptModelException {
        this.groupElements();
        super.processElements();
    }

    @Override
    protected void verify(IJavaScriptElement element) throws JavaScriptModelException {
        IJavaScriptElement[] children = ((IRegion)this.childrenToRemove.get(element)).getElements();
        int i = 0;
        while (i < children.length) {
            IJavaScriptElement child = children[i];
            if (child.getCorrespondingResource() != null) {
                this.error(967, child);
            }
            if (child.isReadOnly()) {
                this.error(976, child);
            }
            ++i;
        }
    }
}

