/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.messageproperties.Property;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.AddPropertyCommand;
import org.eclipse.bpel.ui.commands.RemovePropertyCommand;
import org.eclipse.bpel.ui.commands.ReplacePropertyCommand;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.details.providers.ColumnTableProvider;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.details.providers.PropertyContentProvider;
import org.eclipse.bpel.ui.details.providers.UnusedPropertyFilter;
import org.eclipse.bpel.ui.dialogs.EditMessagePropertyDialog;
import org.eclipse.bpel.ui.dialogs.PropertySelectorDialog;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class CorrSetImplSection
extends BPELPropertySection {
    protected Table propertyTable;
    protected TableViewer propertyViewer;
    protected ColumnTableProvider tableProvider;
    protected Button addButton;
    protected Button editButton;
    protected Button removeButton;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected boolean isPropertyListAffected(Notification n) {
        return n.getFeatureID(CorrelationSet.class) == 5;
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                if (CorrSetImplSection.this.isPropertyListAffected(n)) {
                    CorrSetImplSection.this.updatePropertyWidgets(null);
                    CorrSetImplSection.this.refreshAdapters();
                }
            }
        }, new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                if (n.getNotifier() instanceof Property) {
                    CorrSetImplSection.this.updatePropertyWidgets((Property)n.getNotifier());
                    CorrSetImplSection.this.refreshAdapters();
                }
            }
        }};
    }

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        EList corrList = ((CorrelationSet)this.getInput()).getProperties();
        for (Property property : corrList) {
            this.fAdapters[1].addToObject((Notifier)property);
        }
    }

    protected void createPropertyWidgets(Composite composite) {
        Label correlationSetLabel = this.fWidgetFactory.createLabel(composite, Messages.CorrSetImplDetails_Properties__5);
        this.propertyTable = this.fWidgetFactory.createTable(composite, 66048);
        this.addButton = this.fWidgetFactory.createButton(composite, Messages.CorrSetImplDetails_Browse____6, 8);
        this.editButton = this.fWidgetFactory.createButton(composite, Messages.CorrSetImplDetails_Edit____7, 8);
        this.removeButton = this.fWidgetFactory.createButton(composite, Messages.CorrSetImplDetails_Remove_4, 8);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.top = new FlatFormAttachment(0, 0);
        correlationSetLabel.setLayoutData((Object)data);
        data = new FlatFormData();
        data.width = BPELUtil.calculateButtonWidth((Widget)this.addButton, 60);
        data.right = new FlatFormAttachment((Control)this.editButton, -5);
        data.top = new FlatFormAttachment(0, 0);
        this.addButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.width = BPELUtil.calculateButtonWidth((Widget)this.editButton, 60);
        data.right = new FlatFormAttachment((Control)this.removeButton, -5);
        data.top = new FlatFormAttachment(0, 0);
        this.editButton.setLayoutData((Object)data);
        this.editButton.setEnabled(false);
        data = new FlatFormData();
        data.width = BPELUtil.calculateButtonWidth((Widget)this.removeButton, 60);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment(0, 0);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Property property;
                PropertySelectorDialog dialog = new PropertySelectorDialog(CorrSetImplSection.this.getPart().getSite().getShell(), (CorrelationSet)CorrSetImplSection.this.getInput(), CorrSetImplSection.this.fWidgetFactory);
                if (dialog.open() == 0 && (property = dialog.getProperty()) != null) {
                    AddPropertyCommand cmd = new AddPropertyCommand((CorrelationSet)CorrSetImplSection.this.getInput(), property);
                    CorrSetImplSection.this.getCommandFramework().execute(CorrSetImplSection.this.wrapInShowContextCommand((Command)cmd));
                    CorrSetImplSection.this.propertyViewer.setSelection((ISelection)new StructuredSelection((Object)property));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BPELEditor bpelEditor;
                Shell shell;
                EditMessagePropertyDialog dialog;
                int rtn;
                IStructuredSelection sel = (IStructuredSelection)CorrSetImplSection.this.propertyViewer.getSelection();
                Property property = (Property)sel.getFirstElement();
                if (property != null && (rtn = (dialog = new EditMessagePropertyDialog(shell = (bpelEditor = CorrSetImplSection.this.getBPELEditor()).getEditorSite().getShell(), property, null, bpelEditor, CorrSetImplSection.this.fWidgetFactory)).open()) == 0 && property != null && dialog.getProperty() != null) {
                    AutoUndoCommand cmd;
                    if (property.eIsProxy()) {
                        cmd = new RemovePropertyCommand((CorrelationSet)CorrSetImplSection.this.getInput(), property);
                        CorrSetImplSection.this.getCommandFramework().execute(CorrSetImplSection.this.wrapInShowContextCommand((Command)cmd));
                        property = dialog.getProperty();
                    }
                    cmd = new AddPropertyCommand((CorrelationSet)CorrSetImplSection.this.getInput(), property);
                    CorrSetImplSection.this.getCommandFramework().execute(CorrSetImplSection.this.wrapInShowContextCommand((Command)cmd));
                    CorrSetImplSection.this.propertyViewer.setSelection((ISelection)new StructuredSelection((Object)property));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Listener removeListener = new Listener(){

            public void handleEvent(Event e) {
                int items;
                if (e.type == 2 && e.character != '\u007f') {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)CorrSetImplSection.this.propertyViewer.getSelection();
                Property property = (Property)sel.getFirstElement();
                int selectionIndex = CorrSetImplSection.this.propertyTable.getSelectionIndex();
                if (property != null) {
                    RemovePropertyCommand cmd = new RemovePropertyCommand((CorrelationSet)CorrSetImplSection.this.getInput(), property);
                    CorrSetImplSection.this.getCommandFramework().execute(CorrSetImplSection.this.wrapInShowContextCommand((Command)cmd));
                }
                if ((items = CorrSetImplSection.this.propertyTable.getItemCount()) > 0) {
                    selectionIndex = selectionIndex < items ? selectionIndex : items - 1;
                    CorrSetImplSection.this.propertyTable.setSelection(selectionIndex);
                }
                CorrSetImplSection.this.updateButtonEnablement();
            }
        };
        this.removeButton.addListener(13, removeListener);
        this.removeButton.addListener(14, removeListener);
        this.propertyTable.addListener(2, removeListener);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.addButton, 4);
        data.bottom = new FlatFormAttachment(100, 0);
        this.propertyTable.setLayoutData((Object)data);
        this.propertyTable.setLinesVisible(true);
        this.propertyTable.setHeaderVisible(true);
        this.tableProvider = new ColumnTableProvider();
        this.tableProvider.add(new NameColumn());
        this.propertyViewer = new TableViewer(this.propertyTable);
        this.tableProvider.createTableLayout(this.propertyTable);
        this.propertyViewer.setLabelProvider((IBaseLabelProvider)this.tableProvider);
        this.propertyViewer.setCellModifier((ICellModifier)this.tableProvider);
        this.propertyViewer.setContentProvider((IContentProvider)new PropertyContentProvider());
        this.propertyViewer.setColumnProperties(this.tableProvider.getColumnProperties());
        this.propertyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CorrSetImplSection.this.updateButtonEnablement();
            }
        });
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        this.createPropertyWidgets(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.bpel.ui.property_correlation_set");
    }

    protected void updateButtonEnablement() {
        boolean hasSelection = !this.propertyViewer.getSelection().isEmpty();
        this.removeButton.setEnabled(hasSelection);
        this.editButton.setEnabled(hasSelection);
    }

    protected void updatePropertyWidgets(final Property property) {
        Object input = this.getInput();
        if (input == null) {
            throw new IllegalStateException();
        }
        this.propertyViewer.setInput(this.getInput());
        this.propertyViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (property != null) {
                    CorrSetImplSection.this.propertyViewer.refresh((Object)property, true);
                } else {
                    CorrSetImplSection.this.propertyViewer.refresh();
                }
            }
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updatePropertyWidgets(null);
    }

    @Override
    public Object getUserContext() {
        return ((StructuredSelection)this.propertyViewer.getSelection()).getFirstElement();
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.propertyTable.setFocus();
        if (userContext != null) {
            this.propertyViewer.setSelection((ISelection)new StructuredSelection(userContext));
        }
    }

    public class NameColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider,
    ICellModifier {
        ModelLabelProvider labelProvider = new ModelLabelProvider();
        UnusedPropertyFilter propertyFilter = new UnusedPropertyFilter();

        @Override
        public String getHeaderText() {
            return Messages.CorrSetImplDetails_Property_1;
        }

        @Override
        public String getProperty() {
            return "propertyName";
        }

        @Override
        public int getInitialWeight() {
            return 100;
        }

        @Override
        public CellEditor createCellEditor(Composite parent) {
            return null;
        }

        public String getText(Object element) {
            return this.labelProvider.getText(element);
        }

        public boolean canModify(Object element, String property) {
            this.propertyFilter.setCandidates((Collection)((CorrelationSet)CorrSetImplSection.this.getInput()).getProperties(), Collections.singletonList(element));
            return false;
        }

        public Object getValue(Object element, String property) {
            return element;
        }

        public void modify(Object element, String property, Object value) {
            ReplacePropertyCommand cmd = new ReplacePropertyCommand((CorrelationSet)CorrSetImplSection.this.getInput(), (Property)element, (Property)value);
            CorrSetImplSection.this.getCommandFramework().execute(CorrSetImplSection.this.wrapInShowContextCommand((Command)cmd));
        }
    }
}

