/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.ArrayList;
import org.eclipse.bpel.common.ui.details.widgets.DecoratedLabel;
import org.eclipse.bpel.common.ui.details.widgets.StatusLabel2;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.Condition;
import org.eclipse.bpel.model.Expression;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.details.providers.ExpressionEditorDescriptorContentProvider;
import org.eclipse.bpel.ui.expressions.IExpressionEditor;
import org.eclipse.bpel.ui.extensions.BPELUIRegistry;
import org.eclipse.bpel.ui.extensions.ExpressionEditorDescriptor;
import org.eclipse.bpel.ui.properties.TextSection;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ExpressionSection
extends TextSection {
    protected String editorLanguage;
    protected ComboViewer expressionLanguageViewer;
    protected ExpressionComboContentProvider expressionComboContentProvider;
    protected Composite fEditorArea;
    protected static final Object NO_EXPRESSION = new Object();
    protected static final Object SAME_AS_PARENT = new Object();
    protected Composite fNoEditorWidgets;
    protected Composite fParentComposite;
    protected Font boldFont;
    protected String title;
    protected Label titleLabel;
    StackLayout fEditorAreaStackLayout;
    Composite fEditorComposite;
    protected StatusLabel2 expressionLanguageLabel;
    protected EStructuralFeature fStructuralFeature;
    protected Button fCreateExpressionButton;
    Combo expressionLanguageCombo;

    protected static boolean objectsEqual(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        return lhs.equals(rhs);
    }

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        Expression e = this.getExprFromModel();
        if (e != null) {
            this.fAdapters[0].addToObject((Notifier)e);
        }
    }

    @Override
    protected void disposeEditor() {
        super.disposeEditor();
        this.editorLanguage = null;
        if (this.fEditorComposite != null) {
            this.fEditorComposite.dispose();
            this.fEditorComposite = null;
        }
    }

    protected Object getDefaultBody(String newLanguage, String exprType) {
        IExpressionEditor ed = null;
        try {
            newLanguage = this.getEffectiveLanguage(newLanguage);
            ed = BPELUIRegistry.getInstance().getExpressionEditor(newLanguage);
        }
        catch (CoreException e) {
            BPELUIPlugin.log(e);
            return "";
        }
        ed.setExpressionType(exprType);
        ed.setModelObject(this.getInput());
        return ed.getDefaultContent();
    }

    protected void createTitleWidgets(Composite composite) {
        this.titleLabel = this.fWidgetFactory.createLabel(composite, this.title);
        this.titleLabel.setFont(this.boldFont);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.top = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        this.titleLabel.setLayoutData((Object)data);
    }

    protected void createExpressionLanguageWidgets(Composite composite) {
        DecoratedLabel nameLabel = new DecoratedLabel(composite, 16384);
        this.fWidgetFactory.adapt((Composite)nameLabel);
        nameLabel.setText(Messages.ExpressionSection_Expression_language_1);
        this.expressionLanguageLabel = new StatusLabel2(nameLabel);
        this.expressionLanguageCombo = new Combo(composite, 0x800008);
        this.fWidgetFactory.adapt((Composite)this.expressionLanguageCombo);
        this.expressionLanguageViewer = new ComboViewer(this.expressionLanguageCombo);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)nameLabel, 157));
        data.right = new FlatFormAttachment(100, 0);
        data.top = this.title != null ? new FlatFormAttachment((Control)this.titleLabel, 4) : new FlatFormAttachment(0, 0);
        this.expressionLanguageViewer.getControl().setLayoutData((Object)data);
        this.expressionLanguageViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == NO_EXPRESSION) {
                    return Messages.ExpressionSection_No_Expression_2;
                }
                if (element == SAME_AS_PARENT) {
                    ExpressionEditorDescriptor descriptor;
                    String text = ExpressionSection.this.getBPELEditor().getProcess().getExpressionLanguage();
                    if (text == null) {
                        text = "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0";
                    }
                    if ((descriptor = BPELUIRegistry.getInstance().getExpressionEditorDescriptor(text)) != null) {
                        text = descriptor.getLabel();
                    }
                    return NLS.bind((String)Messages.ExpressionSection_Same_as_Process_1, (Object[])new Object[]{text});
                }
                if (element instanceof String) {
                    return (String)element;
                }
                ExpressionEditorDescriptor descriptor = (ExpressionEditorDescriptor)element;
                String text = descriptor.getLabel();
                return text != null ? text : descriptor.getExpressionLanguage();
            }
        });
        this.expressionComboContentProvider = new ExpressionComboContentProvider();
        this.expressionLanguageViewer.setContentProvider((IContentProvider)this.expressionComboContentProvider);
        this.expressionLanguageViewer.setInput(SAME_AS_PARENT);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(this.expressionLanguageViewer.getControl(), -5);
        data.top = new FlatFormAttachment(this.expressionLanguageViewer.getControl(), 0, 0x1000000);
        this.expressionLanguageLabel.setLayoutData((Object)data);
        this.expressionLanguageCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ExpressionSection.this.updateFromSelection(ExpressionSection.this.selectedExpressionLanguage());
            }
        });
    }

    protected void updateFromSelection(Object elm) {
        SetCommand cmd;
        if (elm == NO_EXPRESSION || elm == null) {
            cmd = new SetCommand(this.getExpressionTarget(), null, this.getStructuralFeature());
        } else {
            String language = this.getExpressionLanguage(elm);
            Condition exp = BPELFactory.eINSTANCE.createCondition();
            exp.setExpressionLanguage(language);
            Object newDefaultBody = this.getDefaultBody(language, this.getExpressionType());
            exp.setBody(newDefaultBody);
            cmd = new SetCommand(this.getExpressionTarget(), this.getExpression4Target((Expression)exp), this.getStructuralFeature());
        }
        this.getCommandFramework().execute(this.wrapInShowContextCommand((Command)cmd));
    }

    protected Object selectedExpressionLanguage() {
        IStructuredSelection selection = (IStructuredSelection)this.expressionLanguageViewer.getSelection();
        return selection.getFirstElement();
    }

    protected void doChooseExpressionLanguage(Object model) {
        Object selection = this.selectedExpressionLanguage();
        if (selection == model) {
            return;
        }
        this.expressionLanguageViewer.setSelection((ISelection)new StructuredSelection(model), true);
        this.updateFromSelection(this.selectedExpressionLanguage());
    }

    protected void updateExpressionLanguageWidgets() {
        Object model = NO_EXPRESSION;
        if (this.getExprFromModel() != null) {
            String language = this.getExpressionLanguageFromModel();
            if (language == null) {
                model = SAME_AS_PARENT;
            } else {
                model = BPELUIRegistry.getInstance().getExpressionEditorDescriptor(language);
                if (model == null) {
                    model = language;
                }
            }
        }
        this.expressionLanguageViewer.setSelection((ISelection)new StructuredSelection(model), true);
        this.updateEditor();
        this.updateMarkers();
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        this.setStructuralFeature(this.getStructuralFeature(newInput));
        this.expressionLanguageViewer.refresh(true);
        this.updateExpressionLanguageWidgets();
    }

    protected void setStructuralFeature(EStructuralFeature feature) {
        this.fStructuralFeature = feature;
    }

    protected EStructuralFeature getStructuralFeature(EObject eObject) {
        return null;
    }

    protected EStructuralFeature getStructuralFeature() {
        return this.fStructuralFeature;
    }

    protected boolean isExpressionOptional() {
        return true;
    }

    protected String getExpressionType() {
        return "any";
    }

    protected EObject getExpressionTarget() {
        return this.getInput();
    }

    protected String getExpressionLanguage(Object comboElement) {
        if (comboElement == NO_EXPRESSION || comboElement == SAME_AS_PARENT) {
            return null;
        }
        String language = null;
        if (comboElement instanceof ExpressionEditorDescriptor) {
            language = ((ExpressionEditorDescriptor)comboElement).getExpressionLanguage();
        } else if (comboElement instanceof String) {
            language = (String)comboElement;
        }
        if ("".equals(language)) {
            language = null;
        }
        return language;
    }

    protected String getEffectiveLanguage(String language) {
        if (language == null && (language = this.getBPELEditor().getProcess().getExpressionLanguage()) == null) {
            language = "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0";
        }
        return language;
    }

    protected String getExpressionLanguageFromModel() {
        Expression expression = this.getExprFromModel();
        if (expression == null) {
            return null;
        }
        return expression.getExpressionLanguage();
    }

    protected Expression getExprFromModel() {
        Object result;
        EObject target = this.getExpressionTarget();
        if (target != null && (result = target.eGet(this.getStructuralFeature())) instanceof Expression) {
            return (Expression)result;
        }
        return null;
    }

    protected Expression getExpression4Target(Expression expression) {
        return expression;
    }

    @Override
    protected boolean isBodyAffected(Notification n) {
        if (n.getOldValue() instanceof Expression || n.getNewValue() instanceof Expression || n.getNotifier() instanceof Expression) {
            return true;
        }
        return n.getFeature() == this.getStructuralFeature();
    }

    @Override
    protected Command newStoreToModelCommand(Object body) {
        CompoundCommand result = new CompoundCommand();
        Expression oldExp = this.getExprFromModel();
        Condition exp = BPELFactory.eINSTANCE.createCondition();
        if (oldExp != null) {
            exp.setExpressionLanguage(oldExp.getExpressionLanguage());
        }
        exp.setBody(body);
        result.add((Command)new SetCommand(this.getExpressionTarget(), this.getExpression4Target((Expression)exp), this.getStructuralFeature()));
        this.fEditor.addExtraStoreCommands(result);
        return result;
    }

    @Override
    protected void createClient(Composite parent) {
        this.fParentComposite = this.createFlatFormComposite(parent);
        if (this.title != null) {
            this.createBoldFont(this.fParentComposite);
            this.createTitleWidgets(this.fParentComposite);
        }
        this.createExpressionLanguageWidgets(this.fParentComposite);
        FlatFormData data = new FlatFormData();
        data.top = new FlatFormAttachment(this.expressionLanguageViewer.getControl(), 4);
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        this.fEditorArea = this.fWidgetFactory.createComposite(this.fParentComposite);
        this.fEditorAreaStackLayout = new StackLayout();
        this.fEditorArea.setLayout((Layout)this.fEditorAreaStackLayout);
        this.fEditorArea.setLayoutData((Object)data);
        this.fNoEditorWidgets = this.createNoEditorWidgets(this.fEditorArea);
        this.fEditorAreaStackLayout.topControl = this.fNoEditorWidgets;
        this.createChangeHelper();
    }

    protected Composite createNoEditorWidgets(Composite composite) {
        return this.fWidgetFactory.createComposite(composite);
    }

    protected Composite createNoEditorWidgetsCreateComposite(Composite composite, String message, String buttonMessage) {
        Composite section = this.createFlatFormComposite(composite);
        Label label = this.fWidgetFactory.createLabel(section, "", 72);
        FlatFormData ffdata = new FlatFormData();
        ffdata.left = new FlatFormAttachment(0, 4);
        ffdata.top = new FlatFormAttachment(0, 8);
        ffdata.right = new FlatFormAttachment(100, 0);
        label.setLayoutData((Object)ffdata);
        this.fCreateExpressionButton = this.fWidgetFactory.createButton(section, buttonMessage, 8);
        ffdata = new FlatFormData();
        ffdata.left = new FlatFormAttachment(0, 4);
        ffdata.top = new FlatFormAttachment((Control)label, 8);
        this.fCreateExpressionButton.setLayoutData((Object)ffdata);
        this.fCreateExpressionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionSection.this.doChooseExpressionLanguage(SAME_AS_PARENT);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label.setText(message);
        return section;
    }

    @Override
    protected void createEditor(Composite parent) {
        String language = this.getEffectiveLanguage(this.getExpressionLanguageFromModel());
        try {
            this.fEditor = BPELUIRegistry.getInstance().getExpressionEditor(language);
        }
        catch (CoreException e) {
            BPELUIPlugin.log(e);
            return;
        }
        this.editorLanguage = language;
        this.fEditor.createControls(parent, (FormToolkit)this.getWidgetFactory());
        this.fEditor.addListener(new IExpressionEditor.Listener(){

            @Override
            public void notifyChanged() {
                if (!ExpressionSection.this.updating) {
                    ExpressionSection.this.notifyEditorChanged();
                }
            }

            @Override
            public void focusOut() {
                ExpressionSection.this.getCommandFramework().applyCurrentChange();
            }

            @Override
            public void focusIn() {
            }
        });
    }

    @Override
    protected void updateEditor() {
        Expression expr = this.getExprFromModel();
        Control previousTop = this.fEditorAreaStackLayout.topControl;
        if (expr == null) {
            this.fEditorAreaStackLayout.topControl = this.fNoEditorWidgets;
        } else {
            String newLanguage = this.getEffectiveLanguage(this.getExpressionLanguageFromModel());
            if (!newLanguage.equals(this.editorLanguage) || !this.hasEditor()) {
                this.disposeEditor();
                this.fEditorComposite = this.fWidgetFactory.createComposite(this.fEditorArea);
                this.fEditorComposite.setLayout((Layout)new FillLayout());
                this.createEditor(this.fEditorComposite);
            }
            this.fEditorAreaStackLayout.topControl = this.fEditorComposite;
            this.fEditor.setExpressionType(this.getExpressionType());
            this.fEditor.setModelObject(this.getInput());
            this.fEditor.setEditorContent((String)expr.getBody());
            this.fEditor.aboutToBeShown();
        }
        if (previousTop != this.fEditorAreaStackLayout.topControl) {
            this.fEditorArea.layout(new Control[]{this.fEditorAreaStackLayout.topControl});
        }
    }

    protected boolean isEditorSupported(IExpressionEditor exEditor) {
        return exEditor.supportsExpressionType(this.getExpressionType());
    }

    protected boolean isValidClientUseType(String useType) {
        return false;
    }

    public boolean hasEditor() {
        return this.fEditor != null && this.fEditorAreaStackLayout.topControl != this.fNoEditorWidgets;
    }

    private void createBoldFont(Composite parent) {
        FontData[] data = parent.getDisplay().getSystemFont().getFontData();
        FontData data0 = data[0];
        data0.setStyle(1);
        this.boldFont = new Font((Device)parent.getDisplay(), data0);
    }

    @Override
    public void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        super.dispose();
    }

    @Override
    protected void updateMarkers() {
        this.expressionLanguageLabel.clear();
        IMarker[] iMarkerArray = this.getMarkers(this.getInput());
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            if (!this.expressionLanguageLabel.getControl().isDisposed()) {
                this.expressionLanguageLabel.addStatus(BPELUtil.adapt((Object)m, IStatus.class));
            } else {
                new Throwable("FixMe: Why is update markers being called ?").printStackTrace();
            }
            ++n2;
        }
    }

    class ExpressionComboContentProvider
    extends ExpressionEditorDescriptorContentProvider {
        Object selectedObject = SAME_AS_PARENT;

        ExpressionComboContentProvider() {
        }

        @Override
        public Object[] getElements(Object inputElement) {
            Object[] descriptors = super.getElements(inputElement);
            ArrayList<Object> result = new ArrayList<Object>(descriptors.length + 2);
            if (ExpressionSection.this.isExpressionOptional() || this.selectedObject == NO_EXPRESSION) {
                result.add(NO_EXPRESSION);
            }
            if (this.selectedObject == SAME_AS_PARENT || this.allowItem(SAME_AS_PARENT)) {
                result.add(SAME_AS_PARENT);
            }
            Object[] objectArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                Object descriptor = objectArray[n2];
                if (ExpressionSection.objectsEqual(this.selectedObject, descriptor) || this.allowItem(descriptor)) {
                    result.add(descriptor);
                }
                ++n2;
            }
            if (!result.contains(this.selectedObject)) {
                result.add(this.selectedObject);
            }
            return result.toArray();
        }

        public boolean allowItem(Object element) {
            String language = ExpressionSection.this.getEffectiveLanguage(ExpressionSection.this.getExpressionLanguage(element));
            try {
                IExpressionEditor exEditor = BPELUIRegistry.getInstance().getExpressionEditor(language);
                return exEditor == null ? false : ExpressionSection.this.isEditorSupported(exEditor);
            }
            catch (CoreException e) {
                BPELUIPlugin.log(e);
                return false;
            }
        }
    }
}

