/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.Iterator;
import org.eclipse.bpel.ui.editparts.util.GraphAnimation;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class NonclippingXYLayout
extends XYLayout {
    private Point displacement = new Point(0, 0);
    private Dimension size;

    public Point getDisplacement() {
        return this.displacement;
    }

    public void layout(IFigure parent) {
        GraphAnimation.recordInitialState(parent);
        if (GraphAnimation.playbackState(parent)) {
            return;
        }
        Point offset = this.getOrigin(parent);
        this.refreshDisplacement(parent);
        for (IFigure f : parent.getChildren()) {
            Rectangle bounds = (Rectangle)this.getConstraint(f);
            if (bounds == null) continue;
            bounds = bounds.getTranslated(offset);
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension preferredSize = f.getPreferredSize();
                bounds = bounds.getCopy();
                if (bounds.width == -1) {
                    bounds.width = preferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = preferredSize.height;
                }
            }
            bounds = bounds.getTranslated(this.displacement);
            f.setBounds(bounds);
        }
    }

    public void refreshDisplacement(IFigure parent) {
        Iterator children = parent.getChildren().iterator();
        int minX = 0;
        int minY = 0;
        while (children.hasNext()) {
            IFigure f = (IFigure)children.next();
            Rectangle bounds = (Rectangle)this.getConstraint(f);
            if (bounds == null) continue;
            if (bounds.x < 0) {
                minX = Math.min(minX, bounds.x);
            }
            if (bounds.y >= 0) continue;
            minY = Math.min(minY, bounds.y);
        }
        this.displacement = new Point(-minX, -minY);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        Rectangle bounds = null;
        if (newConstraint != null) {
            bounds = ((Rectangle)newConstraint).getCopy();
            bounds.translate(-this.displacement.x, -this.displacement.y);
        }
        super.setConstraint(figure, (Object)bounds);
    }

    protected Dimension calculatePreferredSize(IFigure f, int wHint, int hHint) {
        Dimension result = super.calculatePreferredSize(f, wHint, hHint);
        if (this.size != null) {
            Dimension largest = new Dimension(this.size);
            largest.width = Math.max(result.width, this.size.width);
            largest.height = Math.max(result.height, this.size.height);
            return largest;
        }
        return result;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }
}

