/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CorrelationPattern implements Enumerator
{
    REQUEST_LITERAL(0, "request", "request"),
    RESPONSE_LITERAL(1, "response", "response"),
    REQUESTRESPONSE_LITERAL(2, "requestresponse", "request-response");

    public static final int REQUEST = 0;
    public static final int RESPONSE = 1;
    public static final int REQUESTRESPONSE = 2;
    private static final CorrelationPattern[] VALUES_ARRAY;
    public static final List<CorrelationPattern> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CorrelationPattern[]{REQUEST_LITERAL, RESPONSE_LITERAL, REQUESTRESPONSE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CorrelationPattern get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CorrelationPattern result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CorrelationPattern getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CorrelationPattern result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CorrelationPattern get(int value) {
        switch (value) {
            case 0: {
                return REQUEST_LITERAL;
            }
            case 1: {
                return RESPONSE_LITERAL;
            }
            case 2: {
                return REQUESTRESPONSE_LITERAL;
            }
        }
        return null;
    }

    private CorrelationPattern(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

